# Books on Tape scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripHTML
from    scrapers.scrapers import stripNewLines


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    format              = "Audio Book"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""


    # No place extraction default to US
    # place = "United States"


    source = searchForPlus(source, "<table width=\"600\"")


    # Find Image
    i = string.find(source, "/gif/biggif")

    if i > 0 and i <= 800:
        tempdata = stripText(source[i-25:])
        tempdata = searchForPlus(tempdata, "<img src=\"")
        i = string.find(tempdata, "\"")
        image = stripText(tempdata[0:i])

        i = string.find(image, "none.gif")

        if i != -1:
            image = ""

        if image != "":
            image = "http://www.booksontape.com" + image


    # Find Title
    source = searchForPlus(source, "size=\"4\"")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Author
    authorList = []
    source = searchForPlus(source, ">By ")
    source = searchForPlus(source, "<b>")

    if source.startswith("<a href="):
        source = searchForPlus(source, "\">")

    i = string.find(source, "<")
    author = stripText(source[0:i])
    i = string.rfind(author, " ")

    if (i != -1):
        author = stripText(author[i:]) + ", " + stripText(author[0:i])


    # Find copyright Date
    i = string.find(source, "(&copy;")

    if i != -1:
        copyDate = searchForPlus(source, "(&copy;")
        copyDate = stripText(copyDate)

        if copyDate.startswith("<a href="):
            copyDate = searchForPlus(copyDate, "\">")

        i = string.find(copyDate, "<")
        copyDate = stripText(copyDate[0:i])

        if fullDateFormat == "false":
            i = string.rfind(copyDate, " ")

            if i != -1:
                copyDate = stripText(copyDate[i+1:])


    # Find Published date
    i = string.find(source, "?rec_year")

    if i != -1:
        date = searchForPlus(source, "?rec_year")
        date = searchForPlus(date, ">")
        i = string.find(date, "<")
        date = stripText(date[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, " ")

            if i != -1:
                date = stripText(date[i+1:])


        # Find Publisher
        publisher = searchForPlus(source, "?rec_year")
        publisher = searchForPlus(publisher, ">")
        publisher = searchForPlus(publisher, ">")
        i = string.find(publisher, "<")
        publisher = stripText(publisher[0:i])


    # Find Read by (as author2)
    i = string.find(source, ">Read by ")

    if (i != -1):
        source = searchForPlus(source, ">Read by ")
        source = searchForPlus(source, "<b>")

        if source.startswith("<a href="):
            source = searchForPlus(source, "\">")

        i = string.find(source, "<")
        author2 = stripText(source[0:i])
        i = string.rfind(author2, " ")

        if (i != -1):
            author2 = stripText(author2[i:]) + ", " + stripText(author2[0:i])

        author2 = author2 + " (Read By)"


    # Find Category
    i = string.find(source, "/category.cfm")

    if (i != -1):
        category = searchForPlus(source, "/category.cfm")
        category = searchForPlus(category, "\">")
        i = string.find(category, "<")
        category = stripText(category[0:i])


    # Find Series
    i = string.find(source, "/series.cfm")

    if (i != -1):
        series = searchForPlus(source, "/series.cfm")
        series = searchForPlus(series, "\">")
        i = string.find(series, "<")
        series = stripText(series[0:i])


    # Find Price
    i = string.find(source, ">Purchase<")

    if i != -1:
        value = searchForPlus(source, ">Purchase<")
        value = searchFor(value, "$")
        i = string.find(value, "<")
        value = stripText(value[0:i])


    # Find Comments
    i = string.find(source, ">Editorial Review<")

    if (i != -1):
        comments = ""
        source = searchForPlus(source, ">Editorial Review<")
        source = searchForPlus(source, "<font")
        source = searchForPlus(source, "\">")
        i = string.find(source, "</font")
        comments = source[0:i]
        comments = string.replace(comments, "<p>", "")



try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
