# amazon.com scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripHTML
from    scrapers.scrapers import stripNewLines


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    format              = "Hardcover"
    weight              = ""


    i = string.find(source, "name=\"resultform\"")

    if i != -1:
        source = searchForPlus(source, "name=\"resultform\"")
        source = searchFor(source, "<a href=\"show")
        source = searchForPlus(source, "\"")
        i = string.find(source, "\"")
        url = "http://ask.bibsys.no/ask/action/" + stripText(source[0:i])
        http = HTTPConnection()
        http.resetReferer();
        http.blockForLoad();
        source = http.getContents(url)
        t2 = open("trace2.html", "w")
        t2.write(source)
        t2.close()


    # No place extraction default to US
    # place = "United States"


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Main extraction
    titleTag = ">Title:<"
    authorTag = ">Author:<"
    seriesTag = ">In series:<"
    dateTag = ">Year:<"
    pubTag = ">Printed:<"
    isbnTag = ">ISBN:<"
    pagesTag = ">Pages:<"
    keywordsTag = ">Subjects:<"

    i = string.find(source, titleTag)

    if i == -1:
        titleTag = ">Tittel:<"
        authorTag = ">Forfatter:<"
        seriesTag = ">I serie:<"
        dateTag = "rstall:<"
        pubTag = ">Trykt:<"
        isbnTag = ">ISBN:<"
        pagesTag = ">Sidetall:<"
        keywordsTag = ">Emner:<"


    # Find Title
    source = searchForPlus(source, titleTag)
    source = searchForPlus(source, "<b>")
    i = string.find(source, "<")
    title = stripText(source[0:i])

    i = string.find(title, " / ")

    if i != -1:
        title = stripText(title[0:i])

    title = string.replace(title, "\n", " ")


    # Find Series
    i = string.find(source, seriesTag)

    if i != -1:
        source = searchForPlus(source, seriesTag)
        source = searchForPlus(source, "<td ")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        series = stripText(source[0:i])


    # Find Author
    i = string.find(source, authorTag)
    authorList = []

    if i != -1:
        source = searchForPlus(source, authorTag)
        source = searchForPlus(source, "<td ")
        i = string.find(source, "</td>")
        authors = stripText(source[0:i])

        while (searchFor(authors, "class=\"normal\">") != None):
            authors = searchForPlus(authors, "class=\"normal\">")
            i = string.find(authors, "<")
            author = stripText(authors[0:i])

            authorList.append(author)


        if len(authorList) > 0:
            author = authorList[0]

        if len(authorList) > 1:
            author2 = authorList[1]

        if len(authorList) > 2:
            author3 = authorList[2]

        if len(authorList) > 3:
            author4 = authorList[3]

        if len(authorList) > 4:
            author5 = authorList[4]

        if len(authorList) > 5:
            author6 = authorList[5]

    if title != "" and len(authorList) == 0:
        author = "No Author"


    # Find Published date
    i = string.find(source, dateTag)

    if i != -1:
        source = searchForPlus(source, dateTag)
        source = searchForPlus(source, "<td ")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        date = stripText(source[0:i])

        i = string.find(date, "c")

        if i != -1:
            date = stripText(date[i+1:])
            copyDate = date


    # Find publication attributes
    i = string.find(source, pubTag)

    if i != -1:
        # Find Place
        source = searchForPlus(source, pubTag)
        source = searchForPlus(source, "<td ")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        attributes = stripText(source[0:i])
        i = string.find(attributes, ":")
        place = stripText(attributes[0:i])

        # Find Publisher
        publisher = stripText(attributes[i+1:])
        i = string.rfind(publisher, ",")

        if i != -1:
            publisher = stripText(publisher[0:i])


    # Find ISBN
    i = string.find(source, isbnTag)

    if i != -1:
        source = searchForPlus(source, isbnTag)
        source = searchForPlus(source, "<td ")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        isbn = stripText(source[0:i])

        # Find Value
        i = string.find(isbn, "$")

        if i != -1:
            value = searchFor(isbn, "$")
            isbn = stripText(isbn[0:i])

        i = string.find(isbn, ",")

        if i != -1:
            isbn = stripText(isbn[0:i])

        isbn = string.replace(isbn, "-", "")


    # Find pages
    i = string.find(source, pagesTag)

    if i != -1:
        source = searchForPlus(source, pagesTag)
        source = searchForPlus(source, "<td ")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        pages = stripText(source[0:i])

        while (string.find(pages, " ") != -1):
            i = string.find(pages, " ")

            try:
                int(pages[0:i])
                pages = stripText(pages[0:i])
            except:
                pages = stripText(pages[i+1:])


    # Find keywords
    i = string.find(source, keywordsTag)

    if i != -1:
        keywords = ""
        source = searchForPlus(source, keywordsTag)
        source = searchForPlus(source, "<td ")
        i = string.find(source, "</td>")
        subjects = stripText(source[0:i])

        while (searchFor(subjects, "class=\"normal\">") != None):
            subjects = searchForPlus(subjects, "class=\"normal\">")
            i = string.find(subjects, "<")
            subject = stripText(subjects[0:i])

            if keywords != "":
                keywords = keywords + ", " + subject
            else:
                keywords = subject



try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
