# amazon.com scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripHTML
from    scrapers.scrapers import stripNewLines


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""


    # No place extraction default to US
    # place = "United States"


    # Find optional fields, pricing info etc.
    marketinfo = source

    # Find List price
    i = string.find(marketinfo, "listprice_start -->")

    if (i != -1):
        listprice = searchForPlus(marketinfo, "listprice_start -->")
        i = string.find(listprice, "<")
        listprice = stripText(listprice[0:i])


    # Main extraction
    source = searchForPlus(source, "<!-- Begin Page Data -->")

    # Find Title
    source = searchForPlus(source, "title_start -->")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Image
    i = string.find(source, "thumb")

    if (i != -1):
        source = searchForPlus(source, "thumb")
        source = searchForPlus(source, " src=\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])


    # Find Author
    i = string.find(source, "author_start -->")

    if i != -1:
        source = searchForPlus(source, "author_start -->")
        i = string.find(source, "<")
        authors = stripText(source[0:i]) +  "/"
        authorList = []

        while (searchFor(authors, "/") != None):
            i = string.find(authors, "/")
            author = stripText(authors[0:i])
            authorList.append(author)
            authors = searchForPlus(authors, "/")


    if len(authorList) > 0:
        author = authorList[0]

    if len(authorList) > 1:
        author2 = authorList[1]

    if len(authorList) > 2:
        author3 = authorList[2]

    if len(authorList) > 3:
        author4 = authorList[3]

    if len(authorList) > 4:
        author5 = authorList[4]

    if len(authorList) > 5:
        author6 = authorList[5]


    # Find Value
    i = string.find(source, "vendorprice_start -->")

    if i != -1:
        source = searchForPlus(source, "vendorprice_start -->")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find Publisher
    i = string.find(source, "publisher_start -->")

    if i != -1:
        source = searchForPlus(source, "publisher_start -->")
        i = string.find(source, "<")
        publisher = stripText(source[0:i])


    # Find Published date
    i = string.find(source, "pubdate_start -->")

    if i != -1:
        source = searchForPlus(source, "pubdate_start -->")
        i = string.find(source, "<")
        date = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, " ")

            if i != -1:
                date = stripText(date[i+1:])


    # Find Dimensions
    i = string.find(source, ">Dimensions:")

    if i != -1:
        source = searchForPlus(source, ">Dimensions:")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        dimensions = stripHTML(source[0:i])


    # Find Format
    i = string.find(source, "binding_start -->")

    if i != -1:
        source = searchForPlus(source, "binding_start -->")
        i = string.find(source, "<")
        format = stripText(source[0:i])


    # Find Pages
    i = string.find(source, ">Pages:")

    if i != -1:
        source = searchForPlus(source, ">Pages:")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        pages = stripText(source[0:i])


    # Find Category
    i = string.find(source, ">Category:")

    if i != -1:
        source = searchForPlus(source, ">Category:")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        category = stripText(source[0:i])


    # Find ISBN
    i = string.find(source, "isbn_start -->")

    if i != -1:
        source = searchForPlus(source, "isbn_start -->")
        i = string.find(source, "<")
        isbn = stripText(source[0:i])


try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
