# British Library (Online Public Access Catalogue, OPAC) scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""

    # No reliable place extraction default to UK
    # place = "United Kingdom"


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Main extraction
    # Find ISBN
    i = string.find(source, "<B>ISBN</B>")

    if i != -1:
        source = searchForPlus(source, "<B>ISBN</B>")
        source = searchForPlus(source, "<TD>")
        i = string.find(source, "<BR>")
        isbn = stripText(source[0:i])
        i = string.find(isbn, "&nbsp;")

        if i != -1:
            isbn = stripText(isbn[0:i])

    # Find Author
    source = searchForPlus(source, "<B>Author</B>")
    source = searchForPlus(source, "<TD>")
    i = string.find(source, "<BR>")
    author = stripText(source[0:i])

    if (string.count(author, "&nbsp;") > 1):
        i = string.rfind(author, "&nbsp;")
        author = stripText(author[0:i])

    i = string.find(author, "&nbsp;")
    authorlast = stripText(author[0:i])
    authorfirst = searchForPlus(author, "&nbsp;")
    author = stripText(authorlast) + ", " + stripText(authorfirst)

    # Find Title
    source = searchForPlus(source, "<B>Title</B>")
    source = searchForPlus(source, "<TD>")
    i = string.find(source, "<BR>")
    title = stripText(source[0:i])
    i = string.find(title, "&nbsp;")

    if i != -1:
        title = stripText(title[0:i])


    # Find Publisher and date
    source = searchForPlus(source, "<B>Publisher</B>")
    source = searchForPlus(source, "<TD>")
    i = string.find(source, "<BR>")
    publisher = stripText(source[0:i])
    i = string.rfind(publisher, "&nbsp;")

    if i != -1:
        date = stripText(publisher[i+6:])
        publisher = stripText(publisher[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, " ")

            if i != -1:
                date = stripText(date[0:i])

            i = string.rfind(date, ",")

            if i != -1:
                date = stripText(date[0:i])

    i = string.find(publisher, "&nbsp;")

    if i != -1:
        publisher = stripText(publisher[i+6:])


    # Find Category
    i = string.find(source, "<B>Subject ")

    if i != -1:
        source = searchForPlus(source, "<B>Subject ")
        source = searchForPlus(source, "<TD>")
        i = string.find(source, "<BR>")
        category = stripText(source[0:i])



try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
