# nolau.com scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source
    global callnumber


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Main extraction
    # No format
    format = "Hardcover"


    # Find Author
    i = string.find(source, ">Author:<")

    if i != -1:
        source = searchForPlus(source, ">Author:<")
        source = searchForPlus(source, "<TD")
        source = searchForPlus(source, ">")

        if source.startswith("\n<A "):
            source = searchForPlus(source, "\">")
        
        i = string.find(source, "</TD>")
        author = stripText(source[0:i])
        author = string.replace(author, "</A>", "")
        author = string.replace(author, "<STRONG>", "")
        author = string.replace(author, "</STRONG>", "")
        author = string.replace(author, "<I>", "")
        author = string.replace(author, "</I>", "")

        if string.find(author, ", ") != string.rfind(author, ", "):
            i = string.rfind(author, ", ")

            if (i != -1):
                author = stripText(author[0:i])
    else:
        i = string.find(source, ">Other authors:")

        if i != -1:
            tempdata = searchForPlus(source, ">Other authors:")
            tempdata = searchForPlus(tempdata, "<TD")
            tempdata = searchForPlus(tempdata, ">")
            i = string.find(tempdata, "<")
            author = stripText(tempdata[0:i])

            if string.find(author, ", ") != string.rfind(author, ", "):
                i = string.rfind(author, ", ")

                if (i != -1):
                    author = stripText(author[0:i])
        else:
            author = "No Author"


    # Find Title
    source = searchForPlus(source, ">Title:<")
    source = searchForPlus(source, "<TD")
    source = searchForPlus(source, ">")
    i = string.find(source, "</TD>")
    title = stripText(source[0:i])
    title = string.replace(title, "<STRONG>", "")
    title = string.replace(title, "</STRONG>", "")
    title = string.replace(title, "<I>", "")
    title = string.replace(title, "</I>", "")
    title = string.replace(title, "&rsquo;", "'")

    i = string.find(title, "  ")

    if (i != -1):
        title = stripText(title[0:i])


    # Find Publication Data
    source = searchForPlus(source, ">Publisher:<")
    source = searchForPlus(source, "<TD")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    pubdata = stripText(source[0:i])

    i = string.find(pubdata, ":")

    if (i != -1):
        place = stripText(pubdata[0:i])
        pubdata = pubdata[i+1:]

    i = string.find(pubdata, ",")

    if (i == -1):
        publisher = pubdata
    else:
        publisher = stripText(pubdata[0:i])
        date = stripText(pubdata[i+1:])

    i = string.find(place, "[")

    if (i != -1):
        place = stripText(place[i+1:])

    i = string.find(place, "]")

    if (i != -1):
        place = stripText(place[0:i])

    i = string.find(date, "[")

    if (i != -1):
        date = stripText(date[i+1:])

    i = string.find(date, "]")

    if (i != -1):
        date = stripText(date[0:i])

    i = string.find(date, ".")

    if (i != -1):
        date = stripText(date[0:i])

    i = string.find(date, ",")

    copyDate = ""

    if (i != -1):
        copyDate = stripText(date[i+1:])
        date = stripText(date[0:i])

    i = string.find(copyDate, "c")

    if (i != -1):
        copyDate = stripText(copyDate[i+1:])

    i = string.find(date, "c")

    if (i != -1):
        date = stripText(date[i+1:])


    # Find Pages/Dimensions
    source = searchForPlus(source, ">Description:<")
    source = searchForPlus(source, "<TD")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    descdata = stripText(source[0:i])

    i = string.find(descdata, ";")

    if (i == -1):
        pages = descdata
    else:
        pages = stripText(descdata[0:i])
        dimensions = stripText(descdata[i+1:])

    i = string.find(pages, " ")

    if (i != -1):
        pages = stripText(pages[0:i])


    # Find ISBN
    i = string.find(source, ">ISBN:<")

    if (i != -1):
        source = searchForPlus(source, ">ISBN:<")
        source = searchForPlus(source, "<TD")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        isbn = stripText(source[0:i])

        i = string.find(isbn, " ")

        if (i != -1):
            isbn = stripText(isbn[0:i])


    # Find Comments
    i = string.find(source, ">Summary:<")
    comments = ""

    if (i != -1):
        source = searchForPlus(source, ">Summary:<")
        source = searchForPlus(source, "<TD")
        source = searchForPlus(source, ">")
        i = string.find(source, "</TD>")
        comments = stripText(source[0:i])


    i = string.find(source, ">Notes:<")

    if (i != -1):
        source = searchForPlus(source, ">Notes:<")
        source = searchForPlus(source, "<TD")
        source = searchForPlus(source, ">")
        i = string.find(source, "</TD>")

        if comments == "":
            comments = stripText(source[0:i])
        else:
            comments = comments + "<BR><BR>" + stripText(source[0:i])

    comments = string.replace(comments, "\n ", "")
    comments = string.replace(comments, "\n", "")
    comments = string.replace(comments, "<BR>", "\n")
    comments = string.replace(comments, "&rsquo;", "'")


    # Find Category
    i = string.find(source, ">Subjects:<")

    if (i != -1):
        source = searchForPlus(source, ">Subjects:<")
        source = searchForPlus(source, "<TD")
        source = searchForPlus(source, ">")
        i = string.find(source, "</TR>")
        categories = stripText(source[0:i])

        category = ""

        while (searchFor(categories, "HREF=") != None):
                categories = searchForPlus(categories, "HREF=")
                categories = searchForPlus(categories, ">")
                i = string.find(categories, "<")

                category = category + stripText(categories[0:i])
                categories = categories[i:]



    # Find call number
    i = string.find(source, ">Call Number:<")

    if i != -1:
        source = searchForPlus(source, ">Call Number:<")
        source = searchForPlus(source, "<TD")
        source = searchForPlus(source, ">")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        callnumber = stripText(source[0:i])





try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
