# Library of Congress scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripTelnetCodes
from    scrapers.scrapers import getTelnetLine


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Main extraction
    # Find Author (it is possible to have no author line, in
    # which case I will assume "Various", i.e. a collection with no
    # specific author
    author = "Various"

    i = string.find(source, "100 ")

    if (i != -1):
        source = searchForPlus(source, "100 ")
        i = string.find(source, "\r")
        author = stripText(source[0:i])

        # Remove , pseud if present.
        if (string.count(author, ",") > 1):
            i = string.find(author, ",")
            i = string.find(author, ",", i+1)
            author = author[0:i]

        # Remove trailing period, if present
        i = string.rfind(author, ".")

        if (i != -1):
            x = i - 2

            if (x >= 2):
                if (author[x:x+1] != ' '):
                    if (len(author) == (i + 1)):
                        author = author[0:i]
            else:
                if (len(author) == (i + 1)):
                    author = author[0:i]


    # Find Title
    source = searchForPlus(source, "245")
    str = getTelnetLine(source)
    title = stripText(str)
    i = string.find(title, " / ")

    if (i != -1):
        title = stripText(title[0:i])

    # Remove trailing period, if present
    i = string.rfind(title, ".")

    if (i != -1):
        if (len(title) == (i + 1)):
            title = title[0:i]


    # Find Place
    source = searchForPlus(source, "260")
    i = string.find(source, "\n")
    place = stripText(source[0:i])
    i = string.find(place, " : ")

    if (i != -1):
        place = stripText(place[0:i])
    else:
        i = string.find(place, ", ")

        if (i != -1):
            place = stripText(place[0:i])



    # Find Publisher
    i = string.find(source, "\n")
    templine = stripText(source[0:i])

    i = string.find(templine, " : ")

    if (i != -1):
        templine = stripText(templine[i+2:])

    i = string.rfind(templine, ",")

    if (i != -1):
        publisher = stripText(templine[0:i])
    else:
        publisher = templine


    # Find Publication Date
    if (i != -1):
        templine = templine[i+1:]
        i = string.find(templine, ".")
        date = stripTelnetCodes(templine[0:i])

        # if date in format cyyyy, strip c
        if (len(date) == 5):
            i = string.find(date, "c")

            if (i == 0):
                date = stripText(date[1:])


    # Find ISBN
    source = searchForPlus(source, "020")
    source = searchForPlus(source, "ISBN")
    i = string.find(source, "\r")
    isbn = stripText(source[0:i])


    # Find format (only look for paperback)
    i = string.find(isbn, "pbk.")

    if (i != -1):
        format = "P"

    # Find Value (and remove from isbn)
    i = string.find(isbn, ":")

    if (i != -1):
        value = stripText(isbn[i+1:])
        value = stripTelnetCodes(value)
        isbn = stripText(isbn[0:i])

        i = string.find(value, "(")

        if (i != -1):
            value = stripText(value[0:i])


    # Find Category
    source = searchForPlus(source, "655 ")

    if (source != None):
        i = string.find(source, "\n")
        category = stripText(source[0:i])
        i = string.rfind(category, ".")

        if (i != -1):
            category = stripText(category[0:i])




try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
