# Library of Congress scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import calcISBN10CheckDigit
from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripHTML
from    scrapers.scrapers import stripNewLines
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripTelnetCodes


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source
    global callnumber


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Looking for the ISBN I searched for. LOC
    # can return multiple ISBNs for the same listing
    # want to get the correct format.
    searchISBN = ""
    i = string.find(source, "Guided Search = (")

    if i != -1:
        searchISBN = searchForPlus(source, "Guided Search = (")
        i = string.find(searchISBN, ")")
        searchISBN = stripText(searchISBN[0:i])


    # Main extraction

    # Looking for duplicate LCCN matches, take one with LCCN only, no prefix.
    while (string.find(source, ">[&nbsp;") != -1):
        i = string.find(source, ">[&nbsp;")

        if (i != -1):
            source = stripText(source[i-500:])
            source = searchForPlus(source, "<A HREF=\"")
            i = string.find(source, "\"")
            url = "http://catalog.loc.gov" + stripText(source[0:i])
            http = HTTPConnection()
            http.resetReferer();
            http.blockForLoad();
            newsource = http.getContents(url)
            i = string.find(newsource, ">LC Control No.:<")
            lccndata = newsource[i:i+100]
            i = string.find(lccndata, "   <STRONG>")

            if i != -1:
                source = newsource
                break

            source = searchForPlus(source, ">[&nbsp;")
            t2 = open("trace2.html", "w")
            t2.write(source)
            t2.close()
            

    # Determine page format
    i = string.find(source, "view1a.gif")

    if (i != -1):
        source = searchForPlus(source, "view2.gif")
        source = searchForPlus(source, "<A HREF=\"")
        i = string.find(source, "\"")
        url = "http://catalog.loc.gov" + stripText(source[0:i])
        http = HTTPConnection()
        http.resetReferer();
        http.blockForLoad();
        source = http.getContents(url)
        t3 = open("trace3.html", "w")
        t3.write(source)
        t3.close()


    # Find Title
    source = searchForPlus(source, "view3a.gif")
    source = searchForPlus(source, "<STRONG>")
    source = searchForPlus(source, "\">")
    i = string.find(source, "<")
    title = stripText(source[0:i])
    i = string.find(title, " / ")

    if (i != -1):
        title = stripText(title[0:i])

    # Remove Translated by, if present.
    i = string.find(title, ". Translated")

    if (i != -1):
        title = title[0:i]

    # Remove trailing period, if present
    i = string.rfind(title, ".")

    if (i != -1):
        if (len(title) == (i + 1)):
            title = title[0:i]


    # Find LCCN
    i = string.find(source, ">LC Control No.:<")

    if i != -1:
        source = searchForPlus(source, ">LC Control No.:<")
        source = searchForPlus(source, "<TD")
        source = searchForPlus(source, ">")
        i = string.find(source, "</TD>")
        lccn = stripHTML(source[0:i])
        lccn = string.replace(lccn, "<STRONG>", "")
        lccn = string.replace(lccn, "</STRONG>", "")
        lccn = string.replace(lccn, "<I>", "")
        lccn = string.replace(lccn, "</I>", "")
        lccn = stripNewLines(lccn)


    # Find Author (it is possible to have no author line, in
    # which case I will assume "Various", i.e. a collection with no
    # specific author
    author = ""
    author2 = ""
    i = string.find(source, ">Personal Name:<")

    if (i != -1):
        source = searchForPlus(source, ">Personal Name:<")
        source = searchForPlus(source, "<TD")
        source = searchForPlus(source, ">")
        i = string.find(source, "</TD>")
        authorTemp = stripText(source[0:i])
        author = ""

        authorTemp = string.replace(authorTemp, "<STRONG>", "")
        authorTemp = string.replace(authorTemp, "</STRONG>", "")
        authorTemp = string.replace(authorTemp, "<I>", "")
        authorTemp = string.replace(authorTemp, "</I>", "")
        authorTemp = searchForPlus(authorTemp, "HREF=")
        authorTemp = searchForPlus(authorTemp, ">")
        i = string.find(authorTemp, "<")
        author = stripText(author + " " + authorTemp[0:i])

        # Remove , pseud if present.
        if (string.count(author, ",") > 1):
            i = string.find(author, ",")
            i = string.find(author, ",", i+1)
            author = author[0:i]

        # Remove trailing period, if present
        i = string.rfind(author, ".")

        if (i != -1):
            x = i - 2

            if (x >= 2):
                if (author[x:x+1] != ' '):
                    if (len(author) == (i + 1)):
                        author = author[0:i]
            else:
                if (len(author) == (i + 1)):
                    author = author[0:i]

        if author[len(author) - 1] == ",":
            author = author[0: len(author)-1]

    i = string.find(source, ">Related Names:<")

    if (i != -1):
        temp = searchForPlus(source, ">Related Names:<")
        temp = searchForPlus(temp, "<TD")
        temp = searchForPlus(temp, ">")
        i = string.find(temp, "</TD>")
        authorTemp = stripText(temp[0:i])
        temp = ""
        authorTemp = string.replace(authorTemp, "<STRONG>", "")
        authorTemp = string.replace(authorTemp, "</STRONG>", "")
        authorTemp = string.replace(authorTemp, "<I>", "")
        authorTemp = string.replace(authorTemp, "</I>", "")
        authorTemp = searchForPlus(authorTemp, "HREF=")
        authorTemp = searchForPlus(authorTemp, ">")
        i = string.find(authorTemp, "<")
        temp = stripText(temp + " " + authorTemp[0:i])

        # Remove , pseud if present.
        if (string.count(temp, ",") > 1):
            i = string.find(temp, ",")
            i = string.find(temp, ",", i+1)
            temp = temp[0:i]

        # Remove trailing period, if present
        i = string.rfind(temp, ".")

        if (i != -1):
            x = i - 2

            if (x >= 2):
                if (temp[x:x+1] != ' '):
                    if (len(temp) == (i + 1)):
                        temp = temp[0:i]
            else:
                if (len(temp) == (i + 1)):
                    temp = temp[0:i]

        if temp[len(temp) - 1] == ",":
            temp = temp[0: len(temp)-1]

        if temp != "":
            if author == "":
                author = temp
            else:
                author2 = temp


    # Find Place
    i = string.find(source, ">Published/Created:<")

    if (i != -1):
        source = searchForPlus(source, ">Published/Created:<")
        source = searchForPlus(source, "<TD")
        source = searchForPlus(source, ">")
        i = string.find(source, "</TD>")
        place = stripText(source[0:i])
        i = string.find(place, " : ")

        if (i != -1):
            place = stripText(place[0:i])
            i = string.find(source, " : ")
            source = source[i+2:]
        else:
            i = string.find(place, "., ")

            if (i != -1):
                place = stripText(place[0:i+1])
                source = source[i+2:]
            else:
                i = string.find(place, ", ")

                if (i != -1):
                    place = stripText(place[0:i])
                    i = string.find(source, ", ")
                    source = source[i+1:]

        place = string.replace(place, "<STRONG>", "")
        place = string.replace(place, "</STRONG>", "")
        place = string.replace(place, "<I>", "")
        place = string.replace(place, "</I>", "")


        # Find Publisher
        publisher = ""
        i = string.find(source, "</TD>")
        templine = stripText(source[0:i])

        i = string.find(templine, " : ")

        if (i != -1):
            templine = stripText(templine[i+2:])

        i = string.rfind(templine, ",")

        if (i != -1):
            publisher = stripText(templine[0:i])
            templine = templine[i+1:]
        else:
            i = string.rfind(templine, "[")

            if (i != -1):
                publisher = stripText(templine[0:i])
                templine = templine[i:]
            else:
                publisher = templine

        publisher = string.replace(publisher, "&rsquo;", "'")


        # Find Publication Date
        i = string.find(templine, ".")

        if (i != -1):
            date = stripTelnetCodes(templine[0:i])
        else:
            date = templine

        i = string.find(date, "[")

        if (i != -1):
            date = stripText(date[i+1:])

        i = string.find(date, "]")

        if (i != -1):
            date = stripText(date[0:i])

        # if date in format cyyyy, strip c
        if (len(date) == 5):
            i = string.find(date, "c")

            if (i == 0):
                date = stripText(date[1:])
                copyDate = date

        if fullDateFormat == "false":
            i = string.rfind(date, " ")

            if i != -1:
                date = stripText(date[i+1:])


    # Find Pages
    i = string.find(source, ">Description:<")

    if i != -1:
        source = searchForPlus(source, ">Description:<")
        source = searchForPlus(source, "<TD")
        source = searchForPlus(source, ">")
        i = string.find(source, "</TD>")
        descline = stripText(source[0:i])
        i = string.find(descline, "p.")

        if (i != -1):
            pages = stripText(descline[0:i])

            i = string.rfind(pages, " ")

            if (i != -1):
                pages = stripText(pages[i:])


        # Find Dimensions
        dimensions = descline
        i = string.find(dimensions, ";")

        if (i != -1):
            dimensions = stripText(dimensions[i+1:])

        i = string.find(dimensions, "<BR>")

        if (i != -1):
            dimensions = stripText(dimensions[0:i])

        i = string.find(dimensions, "illus.")

        if (i != -1):
            dimensions = stripText(dimensions[i+6:])

        if dimensions == "cm.":
            dimensions = ""


    # Find ISBN
    i = string.find(source, ">ISBN:<")

    if i != -1:
        source = searchForPlus(source, ">ISBN:<")
        print "ISBN=",source[0:100]

        if searchISBN != "":
            i = string.find(source, searchISBN)

            if i != -1:
                source = stripText(source[i-30:])
            
        print "ISBN=",source[0:100]
        source = searchForPlus(source, "<TD ")
        source = searchForPlus(source, ">")
        i = string.find(source, "</TD>")
        isbn = stripText(source[0:i])

        i = string.find(isbn, "<STRONG><I>")

        if (i != -1):
            isbn = stripText(isbn[i+11:])

        # Find format (only look for paperback)
        i = string.find(isbn, "pbk")

        if (i != -1):
            format = "Paperback"
        else:
            format = "Hardcover"

        i = string.find(isbn, "<")

        if (i != -1):
            isbn = stripText(isbn[0:i])

        i = string.find(isbn, " ")

        if (i != -1):
            isbn = stripText(isbn[0:i])

        if isbn.startswith("978") == 1:
            isbn = isbn[3:]
            isbn = stripText(isbn[0:len(isbn)-1])
            isbn = calcISBN10CheckDigit(isbn)



    # Find Comments
    i = string.find(source, ">Notes:<")

    if (i != -1):
        source = searchForPlus(source, ">Notes:<")
        source = searchForPlus(source, "<TD")
        source = searchForPlus(source, ">")
        i = string.find(source, "</TD>")
        comments = stripText(source[0:i])

        comments = string.replace(comments, "<BR>", "\n")


    # Find Keywords
    i = string.find(source, ">Subjects:<")

    if (i != -1):
        temp = searchForPlus(source, ">Subjects:<")
        i = string.find(temp, "<TH")
        temp = stripText(temp[0:i])
        keywords = ""

        while (searchFor(temp, "HREF") != None):
            temp = searchForPlus(temp, "HREF")
            temp = searchForPlus(temp, "\">")
            i = string.find(temp, "<")
            keyword = stripText(temp[0:i])
            i = string.rfind(keyword, ".")

            if (i != -1):
                keyword = stripText(keyword[0:i])

            if keywords != "":
                keywords = keywords + ", " + keyword
            else:
                keywords = keyword

        keywords = string.replace(keywords, "&rsquo;", "'")


    # Find Category
    i = string.find(source, ">Form/Genre:<")

    if (i != -1):
        source = searchForPlus(source, ">Form/Genre:<")
        source = searchForPlus(source, "<TD")
        source = searchForPlus(source, ">")
        source = searchForPlus(source, "HREF=")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        category = stripText(source[0:i])

        i = string.rfind(category, ".")

        if (i != -1):
            category = stripText(category[0:i])
    else:
        i = string.find(source, ">Subjects:<")

        if (i != -1):
            source = searchForPlus(source, ">Subjects:<")
            source = searchForPlus(source, "HREF")
            source = searchForPlus(source, "\">")
            i = string.find(source, "<")
            category = stripText(source[0:i])
            i = string.rfind(category, ".")

            if (i != -1):
                category = stripText(category[0:i])


    # Find Series
    i = string.find(source, ">Series:<")

    if (i != -1):
        source = searchForPlus(source, ">Series:<")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        series = stripText(source[0:i])


    # Find LOC Call Number
    i = string.find(source, "LC Classification:")

    if (i != -1):
        source = searchForPlus(source, "LC Classification:")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        callnumber = stripText(source[0:i])


    # Find Dewey Number
    i = string.find(source, ">Dewey Class No.:<")

    if (i != -1):
        source = searchForPlus(source, ">Dewey Class No.:<")
        source = searchForPlus(source, "<TD")
        source = searchForPlus(source, ">")
        i = string.find(source, "</TD>")
        dewey = stripText(source[0:i])


    # Find Series
    i = string.find(source, "Series:  ")

    if (i != -1):
        source = searchForPlus(source, "Series:  ")
        i = string.find(source, "\n")
        series = stripText(source[0:i])
        source = source[i+1:]

        while (source[0:5] == "     "):
            i = string.find(source, "\n")
            series = series + " " + stripText(source[0:i])
            source = source[i+1:]


    # If I got this far, I have extracted basic info. I might not have an author,
    # set to various.
    if author == "":
        author = "Various"




try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
