# Library of Congress scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import calcISBN10CheckDigit
from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripTelnetCodes


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source
    global callnumber


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""


    # Determine page format
    i = string.find(source, ">More on this record<")

    if (i != -1):
        source = searchForPlus(source, "<A HREF=\"")
        i = string.find(source, "\"")
        url = "http://lcweb.loc.gov" + stripText(source[0:i])
        http = HTTPConnection()
        http.resetReferer();
        http.blockForLoad();
        source = http.getContents(url)
        t2 = open("trace2.html", "w")
        t2.write(source)
        t2.close()


    # Looking for the ISBN I searched for. LOC
    # can return multiple ISBNs for the same listing
    # want to get the correct format.
    searchISBN = ""
    i = string.find(source, "<TITLE>VOYAGER[")

    if i != -1:
        searchISBN = searchForPlus(source, "<TITLE>VOYAGER[")
        i = string.find(searchISBN, "[")
        searchISBN = stripText(searchISBN[0:i])


    # Looking for duplicate LCCN matches, take last.
    i = string.find(source, ">Records 1 through")

    if (i != -1):
        i = string.rfind(source, "<HR><PRE>")
        source = stripText(source[i:])


    # Find optional fields, pricing info etc.
    marketinfo = source

    # Main extraction
    # Find Author
    author = ""
    author2 = ""
    i = string.find(source, "Author:")

    if (i != -1):
        source = searchForPlus(source, "Author:")
        i = string.find(source, "\n")
        author = stripText(source[0:i])

        # Remove , pseud if present.
        if (string.count(author, ",") > 1):
            i = string.find(author, ",")
            i = string.find(author, ",", i+1)
            author = author[0:i]

        # Remove trailing period, if present
        i = string.rfind(author, ".")

        if (i != -1):
            x = i - 2

            if (x >= 2):
                if (author[x:x+1] != ' '):
                    if (len(author) == (i + 1)):
                        author = author[0:i]
            else:
                if (len(author) == (i + 1)):
                    author = author[0:i]

    i = string.find(source, "Other authors:")

    if (i != -1):
        authortemp = searchForPlus(source, "Other authors:")
        i = string.find(authortemp, "\n")
        authortemp = stripText(authortemp[0:i])

        # Remove , pseud if present.
        if (string.count(authortemp, ",") > 1):
            i = string.find(authortemp, ",")
            i = string.find(authortemp, ",", i+1)
            authortemp = authortemp[0:i]

        # Remove trailing period, if present
        i = string.rfind(authortemp, ".")

        if (i != -1):
            x = i - 2

            if (x >= 2):
                if (authortemp[x:x+1] != ' '):
                    if (len(authortemp) == (i + 1)):
                        authortemp = authortemp[0:i]
            else:
                if (len(authortemp) == (i + 1)):
                    authortemp = authortemp[0:i]

        if authortemp != "":
            if author == "":
                author = authortemp
            else:
                author2 = authortemp


    # Find Title
    source = searchForPlus(source, "Title:     ")
    i = string.find(source, "\n")
    title = stripText(source[0:i])
    source = source[i+1:]

    while (source[0:5] == "     "):
        i = string.find(source, "\n")
        title = title + " " + stripText(source[0:i])
        source = source[i+1:]

    i = string.find(title, " / ")

    if (i != -1):
        title = stripText(title[0:i])

    # Remove Translated by, if present.
    i = string.find(title, ". Translated")

    if (i != -1):
        title = title[0:i]

    # Remove trailing period, if present
    i = string.rfind(title, ".")

    if (i != -1):
        if (len(title) == (i + 1)):
            title = title[0:i]


    # Find Place
    source = searchForPlus(source, "Published:")
    i = string.find(source, "\n")
    place = stripText(source[0:i])
    i = string.find(place, " : ")

    if (i != -1):
        place = stripText(place[0:i])
        i = string.find(source, " : ")
        source = source[i+2:]
    else:
        i = string.find(place, "., ")

        if (i != -1):
            place = stripText(place[0:i+1])
            i = string.find(source, "., ")
            source = source[i+2:]
        else:
            i = string.find(place, ", ")

            if (i != -1):
                place = stripText(place[0:i])
                i = string.find(source, ", ")
                source = source[i+1:]


    # Find Publisher
    i = string.find(source, "\n")
    templine = stripText(source[0:i])

    i = string.find(templine, " : ")

    if (i != -1):
        templine = stripText(templine[i+2:])

    i = string.rfind(templine, ",")

    if (i != -1):
        publisher = stripText(templine[0:i])
        templine = templine[i+1:]
    else:
        i = string.rfind(templine, "[")

        if (i != -1):
            publisher = stripText(templine[0:i])
            templine = templine[i:]
        else:
            publisher = templine


    # Find Publication Date
    i = string.find(templine, ".")

    if (i != -1):
        date = stripTelnetCodes(templine[0:i])
    else:
        date = templine

    i = string.find(date, "[")

    if (i != -1):
        date = stripText(date[i+1:])

    i = string.find(date, "]")

    if (i != -1):
        date = stripText(date[0:i])

    # if date in format cyyyy, strip c
    if (len(date) == 5):
        i = string.find(date, "c")

        if (i == 0):
            date = stripText(date[1:])

    if fullDateFormat == "false":
        i = string.rfind(date, " ")

        if i != -1:
            date = stripText(date[i+1:])


    # Find Pages
    i = string.find(source, "Description:")

    if i != -1:
        source = searchForPlus(source, "Description:")
        i = string.find(source, "\n")
        descline = stripText(source[0:i])
        i = string.find(descline, "p.")

        if (i != -1):
            pages = stripText(descline[0:i])

            i = string.rfind(pages, " ")

            if (i != -1):
                pages = stripText(pages[i:])


        # Find Dimensions
        dimensions = descline
        i = string.find(dimensions, ";")

        if (i != -1):
            dimensions = stripText(dimensions[i+1:])

        i = string.find(dimensions, "illus.")

        if (i != -1):
            dimensions = stripText(dimensions[i+6:])

        if dimensions == "cm.":
            dimensions = ""


    # Find Series
    i = string.find(source, "Series:  ")

    if (i != -1):
        source = searchForPlus(source, "Series:  ")
        i = string.find(source, "\n")
        series = stripText(source[0:i])
        source = source[i+1:]

        while (source[0:5] == "     "):
            i = string.find(source, "\n")
            series = series + " " + stripText(source[0:i])
            source = source[i+1:]


    # Find LOC Call Number
    i = string.find(source, "LC Call No.:")

    if (i != -1):
        source = searchForPlus(source, "LC Call No.:")
        i = string.find(source, "\n")
        callnumber = stripText(source[0:i])


    # Find Dewey Number
    i = string.find(source, "Dewey No.:")

    if (i != -1):
        source = searchForPlus(source, "Dewey No.:")
        i = string.find(source, "\n")
        dewey = stripText(source[0:i])


    # Find ISBN
    i = string.find(source, "ISBN:")

    if i != -1:
        source = searchForPlus(source, "ISBN:")

        if searchISBN != "":
            i = string.find(source, searchISBN)

            if i != -1:
                source = searchFor(source, searchISBN);
            
        i = string.find(source, "\n")
        isbn = stripText(source[0:i])


        # Find format (only look for paperback)
        i = string.find(isbn, "pbk")

        if (i != -1):
            format = "Paperback"
        else:
            format = "Hardcover"

        i = string.find(isbn, " ")

        if (i != -1):
            isbn = stripText(isbn[0:i])

        if isbn.startswith("978") == 1:
            isbn = isbn[3:]
            isbn = stripText(isbn[0:len(isbn)-1])
            isbn = calcISBN10CheckDigit(isbn)


    # Find Comments
    i = string.find(source, "Notes:")

    if (i != -1):
        source = searchForPlus(source, "Notes:")
        i = string.find(source, "<")
        comments = stripText(source[0:i])
        i = string.find(comments, "Subjects:")

        if (i != -1):
            comments = stripText(comments[0:i])

        i = string.find(comments, "Control No.:")

        if (i != -1):
            comments = stripText(comments[0:i])

        comments = string.replace(comments, "\n", " ")

        while (searchFor(comments, "  ") != None):
            comments = string.replace(comments, "  ", " ")


    # Find Keywords
    i = string.find(source, "Subjects:")

    if (i != -1):
        temp = searchForPlus(source, "Subjects:")
        i = string.find(temp, "</")
        temp = stripText(temp[0:i])
        i = string.find(temp, ": ")

        if (i != -1):
            temp = stripText(temp[0:i])

        keywords = ""

        while (searchFor(temp, "\n") != None):
            i = string.find(temp, "\n")
            keyword = stripText(temp[0:i])
            i = string.rfind(keyword, ".")

            if (i != -1):
                keyword = stripText(keyword[0:i])

            if keywords != "":
                keywords = keywords + ", " + keyword
            else:
                keywords = keyword

            temp = searchForPlus(temp, "\n")


    # Find Category
    source = searchForPlus(source, "Subjects:")

    if (source != None):
        i = string.find(source, "\n")
        category = stripText(source[0:i])
        i = string.rfind(category, ".")

        if (i != -1):
            category = stripText(category[0:i])


    # If I got this far, I have extracted basic info. I might not have an author,
    # set to various.
    if author == "":
        author = "Various"




try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
