# livcultura.com scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""

    # No place extraction default to source country
    # place = "Brazil"


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Main extraction
    source = searchForPlus(source, "<!-- Aqui")
    source = searchForPlus(source, "<font size=")
    source = searchForPlus(source, "<b>")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Image
    i = string.find(source, "/capas")

    if (i != -1):
        source = searchForPlus(source, "<img src=\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])


    # Find Price
    source = searchForPlus(source, "<font size")
    source = searchForPlus(source, "<b>")
    i = string.find(source, "<")
    value = stripText(source[0:i])


    # Find Author
    source = searchForPlus(source, "Autor:")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    author = stripText(source[0:i])


    # Find ISBN
    source = searchForPlus(source, "Ficha Tcnica:")
    source = searchForPlus(source, ">ISBN<")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    isbn = stripText(source[0:i])


    # Find Publication Date
    i = string.find(source, "Edio")

    if (i != -1):
        source = searchForPlus(source, "Edio")
        i = string.find(source, "\n")
        date = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, " ")

            if i != -1:
                date = stripText(date[i+1:])

    # Find Publisher
    source = searchForPlus(source, "da Editora:")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    publisher = stripText(source[0:i])


    # Find category
    i = string.find(source, "assunto:")

    if (i != -1):
        source = searchForPlus(source, "assunto:")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        category = stripText(source[0:i])



try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
