# Lesen[CH] scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""


    # No place extraction
    # place = "Switzerland"


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Main extraction
    # Find Image
    i = string.find(source, "aktion=cover")

    if (i != -1):
        source = searchForPlus(source, "aktion=cover")
        source = searchForPlus(source, "<img src=\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])
    else:
        # No image so position after publisher, ready for author
        source = searchForPlus(source, "&PU=")


    # Find Author
    source = searchForPlus(source, "<strong>")
    i = string.find(source, ":")
    author = stripText(source[0:i])


    # Find Title
    source = searchForPlus(source, ":")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find ISBN
    source = searchForPlus(source, "ISBN:")
    i = string.find(source, ",")
    isbn = stripText(source[0:i])


    # Find Publisher
    i = string.find(source, "&PU=")

    if (i != -1):
        pubtemp = searchForPlus(source, "&PU=")
        pubtemp = searchForPlus(pubtemp, ">")
        i = string.find(pubtemp, "<")
        publisher = stripText(pubtemp[0:i])

    # Find Price
    i = string.find(source, "<strong>")

    if (i != -1):
        source = searchForPlus(source, "<strong>")

        i = string.find(source, "<")
        value = stripText(source[0:i])

        i = string.find(value, "(")

        if (i != -1):
            value = value[0:i]

        i = string.find(value, "-")

        if (i != -1):
            value = value[0:i]

    # Find Format
#    source = searchForPlus(source, "</TABLE>")
#    source = searchForPlus(source, "<font face=")
#    source = searchForPlus(source, "<font face=")
#    source = searchForPlus(source, ">")
#    i = string.find(source, "<")
#    format = stripText(source[0:i])
#    i = string.find(format, "Taschenbuch")
#
#    if (i != -1):
#        format = "H"
#    else:
#        format = "P"
#
#    # Find Publication Date
#    source = searchForPlus(source, "(")
#    i = string.find(source, ")")
#    date = stripText(source[0:i])
#
#    # Find Publisher
#    source = searchForPlus(source, "<br>")
#    i = string.find(source, ";")
#    publisher = stripText(source[0:i])
#
#
#    # Find category
#    i = string.find(source, "Andere Titel")
#
#    if (i != -1):
#        source = searchForPlus(source, "Andere Titel")
#        source = searchForPlus(source, "\">")
#        i = string.find(source, "<")
#
#        if (i != -1):
#            category = stripText(source[0:i])



try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
