# kalahari.net scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripHTML
from    scrapers.scrapers import stripNewLines


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""


    # No place extraction default to US
    # place = "United States"

    i = string.find(source, "There are no results for your search.")

    if i != -1:
        source = searchFor(source, "force exception")
        source = searchFor(source, "force exception")
        return


    #Get detail page, if necessary
    i = string.find(source, "START LOOP THROUGH EACH RESULT")

    if i != -1:
        source = searchForPlus(source, "START LOOP THROUGH EACH RESULT")
        source = searchForPlus(source, "class=\"textmb\"")
        source = searchForPlus(source, "href=\"")
        i = string.find(source, "\">")
        url = "http://www.kalahari.net/BK/" + stripText(source[0:i])
        http = HTTPConnection()
        http.resetReferer();
        http.blockForLoad();
        source = http.getContents(url)


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Main extraction
    i = string.find(source, "class=\"textlorangeb\">0<")

    if i != -1:
        return

    source = searchForPlus(source, "<td class=\"textm\">")


    # Find Image
    i = string.find(source, "src=\"")

    if i > 0 and i <= 300:
        source = searchForPlus(source, "src=\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])

        i = string.find(image, "free-shipping")

        if i != -1:
            image = ""


    # Find Title
    source = searchForPlus(source, "<b>")
    i = string.find(source, "<")
    title = stripText(source[0:i])

    if title == "":
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        title = stripText(source[0:i])

    title = string.replace(title, "&quot;", "\"")


    # Find Author
    authorList = []
    i = string.find(source, ">Author<")

    if i != -1:
        source = searchForPlus(source, ">Author<")
        source = searchForPlus(source, ">")
        source = searchForPlus(source, ":")
        i = string.find(source, "<")
        authors = stripHTML(source[0:i]) + ", "

        while (searchFor(authors, ", ") != None):
            i = string.find(authors, ", ")
            tempAuthor = stripText(authors[0:i])
            authors = searchForPlus(authors, ", ")

            i = string.rfind(tempAuthor, " ")

            if (i != -1):
                authorlast = stripText(tempAuthor[i:])
                authorfirst = stripText(tempAuthor[0:i])
                author = authorlast + ", " + authorfirst
            else:
                author = tempAuthor

            authorList.append(author)


            if len(authorList) > 0:
                author = authorList[0]

            if len(authorList) > 1:
                author2 = authorList[1]

            if len(authorList) > 2:
                author3 = authorList[2]

            if len(authorList) > 3:
                author4 = authorList[3]

            if len(authorList) > 4:
                author5 = authorList[4]

            if len(authorList) > 5:
                author6 = authorList[5]

    if title != "" and len(authorList) == 0:
        author = "No Author"


    # Find Publisher
    i = string.find(source, ">Publisher<")

    if i != -1:
        source = searchForPlus(source, ">Publisher<")
        source = searchForPlus(source, ">")
        source = searchForPlus(source, ":")
        i = string.find(source, "<")
        publisher = stripHTML(source[0:i])


    # Find ISBN
    i = string.find(source, ">ISBN<")

    if i != -1:
        source = searchForPlus(source, ">ISBN<")
        source = searchForPlus(source, ">")
        source = searchForPlus(source, ":")
        i = string.find(source, "<")
        isbn = stripHTML(source[0:i])


    # Find Publication Date
    i = string.find(source, ">Publishing Date<")

    if (i != -1):
        source = searchForPlus(source, ">Publishing Date<")
        source = searchForPlus(source, ">")
        source = searchForPlus(source, ":")
        i = string.find(source, "<")
        date = stripHTML(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, " ")

            if i != -1:
                date = stripText(date[i+1:])


    # Find Pages
    i = string.find(source, ">Pages<")

    if (i != -1):
        source = searchForPlus(source, ">Pages<")
        source = searchForPlus(source, ">")
        source = searchForPlus(source, ":")
        i = string.find(source, "<")
        pages = stripHTML(source[0:i])


    # Find Format
    i = string.find(source, ">Format<")

    if i != -1:
        source = searchForPlus(source, ">Format<")
        source = searchForPlus(source, ">")
        source = searchForPlus(source, ":")
        i = string.find(source, "<")
        format = stripHTML(source[0:i])


    # Find Price
    i = string.find(source, "class=\"textmredb\"")

    if i != -1:
        source = searchForPlus(source, "class=\"textmredb\"")
        source = searchForPlus(source, "\">")

        i = string.find(source, " Now")

        if i != -1:
            source = searchForPlus(source, " Now")

        source = searchFor(source, " R")
        i = string.find(source, "<")
        value = stripText(source[0:i])
    else:
        i = string.find(source, "class=\"KClubPrice\"")

        if i != -1:
            source = searchForPlus(source, "class=\"KClubPrice\"")
            source = searchFor(source, ">R")
            source = searchFor(source, "R")
            i = string.find(source, "<")
            value = stripText(source[0:i])


    # Find Comments
    target = "Wishlist&notify_icon.gif"
    i = string.find(source, target)

    if (i == -1):
        target = "wishlist.gif"
        i = string.find(source, target)

    if (i != -1):
        comments = ""
        source = searchForPlus(source, target)
        source = searchForPlus(source, "</div>")
        i = string.find(source, "<br clear")
        comments = source[0:i]

        i = string.find(comments, "</font>")

        if (i != -1):
            comments = comments[0:i]

        comments = string.replace(comments, "<br>", "\n")
        comments = string.replace(comments, "<p>", "\n\n")
        comments = string.replace(comments, "<P>", "\n\n")
        comments = string.replace(comments, "</P>", "")
        comments = string.replace(comments, "</span>", "")



try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
