# indigo.ca scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""

    # No place extraction default to source country
    # place = "Canada"


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Main extraction
    # Find Image
    source = searchForPlus(source, "<!-- START MAIN ")
    source = searchForPlus(source, "<table")
    i = string.find(source, "getcover")

    if (i != -1):
        source = searchForPlus(source, "<img src=\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])


    # Find Title
    source = searchForPlus(source, "-->")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Author
    source = searchFor(source, "au=")
    i = string.find(source, "<BR>")
    authors = stripText(source[0:i])
    authorList = []

    while (searchFor(authors, "au=") != None):
        authors = searchForPlus(authors, "au=")
        i = string.find(authors, "\">")
        author = stripText(authors[0:i])
        i = string.find(author, ",")

        if i != -1:
            author = author[0:i] + ", " + author[i+1:]

        # Last + separates first and last name{s}
        i = string.rfind(author, "+")

        if i != -1:
            author = author[i+1:] + ", " + author[0:i]

        # Remaining + means multiple names, translate to spaces
        author = string.replace(author, "+", " ")

        authorList.append(author)


    if len(authorList) > 0:
        author = authorList[0]

    if len(authorList) > 1:
        author2 = authorList[1]

    if len(authorList) > 2:
        author3 = authorList[2]

    if len(authorList) > 3:
        author4 = authorList[3]

    if len(authorList) > 4:
        author5 = authorList[4]

    if len(authorList) > 5:
        author6 = authorList[5]


    # Find Format
    source = searchForPlus(source, "<BR>")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    format = stripText(source[0:i])


    # Find Price
    source = searchForPlus(source, "Price: ")
    source = searchFor(source, "$")
    i = string.find(source, "<")
    value = stripText(source[0:i])


    # Find Pages
    i = string.find(source, ">Published")

    if i != -1:
        source = source[i-100:]
        source = searchForPlus(source, "<nobr>")
        i = string.find(source, "<")
        pages = stripText(source[0:i])

        i = string.find(pages, " ")

        if i != -1:
            pages = pages[0:i]


    # Find Publication Date/Publisher
    i = string.find(source, ">Published")

    if i == -1:
        # No date, just publisher
        source = searchForPlus(source, "<nobr>")
        i = string.find(source, "|")
        publisher = stripText(source[0:i])
    else :
        source = searchForPlus(source, ">Published")
        i = string.find(source, "|")
        date = stripText(source[0:i])
        source = searchForPlus(source, "<nobr>")
        i = string.find(source, "|")
        publisher = stripText(source[0:i])

    if fullDateFormat == "false":
        i = string.rfind(date, " ")

        if i != -1:
            date = stripText(date[i+1:])


    # Find ISBN
    source = searchForPlus(source, "ISBN ")
    i = string.find(source, "</nobr>")
    isbn = stripText(source[0:i])

    # Starting to see other crap around ISBN, i.e.: <!--65271-->0060196076<!--/65271-->
    # strip it
    i = string.find(isbn, "->")

    if i != -1:
        isbn = searchForPlus(isbn, "->")
        i = string.find(isbn, "<")
        isbn = stripText(isbn[0:i])



try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
