# Internet Book Store (UK) scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""

    # No place extraction default to UK
    # place = "United Kingdom"


    # Find optional fields, pricing info etc.
    marketinfo = source

    # Find List Price
    i = string.find(marketinfo, ">RRP")

    if (i != -1):
        marketinfo = searchForPlus(marketinfo, ">RRP")
        i = string.find(marketinfo, "")
        marketinfo = marketinfo[i:]
        i = string.find(marketinfo, "<")
        listprice = stripText(marketinfo[0:i])


    # Main extraction
    # Sometimes ISBN only hidden at top. Try that now,
    # Regular ISBN is at end, I'll try that too, see
    # further down.
    # Find ISBN, first try
    i = string.find(source, "&isbn=")

    if (i != -1):
        str = searchForPlus(source, "&isbn=")
        i = string.find(str, "&")
        isbn = stripText(str[0:i])

    # Find Title
    source = searchFor(source, "<font size = \"5\" color=\"#993300")
    source = searchForPlus(source, "><B>")
    i = string.find(source, "</B>")
    title = stripText(source[0:i])

    if title == ("iBS Featured Book"):
        source = searchFor(source, "<font size = \"5\" color=\"#993300")
        source = searchForPlus(source, "><B>")
        i = string.find(source, "</B>")
        title = stripText(source[0:i])

    # Find Image
    i = string.find(source, "/thumbnails")

    if (i != -1):
        source = searchFor(source, "/thumbnails")
        i = string.find(source, "\"")
        image = stripText(source[0:i])

    # Find Author
    source = searchFor(source, "ExactAuthor")
    source = searchForPlus(source, ">")
    i = string.find(source, "</i>")
    authors = stripText(source[0:i]) + ";"
    authorList = []

    while (searchFor(authors, ";") != None):
        i = string.find(authors, ";")
        author = stripText(authors[0:i])
        authorList.append(author)
        authors = searchForPlus(authors, ";")

    if len(authorList) > 0:
        author = authorList[0]

    if len(authorList) > 1:
        author2 = authorList[1]

    if len(authorList) > 2:
        author3 = authorList[2]

    if len(authorList) > 3:
        author4 = authorList[3]

    if len(authorList) > 4:
        author5 = authorList[4]

    if len(authorList) > 5:
        author6 = authorList[5]


    # Find Price
    source = searchForPlus(source, "<B>Price</B>")
    i = string.find(source, "Normal Price")

    if (i == -1):
        source = searchForPlus(source, "Discount Price")

    i = string.find(source, "")
    source = source[i:]
    i = string.find(source, "</")
    value = stripText(source[0:i])

    # Find Format
    i = string.find(source, "<B>Binding</B>")

    if (i != -1):
        source = searchForPlus(source, "<B>Binding</B>")
        source = searchForPlus(source, "Helvetica\">")
        i = string.find(source, "</font")
        format = stripText(source[0:i])

    # Find Publication Date
    source = searchFor(source, "<B>Published</B>")
    source = searchForPlus(source, "Helvetica\">")
    i = string.find(source, "</font")
    date = stripText(source[0:i])

    if fullDateFormat == "false":
        i = string.rfind(date, " ")

        if i != -1:
            date = stripText(date[i+1:])


    # Find Publisher
    i = string.find(source, "ExactPublisher")

    if (i != -1):
        source = searchFor(source, "ExactPublisher")
        source = searchForPlus(source, ">")
        i = string.find(source, "</a>")
        publisher = stripText(source[0:i])


    # Find Comments
    i = string.find(source, ">iBS Description<")

    if (i != -1):
        source = searchFor(source, ">iBS Description<")
        source = searchForPlus(source, "<br>")
        i = string.find(source, "\n")
        comments = stripText(source[0:i])

        i = string.find(comments, "</font><p>")

        if (i != -1):
            comments = stripText(comments[0:i])

        comments = string.replace(comments, "&#39;", "'")
        comments = string.replace(comments, "<I>", "")
        comments = string.replace(comments, "</I>", "")

    # Find ISBN
    source = searchForPlus(source, "ISBN=")

    if (source == None):
        return

    i = string.find(source, "&")
    isbn = stripText(source[0:i])


try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
