# Internet Book List scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripHTML
from    scrapers.scrapers import stripNewLines


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""


    # No place extraction default to US
    # place = "United States"


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Main extraction
    source = searchForPlus(source, ">Book Information:")


    # Find Image
    i = string.find(source, "/covers")

    if (i != -1):
        image = stripText(source[i-50:])
        image = searchForPlus(image, "img src=\"")
        i = string.find(image, "\"")
        image = stripText(image[0:i])


    # Find Title
    source = searchForPlus(source, "class=\"big\"")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Publication Date
    i = string.rfind(title, "(")

    if (i != -1):
        date = stripText(title[i+1:])
        title = stripText(title[0:i])
        i = string.find(date, ")")
        date = stripText(date[0:i])


    # Find Author
    i = string.find(source, "by <")

    if (i != -1):
        source = searchForPlus(source, "by <")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        author = stripText(source[0:i])

        i = string.rfind(author, " ")

        if (i != -1):
            author = stripText(author[i:]) + ", " + stripText(author[0:i])


    # Find Rating
    i = string.find(source, ">Rating:<")

    if (i != -1):
        source = searchForPlus(source, ">Rating:<")
        i = string.find(source, "<B>")

        if i != -1:
            source = searchForPlus(source, "<B>")
            i = string.find(source, "<")
            rating = stripText(source[0:i])


    # Find Series
    i = string.find(source, ">Series:<")

    if (i != -1):
        source = searchForPlus(source, ">Series:<")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        series = stripText(source[0:i])


    # Find Comments
    i = string.find(source, ">Synopsis:<")

    if (i != -1):
        source = searchForPlus(source, ">Synopsis:<")
        source = searchForPlus(source, "\">")
        i = string.find(source, "</div>")
        comments = stripText(source[0:i])
        comments = string.replace(comments, "\n", " ")
        comments = string.replace(comments, "  ", " ")
        comments = string.replace(comments, "<i>", "")
        comments = string.replace(comments, "<I>", "")
        comments = string.replace(comments, "</i>", "")
        comments = string.replace(comments, "</I>", "")
        comments = string.replace(comments, "<br>", "\n")
        comments = string.replace(comments, "<BR>", "\n")
        comments = string.replace(comments, "<p>", "\n\n")
        comments = string.replace(comments, "<P>", "\n\n")
        comments = string.replace(comments, "\r ", "\r")


    # Find ISBN
    i = string.find(source, ">ISBN:<")

    if (i != -1):
        source = searchForPlus(source, ">ISBN:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "\n")
        isbn = stripText(source[0:i])

        i = string.find(isbn, ",")

        if i != -1:
            isbn = stripText(isbn[0:i])


    # Find Category
    i = string.find(source, ">Genre:<")

    if (i != -1):
        source = searchForPlus(source, ">Genre:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "\n")
        categories = stripText(source[0:i])
        category = ""

        while (searchFor(categories, "href=") != None):
            categories = searchForPlus(categories, "href=")
            categories = searchForPlus(categories, "\">")
            i = string.find(categories, "<")
            temp = stripText(categories[0:i])

            if (category != ""):
                category = category + " : "

            category = category + temp




try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
