# Fatbrain.com scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""

    # No place extraction default to US
    # place = "United States"


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Main extraction
    # Find Image
    source = searchForPlus(source, "<!-- ########## START Left Column")
    i = string.find(source, "images.barnesandnoble.com")

    if (i != -1):
        source = searchForPlus(source, "SRC=\"")
        source = searchForPlus(source, "SRC=\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])


    # Find Title
    source = searchForPlus(source, "<!-- ########## START Main Column")
    source = searchForPlus(source, "<FONT")
    source = searchForPlus(source, ">")
    i = string.find(source, "</FONT>")
    title = stripText(source[0:i])


    # Find Author
    source = searchForPlus(source, ">By<")
    source = searchForPlus(source, "\">")
    i = string.find(source, "<")
    authors = stripText(source[0:i])
    authorList = []

    while (searchFor(authors, ",") != None):
        i = string.find(authors, ",")
        tempValue = stripText(authors[0:i])
        authors = searchForPlus(authors, ",")

        i = string.rfind(tempValue, " ")

        authorfirst = stripText(tempValue[0:i])
        authorlast = stripText(tempValue[i:])
        authorList.append(stripText(authorlast) + ", " + stripText(authorfirst))

    i = string.rfind(authors, " ")
    authorfirst = stripText(authors[0:i])
    authorlast = stripText(authors[i:])
    authorList.append(stripText(authorlast) + ", " + stripText(authorfirst))


    if len(authorList) > 0:
        author = authorList[0]

    if len(authorList) > 1:
        author2 = authorList[1]

    if len(authorList) > 2:
        author3 = authorList[2]

    if len(authorList) > 3:
        author4 = authorList[3]

    if len(authorList) > 4:
        author5 = authorList[4]

    if len(authorList) > 5:
        author6 = authorList[5]


    # Find Price
    i = string.find(source, ">List Price:")

    if (i != -1):
        source = searchForPlus(source, ">List Price:")
        source = searchFor(source, "$")
        i = string.find(source, "<")
        value = stripText(source[0:i])

    i = string.find(source, ">Online Price:")

    if (i != -1):
        source = searchForPlus(source, ">Online Price:")
        source = searchFor(source, "$")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find Format
    source = searchForPlus(source, "SIZE=2><P>")
    i = string.find(source, "<")
    format = stripText(source[0:i])


    # Find Pages
    source = searchForPlus(source, "<BR>")
    i = string.find(source, "<BR>")
    pages = stripText(source[0:i])

    i = string.find(pages, " ")

    if i != -1:
        pages = stripText(pages[0:i])


    # Find Publisher
    source = searchForPlus(source, "Published by ")
    i = string.find(source, "<BR>")
    publisher = stripText(source[0:i])

    # Find Publication Date
    source = searchForPlus(source, "Date Published:")
    i = string.find(source, "<BR>")
    date = stripText(source[0:i])

    if fullDateFormat == "false":
        i = string.rfind(date, "/")

        if i != -1:
            date = stripText(date[i+1:])

    # Find ISBN
    i = string.find(source, ">ISBN:")

    if (i != -1):
        source = searchForPlus(source, ">ISBN:")
        i = string.find(source, "<BR>")
        isbn = stripText(source[0:i])


    # Find Comments
    i = string.find(source, "Moreinfo.gif")

    if (i != -1):
        source = searchForPlus(source, "Moreinfo.gif")
        i = string.find(source, "<!--# End")
        comments = stripText(source[0:i])
        i = string.find(comments, ">Summary")

        if (i != -1):
            comments = searchForPlus(comments, ">Summary")

        i = string.find(comments, "<A href=")

        if (i != -1):
            comments = searchForPlus(comments, "<A href=")
            comments = searchForPlus(comments, "</a>")

        i = string.find(comments, "<FONT")

        if (i != -1):
            comments = searchForPlus(comments, "<FONT")
            comments = searchForPlus(comments, ">")

        comments = string.replace(comments, "\n", "")
        comments = string.replace(comments, "<p>", "\n\n")
        comments = string.replace(comments, "<P>", "\n\n")
        comments = string.replace(comments, "<b>", "")
        comments = string.replace(comments, "</b>", "")
        comments = string.replace(comments, "<B>", "")
        comments = string.replace(comments, "</B>", "")
        comments = string.replace(comments, "<i>", "")
        comments = string.replace(comments, "</i>", "")
        comments = string.replace(comments, "<I>", "")
        comments = string.replace(comments, "</I>", "")
        comments = string.replace(comments, "<ul>", "")
        comments = string.replace(comments, "</ul>", "")
        comments = string.replace(comments, "<UL>", "")
        comments = string.replace(comments, "</UL>", "")
        comments = string.replace(comments, "<LI>", "\n    ")
        comments = string.replace(comments, "</LI>", "")
        comments = string.replace(comments, "<li>", "\n    ")
        comments = string.replace(comments, "</li>", "")
        comments = string.replace(comments, "</FONT>", "")
        comments = string.replace(comments, "</SMALL>", "")
        comments = string.replace(comments, "<SMALL>", "")
        comments = string.replace(comments, "<BR>", "\n")
        comments = string.replace(comments, "<br>", "\n")
        comments = string.replace(comments, "&quot;", "\"")

        while (searchFor(comments, "<a ") != None):
            i = string.find(comments, "<a ")
            j = string.find(comments[i:], "\">")
            comments = comments[0:i] + comments[i+j+2:]

        comments = stripText(comments)


    # Find category
    i = string.find(source, "subject categories")

    if (i != -1):
        source = searchForPlus(source, "subject categories")
        i = string.find(source, "\n")
        categories = stripText(source[0:i])
        category = ""

        i = string.find(categories, "<br>")

        if (i != -1):
            categories = stripText(categories[0:i]);

        while (searchFor(categories, "Href=") != None):
            i = string.find(categories, "HREF=")

            if (i != -1):
                categories = searchForPlus(categories, "HREF=")
            else:
                categories = searchForPlus(categories, "Href=")

            categories = searchForPlus(categories, ">")
            i = string.find(categories, "</")

            if (category != ""):
                category = category + " : "

            category = category + stripText(categories[0:i])



try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
