# Chapitre[fr] scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""

    # No place extraction default to France
    # place = "France"


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Main extraction
    # Find Title
    source = searchForPlus(source, "<BODY")
    source = searchForPlus(source, "<CENTER>")
    source = searchForPlus(source, "\">")
    i = string.find(source, "<")
    title = stripText(source[0:i])
    i = string.find(title, ":")

    if (i != -1):
        title = stripText(title[0:i])


    # Find Author
    source = searchForPlus(source, "auteur=")
    i = string.find(source, "\">")
    tempValue = stripText(source[0:i])
    i = string.find(tempValue, "&")

    if (i != -1):
        tempValue = tempValue[0:i]

    i = string.find(tempValue, "+")
    authorlast = stripText(tempValue[0:i])
    authorfirst = stripText(tempValue[i+1:])

    if (authorfirst == ""):
        author = authorlast
    else:
        author = stripText(authorlast) + ", " + stripText(authorfirst)


    # Find Image
    i = string.find(source, "http://img.echo.fr")

    if (i != -1):
        i = string.find(source[i:], ">Editeur")

        if (i != -1):
            source = searchForPlus(source, "http://img.echo.fr")
            i = string.find(source, "\"")
            image = stripText(source[0:i])


    # Find Publisher
    source = searchForPlus(source, ">Editeur")
    source = searchForPlus(source, "\">")
    i = string.find(source, "<")
    publisher = stripText(source[0:i])


    # Find category
    i = string.find(source, ">Collection")

    if (i != -1):
        source = searchForPlus(source, ">Collection")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        category = stripText(source[0:i])


    # Find value
    source = searchForPlus(source, ">Prix Chapitre")
    source = searchForPlus(source, "<B>")
    i = string.find(source, "<")
    value = stripText(source[0:i])


    # Find ISBN
    source = searchForPlus(source, ">ISBN<")
    source = searchForPlus(source, "\">")
    i = string.find(source, "<")
    isbn = stripText(source[0:i])


    # Find Publication date
    i = string.find(source, ">Date de parution")

    if (i != -1):
        source = searchForPlus(source, ">Date de parution")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        date = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, " ")

            if i != -1:
                date = stripText(date[i+1:])



try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
