# bookpages.co.uk scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Main extraction
    # Find ISBN
    source = searchForPlus(source, "ISBN no.")
    i = string.find(source, "</Title>")
    isbn = stripText(source[0:i])

    # Find Title
    while (searchFor(source, "ISBN no.") != None):
        source = searchForPlus(source, "ISBN no.")

    source = searchFor(source, "      ")
    i = string.find(source, "by ")
    title = stripText(source[0:i])

    # Find Author
    source = source[i + 3:]
    source = searchForPlus(source, "Author\">")
    i = string.find(source, "</a>")
    author = stripText(source[0:i])

    # Find Price
    source = searchFor(source, "Price:")
    source = searchForPlus(source, "<strong>")
    i = string.find(source, "</strong>")
    value = stripText(source[0:i])

    # Find Format
    source = searchFor(source, "Format:");
    source = searchForPlus(source, "<strong>");
    i = string.find(source, "</strong>")
    format = stripText(source[0:i])

    # Find Publisher
    source = searchFor(source, "Publisher:")
    source = searchForPlus(source, "<strong>")
    i = string.find(source, "</strong>")
    publisher = stripText(source[0:i])

    # Find Publication Date
    source = searchFor(source, "Date Published:")
    source = searchForPlus(source, "<strong>")
    i = string.find(source, "</strong>")
    date = stripText(source[0:i])


try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
