# 1bookstreet.com scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""

    # No place extraction default to US
    # place = "United States"


    # Find optional fields, pricing info etc.
    marketinfo = source

    # Find List price
    i = string.find(marketinfo, ">Regular Price:")

    if (i != -1):
        listprice = searchForPlus(marketinfo, ">Regular Price:")
        i = string.find(listprice, "<")
        listprice = stripText(listprice[0:i])


    # Main extraction
    # Find Title
    source = searchForPlus(source, "CP: Display Title")
    source = searchForPlus(source, "<B>")
    i = string.find(source, "</B>")
    title = stripText(source[0:i])


    # Find Author
    source = searchForPlus(source, "?txtlName=")
    i = string.find(source, "&txtfName=")
    authorlast = stripText(source[0:i])
    source = searchForPlus(source, "&txtfName=")
    i = string.find(source, "&")
    authorfirst = stripText(source[0:i])
    authorfirst = string.replace(authorfirst, "+", " ")
    author = stripText(authorlast) + ", " + stripText(authorfirst)


    # Find Image
    i = string.find(source, "/productimages")

    if (i != -1):
        j = string.find(source, "000000.jpg")

        if (j == -1):
            source = stripText(source[i:])
            i = string.find(source, "\"")
            image = stripText(source[0:i])


    # Find Price
    i = string.find(source, ">Our Price")

    if (i != -1):
        source = searchForPlus(source, ">Our Price")
    else:
        source = searchForPlus(source, ">Regular Price")

    source = searchForPlus(source, "$")
    i = string.find(source, "<")
    value = "$" + stripText(source[0:i])


    # Find Format
    i = string.find(source, ">Format:")

    if (i != -1):
        rawdata = source[i:]
        rawdata = searchForPlus(rawdata, ":")
        i = string.find(rawdata, "<")
        format = stripText(rawdata[0:i])


    # Find Pages
    i = string.find(source, ">Length:")

    if (i != -1):
        rawdata = source[i:]
        rawdata = searchForPlus(rawdata, ":")
        i = string.find(rawdata, "<")
        pages = stripText(rawdata[0:i])

        i = string.find(pages, " ")

        if i != -1:
            pages = stripText(pages[0:i])


    # Find ISBN
    i = string.find(source, ">ISBN:")

    if (i != -1):
        rawdata = source[i:]
        rawdata = searchForPlus(rawdata, ":")
        i = string.find(rawdata, "<")
        isbn = stripText(rawdata[0:i])


    # Find Publisher
    i = string.find(source, ">Publisher:")

    if (i != -1):
        rawdata = source[i:]
        rawdata = searchForPlus(rawdata, ":")
        i = string.find(rawdata, "<")
        publisher = stripText(rawdata[0:i])


    # Find Published date
    i = string.find(source, ">Pub Date:")

    if (i != -1):
        rawdata = source[i:]
        rawdata = searchForPlus(rawdata, ":")
        i = string.find(rawdata, "<")
        date = stripText(rawdata[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, " ")

            if i != -1:
                date = stripText(date[i+1:])


    # Find Comments
    i = string.find(source, "<!-- CP: Ages -->")

    if (i != -1):
        rawdata = source[i:]
        rawdata = searchForPlus(rawdata, "<FONT FACE=")
        rawdata = searchForPlus(rawdata, ">")
        i = string.find(rawdata, "<P>")
        comments = stripText(rawdata[0:i])



try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
