# Books-A-Million scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""

    # No place extraction default to US
    # place = "United States"


    # Find optional fields, pricing info etc.
    marketinfo = source

    # Find List price
    i = string.find(marketinfo, ">Retail Price:")

    if (i != -1):
        listprice = searchForPlus(marketinfo, ">Retail Price:")
        listprice = searchForPlus(listprice, ">")
        i = string.find(listprice, "<")
        listprice = "$" + stripText(listprice[0:i])


    # Find Reading level
    i = string.find(marketinfo, ">Reading Level:")

    if (i != -1):
        readinglevel = searchForPlus(marketinfo, ">Reading Level:")
        readinglevel = searchForPlus(readinglevel, ">")
        i = string.find(readinglevel, "<")
        readinglevel = stripText(readinglevel[0:i])


    # Main extraction
    # Find Book details
    source = searchForPlus(source, "<!-- item details")

    # Find Image
    i = string.find(source, "\"Product Cover\"")

    if (i != -1):
        source = searchForPlus(source, "\"Product Cover\"")
        source = searchForPlus(source, "SRC=\"")
        i = string.find(source, "\"")
        image = "http://www.booksamillion.com" + stripText(source[0:i])


    # Find Title
    source = searchForPlus(source, "<FONT SIZE=\"3\">")
    source = searchForPlus(source, "<B>")
    i = string.find(source, "</B>")
    title = stripText(source[0:i])


    # Find Sub Title
    source = searchForPlus(source, "</FONT>")
    source = stripText(source)

    if source.startswith("<BR>  ") == 1:
        source = searchForPlus(source, "<BR>")
        i = string.find(source, "<")
        subtitle = stripText(source[0:i])

        if title != "" and subtitle != "":
            title = title + " : " + subtitle


    # Find Format
    source = searchForPlus(source, "<FONT SIZE=\"2\">")
    source = searchForPlus(source, "(")
    i = string.find(source, ")")
    format = stripText(source[0:i])


    # Find Author
    source = searchFor(source, "&type=author&find=")
    i = string.find(source, "\n")
    authors = stripText(source[0:i])
    print "AT",authors
    authorList = []

    while (searchFor(authors, "&type=author&find=") != None):
        authors = searchForPlus(authors, "&type=author&find=")
        authors = searchForPlus(authors, "\">")
        i = string.find(authors, "<")
        author = stripText(authors[0:i])

        author = string.replace(author, "%26", "&")

        i = string.rfind(author, " ")

        if i != -1:
            author = stripText(author[i:]) + ", " + stripText(author[0:i])

        authorList.append(author)


    if len(authorList) > 0:
        author = authorList[0]

    if len(authorList) > 1:
        author2 = authorList[1]

    if len(authorList) > 2:
        author3 = authorList[2]

    if len(authorList) > 3:
        author4 = authorList[3]

    if len(authorList) > 4:
        author5 = authorList[4]

    if len(authorList) > 5:
        author6 = authorList[5]


    # Find Price
    source = searchForPlus(source, "Our Price:")
    i = string.find(source, "</B>")
    value = stripText(source[0:i])


    # Find ISBN
    source = searchForPlus(source, "ISBN:")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    isbn = stripText(source[0:i])

    if (isbn[len(isbn)-1:] == "/"):
        isbn = isbn[0:len(isbn)-2]


    # Find Publisher
    source = searchForPlus(source, "Publisher:")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    publisher = stripText(source[0:i])

    if (publisher[len(publisher)-1:] == "/"):
        publisher = publisher[0:len(publisher)-2]


    # Find Publication Date
    source = searchForPlus(source, "Date:")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    date = stripText(source[0:i])

    if (date[len(date)-1:] == "/"):
        date = date[0:len(date)-2]

    if fullDateFormat == "false":
        i = string.rfind(date, " ")

        if i != -1:
            date = stripText(date[i+1:])


    # Find Pages
    i = string.find(source, "Page Count:")

    if i != -1:
        source = searchForPlus(source, "Page Count:")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        pages = stripText(source[0:i])


    # Find Comments
    i = string.find(source, "<!-- begin ratings section -->")

    if (i != -1):
        source = searchForPlus(source, "<!-- begin ratings section -->")
        i = string.find(source, "<!-- spacer column -->")
        comments = stripText(source[0:i])

        while (searchFor(comments, "</TABLE>") != None):
            comments = searchForPlus(comments, "</TABLE>")

        comments = string.replace(comments, "", "'")
        comments = string.replace(comments, "<p>", "")
        comments = string.replace(comments, "<P>", "")
        comments = string.replace(comments, "<hr>", "\n\n")
        comments = string.replace(comments, "<b>", "")
        comments = string.replace(comments, "</b>", "")
        comments = string.replace(comments, "<I>", "")
        comments = string.replace(comments, "</I>", "")
        comments = string.replace(comments, "<i>", "")
        comments = string.replace(comments, "</i>", "")
        comments = string.replace(comments, "</FONT>", "")
        comments = string.replace(comments, "</TD>", "")

        while (searchFor(comments, "<a ") != None):
            i = string.find(comments, "<a ")
            j = string.find(comments[i:], "\">")
            comments = comments[0:i] + comments[i+j+2:]

        comments = stripText(comments)


    # Find category
    i = string.find(source, "<B>Related Subjects:</B>")

    if (i != -1):
        category = ""
        source = searchForPlus(source, "<B>Related Subjects:</B>")
        source = searchForPlus(source, "<a href=")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")

        if (i != -1):
            category = category +  stripText(source[0:i]) + " : "

        source = searchForPlus(source, "<a href=")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")

        if (i != -1):
            category = category + stripText(source[0:i])


try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
