# bookpool.com scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""

    # No place extraction default to US
    # place = "United States"


    # Find optional fields, pricing info etc.
    marketinfo = source

    # Find List price
    i = string.find(marketinfo, ">List Price:")

    if (i != -1):
        listprice = searchForPlus(marketinfo, ">List Price:")
        i = string.find(listprice, "<")
        listprice = stripText(listprice[0:i])


    # Main extraction
    # Find Title
    source = searchForPlus(source, "cll.gif")
    source = searchForPlus(source, "<br>")
    source = searchForPlus(source, "<font")
    source = searchForPlus(source, ">")
    i = string.find(source, "</")
    title = stripText(source[0:i])

    # Find Image
    i = string.find(source, "<img ")

    if (i != -1):
        if (i < 200):
            source = searchForPlus(source, "<img ")
            source = searchForPlus(source, "src=\"")
            i = string.find(source, "\">")
            image = stripText(source[0:i])

    # Find Author
    source = searchFor(source, "qs=")
    i = string.find(source, "</i>")
    authors = stripText(source[0:i])
    authorList = []

    while (searchFor(authors, "qs=") != None):
        authors = searchForPlus(authors, "qs=")
        authors = searchForPlus(authors, ">")
        i = string.find(authors, "</")

        tempValue = stripText(authors[0:i])
        i = string.rfind(tempValue, " ")

        authorfirst = stripText(tempValue[0:i])
        authorlast = stripText(tempValue[i:])
        author = stripText(authorlast) + ", " + stripText(authorfirst)

        authorList.append(author)


    if len(authorList) > 0:
        author = authorList[0]

    if len(authorList) > 1:
        author2 = authorList[1]

    if len(authorList) > 2:
        author3 = authorList[2]

    if len(authorList) > 3:
        author4 = authorList[3]

    if len(authorList) > 4:
        author5 = authorList[4]

    if len(authorList) > 5:
        author6 = authorList[5]


    # Find Publisher
    source = searchForPlus(source, "<font")
    source = searchForPlus(source, ">")
    i = string.find(source, ",")
    publisher = stripText(source[0:i])


    # Find Format
    source = stripText(source[i+1:])
    i = string.find(source, ",")
    format = stripText(source[0:i])


    # Find Publication Date
    source = searchForPlus(source, "Published ")
    i = string.find(source, ",")
    date = stripText(source[0:i])

    if fullDateFormat == "false":
        i = string.rfind(date, " ")

        if i != -1:
            date = stripText(date[i+1:])


    # Find Pages
    source = stripText(source[i+1:])
    i = string.find(source, ",")
    pages = stripText(source[0:i])

    i = string.find(pages, " ")

    if i != -1:
        pages = stripText(pages[0:i])


    # Find ISBN
    source = searchForPlus(source, "ISBN ")
    i = string.find(source, "<")
    isbn = stripText(source[0:i])


    # Find Price
    i = string.find(source, "Our Price:")

    if (i == -1):
        i = string.find(source, "List Price:")

    if (i != -1):
        source = source[i:]

        source = searchFor(source, "$")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find category
    i = string.find(source, "on similar topics,")

    if (i != -1):
        source = searchForPlus(source, "on similar topics,")
        source = searchForPlus(source, "href=")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")

        if (i != -1):
            category = stripText(source[0:i])



try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
