# bookcloseouts.com scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""

    # No place extraction default to US
    # place = "United States"


    # Find optional fields, pricing info etc.
    marketinfo = source

    # Find List price
    i = string.find(marketinfo, ">List Price:")

    if (i != -1):
        listprice = searchForPlus(marketinfo, ">List Price:")
        listprice = searchFor(listprice, "$")
        i = string.find(listprice, "<")
        listprice = stripText(listprice[0:i])


    # Check for availability
    i = string.find(source, ">SOLD OUT!<")

    if i != -1:
        available = "N";


    # Main extraction
    # Find Title
    source = searchForPlus(source, "caption-large")
    source = searchForPlus(source, "\">")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Image
    i = string.find(source, "-s.jpg")

    if (i != -1):
        source = searchForPlus(source, " src=\"")
        i = string.find(source, "\"")
        image = "http://www.bookcloseouts.com" + stripText(source[0:i])


    # Find Author
    source = searchForPlus(source, ">Author(s):<")
    source = searchForPlus(source, "\">")
    i = string.find(source, "<")
    author = stripText(source[0:i])


    # Find Publisher
    i = string.find(source, ">Publisher:<")

    if i != -1:
        source = searchForPlus(source, ">Publisher:<")
        source = searchForPlus(source, "<td")
        source = searchForPlus(source, "href")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        publisher = stripText(source[0:i])


    # Find Series
    i = string.find(source, ">Series:<")

    if i != -1:
        source = searchForPlus(source, ">Series:<")
        source = searchForPlus(source, "<td")
        source = searchForPlus(source, "href")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        series = stripText(source[0:i])


    # Find Format
    i = string.find(source, ">Format:<")

    if i != -1:
        source = searchForPlus(source, ">Format:<")
        source = searchForPlus(source, "<td")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        format = stripText(source[0:i])


    # Find Price
    i = string.find(source, ">Our Price:<")

    if i != -1:
        source = searchForPlus(source, ">Our Price:<")
        source = searchForPlus(source, "<td")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        value = stripText(source[0:i])

        i = string.find(value, "(")

        if i != -1:
            value = stripText(value[0:i])


    # Find Comments
    i = string.find(source, ">Overview:")

    if i != -1:
        source = searchForPlus(source, ">Overview:")
        source = searchForPlus(source, "<br/>")
        i = string.find(source, "</td>")
        comments = stripText(source[0:i])

        if comments == "Overview not currently available":
            comments = ""


    # Find category
    category = ""
    i = string.find(source, ">Category<")

    if i != -1:
        source = searchForPlus(source, ">Category<")
        source = searchForPlus(source, "<tr>")
        i = string.find(source, "</tr>")
        temp = stripText(source[0:i])

        while (searchFor(temp, "\">") != None):
            temp = searchForPlus(temp, "\">")
            i = string.find(temp, "<")

            if category == "":
                category = stripText(temp[0:i])
            else:
                category = category + " : " + stripText(temp[0:i])


    # Find ISBN
    i = string.find(source, ">ISBN:<")

    if i != -1:
        source = searchForPlus(source, ">ISBN:<")
        source = searchForPlus(source, "<td>")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "<")
        isbn = stripText(source[0:i])


    # Find pages
    i = string.find(source, ">Pages:<")

    if i != -1:
        source = searchForPlus(source, ">Pages:<")
        source = searchForPlus(source, "<td>")
        source = searchForPlus(source, "<td>")
        i = string.find(source, "<")
        pages = stripText(source[0:i])




try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
