# Tower Records audio scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripNewLines
from    scrapers.scrapers import calcUPCCheckDigit
from    scrapers.scrapers import convertArtist
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source
    global trackList,artistList,writerList,diskCount,switchArtist


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    sound               = "Stereo"
    format              = "CD"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    artistLF            = ""

    switchArtist        = "N"
    available           = "Y"
    buyerwaiting        = "N"


    # Check for not found
    i = string.find(source, "is not a valid Tower Records product number.")

    if i != -1:
        source = searchFor(source, "force exception")
        source = searchFor(source, "force exception")
        return


    # Find optional fields, pricing info etc.
    marketinfo = source

    # Find List price
    i = string.find(marketinfo, "List Price:")

    if (i != -1):
        temp = searchForPlus(marketinfo, "List Price:")
        i = string.find(temp, ">")
        i = string.find(listprice, "<")
        listprice = stripText(listprice[0:i])


    # Main extraction
    classical = "N"

    # Find Image
    i = string.find(source, "\"reflect rheight10\"")

    if i != -1:
        source = stripText(source[i-100:])
        source = searchForPlus(source, "src=\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])

        i = string.find(image, "777777777")

        if i != -1:
            image = ""


    # Find Title
    source = searchForPlus(source, "color: #c00;")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    title = stripText(source[0:i])

    i = string.rfind(title, "[")

    if (i != -1):
        title = stripText(title[0:i])



    # Find Artist
    artist = ""
    i = string.find(source, "\"d_artist\"")

    if i != -1:
        source = searchForPlus(source, "\"d_artist\"")
        source = searchForPlus(source, ">")
        i = string.find(source, "</span>")
        artist = stripText(source[0:i])

        i = string.find(artist, "<a href")

        if i != -1:
            i = string.find(artist, "?artist=")

            if i != -1:
                artistLF = searchForPlus(artist, "?artist=")
                i = string.find(artistLF, "\"")
                artistLF = stripText(artistLF[0:i])
                artistLF = string.replace(artistLF, "%2c", ",")
                artistLF = string.replace(artistLF, "+", " ")
                print "artistLF=",artistLF

            artist = searchForPlus(artist, "\">")

        i = string.find(artist, "<")

        if i != -1:
            artist = stripText(artist[0:i])


    # Massage title/artist now that we are finished getting both
    if artist == "":
        i = string.rfind(title, " / ")

        if (i != -1):
            artist = stripText(title[i+3:])
    else:
        i = string.rfind(title, " - " + artist)

        if (i != -1):
            title = stripText(title[0:i])

    title = stripText(title)

    if title.endswith("*"):
        i = string.rfind(title, "*")
        title = stripText(title[0:i])

    if artist != "":
        artist = convertArtist(artist)

        if switchArtist == "Y":
            i = string.rfind(artist, " ")

            if (i != -1):
                artist = stripText(artist[i+1:]) + ", " + stripText(artist[0:i])


    # Find Price
    i = string.find(source, "Price:")

    if i != -1:
        source = searchForPlus(source, "Price:")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find Format
    i = string.find(source, ">Format:<")

    if i != -1:
        source = searchForPlus(source, ">Format:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        format = stripText(source[0:i])
            


    # Find Release date
    i = string.find(source, ">Release Date:")

    if (i != -1):
        source = searchForPlus(source, ">Release Date:")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        date = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, " ")

            if i != -1:
                date = stripText(date[i+1:])


    # Find Copyright date
    i = string.find(source, ">Original release")

    if (i != -1):
        source = searchForPlus(source, ">Original release")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        copyDate = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(copyDate, " ")

            if i != -1:
                copyDate = stripText(copyDate[i+1:])


    # Find Label
    i = string.find(source, ">Label:")

    if (i != -1):
        source = searchForPlus(source, ">Label:")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        label = stripText(source[0:i])


    # Find Sound
    i = string.find(source, ">Stereo:")

    if (i != -1):
        source = searchForPlus(source, ">Stereo:")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        sound = stripText(source[0:i])


    # Find Composer
    i = string.find(source, ">Composer:")

    if (i != -1):
        temp = searchForPlus(source, ">Composer:")
        temp = searchForPlus(temp, ">")
        i = string.find(temp, "<")
        composer = stripText(temp[0:i])

        i = string.find(composer, " (")

        if i != -1:
            composerDate = stripText(composer[i:])
            composer = stripText(composer[0:i])
        else:
            composerDate = ""

        i = string.rfind(composer, " ")

        if i != -1:
            composer = stripText(composer[i+1:]) + ", " + stripText(composer[0:i])

        composer = composer + " " + composerDate


    # Find UPC
    i = string.find(source, ">UPC/EAN:")

    if i != -1:
        source = searchForPlus(source, ">UPC/EAN:")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        upc = stripText(source[0:i])


    # Find Category
    i = string.find(source, ">Genre:")

    if i != -1:
        source = searchForPlus(source, ">Genre:")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        category = stripText(source[0:i])


    # Find Tracks
    trackList = []
    artistList = []
    writerList = []
    diskCount = 0

    normalTracks()


    if len(trackList) > 0:
        trackList.sort()
        trackTitles = array(trackList, String)

    if len(artistList) > 0:
        artistList.sort()
        trackArtists = array(artistList, String)

    if len(writerList) > 0:
        writerList.sort()
        trackWriters = array(writerList, String)


    # Find Comments
    comments = ""
    i = string.find(source, "Title Note")

    if (i != -1):
        source = searchForPlus(source, "Title Note")
        source = searchForPlus(source, "\">")
        i = string.find(source, "</table>")
        tempcomments = stripText(source[0:i])

        tempcomments = string.replace(tempcomments, "\n", " ")
        tempcomments = string.replace(tempcomments, "<i>", "")
        tempcomments = string.replace(tempcomments, "</i>", "")
        tempcomments = string.replace(tempcomments, "<I>", "")
        tempcomments = string.replace(tempcomments, "</I>", "")
        tempcomments = string.replace(tempcomments, "<br>", "\n")
        tempcomments = string.replace(tempcomments, "<tr>", "\n")
        tempcomments = string.replace(tempcomments, "<td>", "")
        tempcomments = string.replace(tempcomments, "</td>", "")
        tempcomments = string.replace(tempcomments, "</tr>", "")
        tempcomments = string.replace(tempcomments, "\n ", "\n")

        while (searchFor(tempcomments, "<td ") != None):
            i = string.find(tempcomments, "<td ")
            j = string.find(tempcomments[i:], "\">")
            tempcomments = tempcomments[0:i] + tempcomments[i+j+2:]

        while (searchFor(tempcomments, "<a ") != None):
            i = string.find(tempcomments, "<a ")
            j = string.find(tempcomments[i:], "\">")
            tempcomments = tempcomments[0:i] + tempcomments[i+j+2:]

        while (searchFor(tempcomments, "<table ") != None):
            i = string.find(tempcomments, "<table ")
            j = string.find(tempcomments[i:], "</table>")
            tempcomments = tempcomments[0:i] + tempcomments[i+j+8:]

        comments = tempcomments






def normalTracks():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,image,fullDateFormat,source
    global trackList,artistList,writerList,diskCount,switchArtist

    i = string.find(source, ">Track Listing")

    if i != -1:
        source = searchForPlus(source, ">Track Listing")
        i = string.find(source, "</td></tr></table>")
        disks = stripText(source[0:i+12])

        while (searchFor(disks, ">DISC ") != None):
            disks = searchForPlus(disks, ">DISC ")
            i = string.find(disks, "<")
            diskid = "%02d" % stripText(disks[0:i])
            i = string.find(disks, "</table>")
            tracks = stripText(disks[0:i])
            disks = searchForPlus(disks, "</table>")

            diskCount = diskCount + 1
            trackIndex = 1

            while (searchFor(tracks, "&nbsp;</strong>") != None):
                tracks = searchForPlus(tracks, "&nbsp;</strong>")
                i = string.find(tracks, "<")
                track = stripText(tracks[0:i])
                trackid = "%02d" % trackIndex
                trackIndex = trackIndex + 1

                trackArtist = ""
                i = string.find(track, " - ")

                if (i == -1):
                    i = string.find(track, " / ")

                if (i != -1):
                    trackArtist = stripText(track[i+3:])

                    if trackArtist[0:1] == "(":
                        trackArtist = ""
                    else:
                        track = stripText(track[0:i])

                if track == "":
                    continue

                trackList.append(diskid + "-" + trackid + "-" + track)

                if trackArtist != "":
                    trackArtist = convertArtist(trackArtist)

                    if switchArtist == "Y":
                        i = string.rfind(trackArtist, " ")

                        if (i != -1):
                            artist = stripText(trackArtist[i+1:]) + ", " + stripText(trackArtist[0:i])

                    artistList.append(diskid + "-" + trackid + "-" + trackArtist)
                else:
                    artistList.append(diskid + "-" + trackid + "-")


try:
    extract()
finally:
    if os.path.exists("scrapers/awuserexit.py"):
        execfile("scrapers/awuserexit.py") in globals()
