# Loot.co.za music scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import convertArtist
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    sound               = "Stereo"
    format              = "CD"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    artistLF            = ""


    i = string.find(source, "<span class='heading'>Showing")

    if i != -1:
        source = searchForPlus(source, "<span class='heading'>Showing")
        source = searchForPlus(source, "href='")
        i = string.find(source, "'")
        url = stripText("http://www.loot.co.za" + source[0:i])
        url = string.replace(url, "&amp;", "&")
        http = HTTPConnection()
        http.resetReferer();
        http.blockForLoad();
        source = http.getContents(url)
        t2 = open("trace2.html", "w")
        t2.write(source)
        t2.close()


    # Find marketplace pricing
    marketinfo = source


    # Find Title
    source = searchForPlus(source, "class='detailprodname'")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Image
    imageTag = "/images/x120/"
    i = string.find(source, imageTag)

    if i != -1:
        source = source[i-50:]
        source = searchForPlus(source, " src='")
        i = string.find(source, "'")
        image = stripText(source[0:i])

        if source[i:].startswith("' width=1 height=1") == 1:
            image = ""


    # Find Artist
    i = string.find(source, "class='authors'")

    if i != -1:
        source = searchForPlus(source, "class='authors'")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        artist = stripText(source[0:i])
        artist = convertArtist(artist)


    # Find Price
    i = string.find(source, "class='prodprice'")

    if i != -1:
        source = searchForPlus(source, "class='prodprice'")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find Comments
    i = string.find(source, "name=\"synopsis\"")

    if i != -1:
        source = searchForPlus(source, "name=\"synopsis\"")
        source = searchForPlus(source, "<hr ")
        source = searchForPlus(source, ">")
        i = string.find(source, "<hr ")
        comments = stripText(source[0:i])

        while (searchFor(comments, "\n") != None):
            comments = string.replace(comments, "\n", " ")

        comments = string.replace(comments, "<p>", "\n\n")

        while (searchFor(comments, "\n ") != None):
            comments = string.replace(comments, "\n ", "\n")


    # Find Label
    i = string.find(source, ">Label:<")

    if i != -1:
        label = searchForPlus(source, ">Label:<")
        label = searchForPlus(label, "class=\"detailvalue\"")
        label = searchForPlus(label, ">")
        i = string.find(label, "<")
        label = stripText(label[0:i])


    # Find Label
    i = string.find(source, ">Format:<")

    if i != -1:
        format = searchForPlus(source, ">Format:<")
        format = searchForPlus(format, "alt='")
        i = string.find(format, "'")
        format = stripText(format[0:i])


    # Find Category
    i = string.find(source, ">Categories:<")

    if i != -1:
        category = searchForPlus(source, ">Categories:<")
        category = searchForPlus(category, "class=\"detailvalue\"")
        category = searchForPlus(category, "\">")
        i = string.find(category, "<")
        category = stripText(category[0:i])


    # Find Tracks
    i = string.find(source, ">Track listing<")

    if i != -1:
        source = searchForPlus(source, ">Track listing<")
        i = string.find(source, "</table>")
        disks = stripText(source[0:i])

        trackList = []
        artistList = []
        diskCount = 0

        while (searchFor(disks, ">Disk ") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, ">Disk ")
            i = string.find(disks, ":")
            diskid = "%02d" % stripText(disks[0:i])

            i = string.find(disks, "</ol>")
            tracks = stripText(disks[0:i+5])
            trackIndex = 1

            while (searchFor(tracks, "<li>") != None):
                tracks = searchForPlus(tracks, "<li>")
                trackid = "%02d" % trackIndex
                i = string.find(tracks, "<")
                track = stripText(tracks[0:i])

                i = string.find(track, " - ")
                trackArtist = ""

                if i != -1:
                    trackArtist = stripText(track[i+3:])
                    track = stripText(track[0:i])

                trackList.append(diskid + "-" + trackid + "-" + track)
                trackIndex = trackIndex + 1

                if trackArtist != "":
                    trackArtist = convertArtist(trackArtist)
                    artistList.append(diskid + "-" + trackid + "-" + trackArtist)
                else:
                    artistList.append(diskid + "-" + trackid + "-")

        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)


    # Find user rating
    i = string.find(source, ">Average Customer Review:<")

    if i != -1:
        temp = searchForPlus(source, ">Average Customer Review:<")
        temp = searchForPlus(temp, "<img src=\"")
        i = string.find(temp, "\"")
        temp = stripText(temp[0:i])
        i = string.rfind(temp, "/")

        if i != -1:
            temp = stripText(temp[i+1:])

        i = string.find(temp, ".")

        if i != -1:
            temp = stripText(temp[0:i])

        if temp.startswith("stars-") == 1:
            temp = searchForPlus(temp, "stars-")

        temp = string.replace(temp, "-", ".")

        if temp != "":
            rating = temp + " Stars"








try:
    extract()
finally:
    if os.path.exists("scrapers/awuserexit.py"):
        execfile("scrapers/awuserexit.py") in globals()
