# LOC [2] music scrpaer
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import convertArtist
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    sound               = "Stereo"
    format              = "LP"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    artistLF            = ""


    # Main extraction
    # Determine page format
    i = string.find(source, "view1a.gif")

    if (i != -1):
        source = searchForPlus(source, "view2.gif")
        source = searchForPlus(source, "<A HREF=\"")
        i = string.find(source, "\"")
        url = "http://catalog.loc.gov" + stripText(source[0:i])
        http = HTTPConnection()
        http.resetReferer();
        http.blockForLoad();
        source = http.getContents(url)


    # Find LCCN
    i = string.find(source, ">LC Control Number:<")
    
    if i != -1:
        lccn = searchForPlus(source, ">LC Control Number:<")
        lccn = searchForPlus(lccn, "<TD ")
        lccn = searchForPlus(lccn, ">")
        i = string.find(lccn, "</TD>")
        lccn = stripText(lccn[0:i])
        lccn = string.replace(lccn, "<STRONG>", "")
        lccn = string.replace(lccn, "</STRONG>", "")
        lccn = string.replace(lccn, "<I>", "")
        lccn = string.replace(lccn, "</I>", "")


    # Find Artist
    artistTag = ">Personal Name:<"
    i = string.find(source, artistTag)

    if i == -1:
        artistTag = ">Related Names:<"
        i = string.find(source, artistTag)

    if i != -1:
        artist = searchForPlus(source, artistTag)
        artist = searchForPlus(artist, "<TD ")
        artist = searchForPlus(artist, ">")
        i = string.find(artist, "</TD>")
        artist = stripText(artist[0:i])
        i = string.find(artist, "<A HREF=")

        if i != -1:
            artist = searchForPlus(artist, "\">")
            i = string.find(artist, "</A>")
            artist = stripText(artist[0:i])

        i = string.find(artist, " prf")

        if i != -1:
            artist = stripText(artist[0:i])

        i = string.find(artist, " [")

        if i != -1:
            artist = stripText(artist[0:i])

        artist = string.replace(artist, "<STRONG>", "")
        artist = string.replace(artist, "</STRONG>", "")
        artist = string.replace(artist, "<I>", "")
        artist = string.replace(artist, "</I>", "")


    # Find Title
    i = string.find(source, ">Main Title:<")

    if i != -1:
        title = searchForPlus(source, ">Main Title:<")
        title = searchForPlus(title, "<TD ")
        title = searchForPlus(title, ">")
        i = string.find(title, "</TD>")
        title = stripText(title[0:i])

        i = string.find(title, " [")

        if i != -1:
            title = stripText(title[0:i])

        title = string.replace(title, "<STRONG>", "")
        title = string.replace(title, "</STRONG>", "")
        title = string.replace(title, "<I>", "")
        title = string.replace(title, "</I>", "")


    # Find Label/Date
    i = string.find(source, ">Published/Created:<")

    if i != -1:
        label = searchForPlus(source, ">Published/Created:<")
        label = searchForPlus(label, "<TD ")
        label = searchForPlus(label, ">")
        i = string.find(label, "</TD>")
        label = stripText(label[0:i])

        label = string.replace(label, "<STRONG>", "")
        label = string.replace(label, "</STRONG>", "")
        label = string.replace(label, "<I>", "")
        label = string.replace(label, "</I>", "")

        i = string.find(label, " : ")

        if i != -1:
            label = searchForPlus(label, " : ")

        i = string.find(label, ", ")

        if i != -1:
            date = stripText(label[i+1:])
            label = stripText(label[0:i])

            i = string.find(date, "p")    

            if i != -1:
                date = stripText(date[i+1:])

            i = string.find(date, ".")    

            if i != -1:
                date = stripText(date[0:i])

            copyDate = date



    # Find Tracks
    i = string.find(source, ">Contents:<")

    if i != -1:
        source = searchForPlus(source, ">Contents:<")
        source = searchForPlus(source, "<TD ")
        source = searchForPlus(source, ">")
        i = string.find(source, "</TD>")
        disks = stripText(source[0:i])
        print "DISKS=",disks

        if string.find(disks, ">Disc: ") == -1:
            disks = ">Disc: 1<" + disks

        trackList = []
        diskCount = 0

        while (searchFor(disks, ">Disc: ") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, ">Disc: ")
            i = string.find(disks, "<")
            diskid = "%02d" % stripText(disks[0:i])

            tracks = stripText(disks[i+1:]) + "--"
            trackIndex = 1
            print "tracks=",disks

            while (searchFor(tracks, "--") != None):
                i = string.find(tracks, "--")
                trackid = "%02d" % trackIndex
                track = stripText(tracks[0:i])
                track = string.replace(track, "<STRONG>", "")
                track = string.replace(track, "</STRONG>", "")
                track = string.replace(track, "<I>", "")
                track = string.replace(track, "</I>", "")
                track = string.replace(track, "&rsquo;", "'")
                trackList.append(diskid + "-" + trackid + "-" + track)
                trackIndex = trackIndex + 1
                tracks = searchForPlus(tracks, "--")

        trackList.sort()
        trackTitles = array(trackList, String)


    # Find Comments
    i = string.find(source, ">Notes:<")

    if (i != -1):
        source = searchForPlus(source, ">Notes:<")
        source = searchForPlus(source, ">")
        i = string.find(source, "<TH ")
        comments = source[0:i]

        comments = string.replace(comments, "\n", "")
        comments = string.replace(comments, "<BR>", "\n")
        comments = string.replace(comments, "<TD dir=\"ltr\">", "\n")
        comments = string.replace(comments, "<STRONG>", "")
        comments = string.replace(comments, "</STRONG>", "")
        comments = string.replace(comments, "<I>", "")
        comments = string.replace(comments, "</I>", "")
        comments = string.replace(comments, "<TR>", "")
        comments = string.replace(comments, "</TR>", "")
        comments = string.replace(comments, "<TD>", "")
        comments = string.replace(comments, "</TD>", "")


    # Find Category
    i = string.find(source, ">Subjects:<")

    if (i != -1):
        category = searchForPlus(source, ">Subjects:<")
        category = searchForPlus(category, "<TD ")
        category = searchForPlus(category, ">")
        i = string.find(category, "</TD>")
        category = category[0:i]
        i = string.find(category, "<A HREF=")

        if i != -1:
            category = searchForPlus(category, "\">")
            i = string.find(category, "<")
            category = stripText(category[0:i])





try:
    extract()
finally:
    if os.path.exists("scrapers/awuserexit.py"):
        execfile("scrapers/awuserexit.py") in globals()
