# Real Groovy [NZ] music scrpaer
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import convertArtist
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    sound               = "Stereo"
    format              = "CD"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    artistLF            = ""


    # Find marketplace pricing
    marketinfo = source



    # Find Image
    i = string.find(source, "class=\"boxRuleTopMidBlue\"")

    if i != -1:
        image = ""
        source = searchForPlus(source, "class=\"boxRuleTopMidBlue\"")

        i = string.find(source, " src=\"productimages")

        if i != -1:
            source = searchFor(source, " src=\"productimages")
            source = searchForPlus(source, " src=\"")
            i = string.find(source, "\"")
            image = "http://www.realgroovy.co.nz/" + stripText(source[0:i])

        i = string.find(source, " src=\"http://www.imageserver")

        if i != -1:
            source = searchFor(source, " src=\"http://www.imageserver")
            source = searchForPlus(source, " src=\"")
            i = string.find(source, "\"")
            image = stripText(source[0:i])

        i = string.find(image, "music-no-image")

        if i != -1:
            image = ""


    # Find Price
    i = string.find(source, ">NZ$")

    if i != -1:
        source = searchFor(source, ">NZ$")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find Comments
    i = string.find(source, "<b>REAL GROOVY COMMENTS")

    if i != -1:
        source = searchForPlus(source, "<b>REAL GROOVY COMMENTS")
        i = string.find(source, "<a name=\"details\">")
        comments = "REAL GROOVY COMMENTS\n" + stripText(source[0:i])

        comments = string.replace(comments, "</b>", "")
        comments = string.replace(comments, "</font>", "")
        comments = string.replace(comments, "</p>", "")
        comments = string.replace(comments, "<br />", "\n")


    # Find Title
    i = string.find(source, ">Title:<")

    if (i != -1):
        source = searchForPlus(source, ">Title:<")
        source = searchForPlus(source, "<p>")
        i = string.find(source, "<")
        title = stripText(source[0:i])


    # Find Artist
    i = string.find(source, ">Artist:<")

    if (i != -1):
        source = searchForPlus(source, ">Artist:<")
        source = searchForPlus(source, "<p>")
        i = string.find(source, "<")
        artist = stripText(source[0:i])
        artist = convertArtist(artist)


    # Find Label
    i = string.find(source, ">Label:<")

    if i != -1:
        source = searchForPlus(source, ">Label:<")
        source = searchForPlus(source, "<p>")
        i = string.find(source, "<")
        label = stripText(source[0:i])


    # Find Format
    i = string.find(source, ">Format:<")

    if i != -1:
        source = searchForPlus(source, ">Format:<")
        source = searchForPlus(source, "<p>")
        i = string.find(source, "<")
        format = stripText(source[0:i])


    # Find Date
    i = string.find(source, ">Release Date:<")

    if i != -1:
        source = searchForPlus(source, ">Release Date:<")
        source = searchForPlus(source, "<p>")
        i = string.find(source, "<")
        date = stripText(source[0:i])


    # Find Tracks
    i = string.find(source, ">TRACK LISTING")

    if i != -1:
        source = searchFor(source, ">TRACK LISTING")
        i = string.find(source, "</table>")
        disks = stripText(source[0:i])

        if string.find(disks, ">Disc: ") == -1:
            disks = ">Disc: 1<" + disks

        trackList = []
        artistList = []
        diskCount = 0

        while (searchFor(disks, ">TRACK LISTING") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, ">TRACK LISTING")
            disks = searchForPlus(disks, "DISC ")
            i = string.find(disks, "<")
            diskid = "%02d" % stripText(disks[0:i])

            i = string.find(disks, "<td colspan=\"2\">")
            tracks = stripText(disks[0:i])
            trackIndex = 1

            while (searchFor(tracks, ". ") != None):
                trackid = "%02d" % trackIndex

                tracks = searchForPlus(tracks, ". ")
                i = string.find(tracks, "<")
                track = stripText(tracks[0:i])

                i = string.find(track, " - ")
                trackArtist = ""

                if i != -1:
                    trackArtist = stripText(track[i+3:])
                    track = stripText(track[0:i])

                trackList.append(diskid + "-" + trackid + "-" + track)

                trackIndex = trackIndex + 1

                if trackArtist != "":
                    trackArtist = convertArtist(trackArtist)
                    artistList.append(diskid + "-" + trackid + "-" + trackArtist)
                else:
                    artistList.append(diskid + "-" + trackid + "-")

        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)



try:
    extract()
finally:
    if os.path.exists("scrapers/awuserexit.py"):
        execfile("scrapers/awuserexit.py") in globals()
