# Sam Goody scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripHTML
from    scrapers.scrapers import convertArtist
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    sound               = "Stereo"
    format              = "CD"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    artistLF            = ""

    switchArtist        = "N"
    largeImage          = "Y"
    available           = "Y"
    buyerwaiting        = "N"


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Main extraction
    i = string.find(source, "Please wait while we search for the requested item")

    if i != -1:
        source = searchFor(source, "force exception")
        source = searchFor(source, "force exception")


    i = string.find(source, ">General Error<")

    if i != -1:
        source = searchFor(source, "force exception")
        source = searchFor(source, "force exception")


    # Find Title
    source = searchForPlus(source, "\"header03\"")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    title = stripText(source[0:i])
    i = string.find(title, "&nbsp;")

    if i != -1:
        title = stripText(title[0:i])

    title = stripHTML(title)


    # Find Format
    i = string.find(source, "&nbsp;Compact Disc")

    if i != -1:
        format = stripHTML(source[i+6:i+18])


    # Find Artist
    i = string.find(source, "\"contentlink\"")

    if i != -1 and i < 250:
        source = searchForPlus(source, "\"contentlink\"")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        artist = stripText(source[0:i])
        artist = convertArtist(artist)


    # Find Image
    i = string.find(source, "/coverart")

    if i != -1 and i < 400:
        source = searchForPlus(source, "src=\"")
        i = string.find(source, "\"")
        image = stripHTML(source[0:i])

        i = string.find(source, ">Larger Image<")

        if i != -1:
            source = searchForPlus(source, "windowPop('")
            i = string.find(source, "'")
            image = stripHTML(source[0:i])

        i = string.find(image, "music_79x79.gif")

        if i != -1:
            image = ""

        i = string.find(image, "movies_79x79.gif")

        if i != -1:
            image = ""


    # Find AMG Rating
    i = string.find(source, ">AMG Rating:")

    if i != -1:
        rating = searchForPlus(source, ">AMG Rating:")
        rating = searchForPlus(rating, "/ratings/")
        i = string.find(rating, "\"")
        rating = stripHTML(rating[0:i])

        if rating == "2_amg_rating.gif":
            rating = "1 Stars"

        if rating == "3_amg_rating.gif":
            rating = "1 1/2 Stars"

        if rating == "4_amg_rating.gif":
            rating = "2 Stars"

        if rating == "5_amg_rating.gif":
            rating = "2 1/2 Stars"

        if rating == "6_amg_rating.gif":
            rating = "3 Stars"

        if rating == "7_amg_rating.gif":
            rating = "3 1/2 Stars"

        if rating == "8_amg_rating.gif":
            rating = "4 Stars"

        if rating == "9_amg_rating.gif":
            rating = "4 1/2 Stars"


    # Find Label
    i = string.find(source, "Label:<")

    if i != -1:
        label = searchForPlus(source, "Label:<")
        label = searchForPlus(label, "\">")
        i = string.find(label, "<")
        label = stripHTML(label[0:i])


    # Find Category
    i = string.find(source, ">Style:")

    if i != -1:
        category = searchForPlus(source, ">Style:")
        category = searchForPlus(category, "\">")
        i = string.find(category, "<")
        category = stripHTML(category[0:i])


    # Find Release date
    i = string.find(source, ">Release Date:")

    if i != -1:
        date = searchForPlus(source, ">Release Date:")
        date = searchForPlus(date, "\">")
        i = string.find(date, "<")
        date = stripHTML(date[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, " ")

            if i != -1:
                date = stripText(date[i+1:])


    # Find Price
    i = string.find(source, ">Price:")

    if i != -1:
        value = searchForPlus(source, ">Price:")
        value = searchForPlus(value, "\">")
        value = searchFor(value, "$")
        i = string.find(value, "<")
        value = stripHTML(value[0:i])



    # Find Tracks
    i = string.find(source, ">Track Listing:<")
    trackList = []
    artistList = []

    if (i != -1):
        source = searchForPlus(source, ">Track Listing:<")
        source = searchForPlus(source, "width=\"100%\"")
        i = string.find(source, "</table")
        tracks = source[0:i]

        while (searchFor(tracks, "\"content02\"") != None):
            tracks = searchForPlus(tracks, "\"content02\"")
            tracks = searchForPlus(tracks, ">")
            i = string.find(tracks, ".<")
            trackNum = "%02d" % stripText(tracks[0:i])
            tracks = searchForPlus(tracks, "\"content02\"")
            tracks = searchForPlus(tracks, "\"content02\"")
            tracks = searchForPlus(tracks, ">")
            i = string.find(tracks, "<")

            if tracks[i: i+8] == "<a href=":
                tracks = searchForPlus(tracks, "\">")
                i = string.find(tracks, "<")

            track = stripText(tracks[0:i])

            i = string.find(track, " - ")
            trackArtist = ""

            if (i != -1):
                if track[i+3:i+4] != "(":
                    trackArtist = stripText(track[i+3:])
                    track = stripText(track[0:i])

            trackList.append("01-" + trackNum + "-" + track)

            if trackArtist != "":
                trackArtist = convertArtist(trackArtist)
                artistList.append("01-" + trackNum + "-" + trackArtist)
            else:
                artistList.append("01-" + trackNum + "-")

    trackList.sort()
    trackTitles = array(trackList, String)
    artistList.sort()
    trackArtists = array(artistList, String)


    # Find Comments
    comments = ""
    i = string.find(source, ">Reviews:")

    if (i != -1):
        source = searchForPlus(source, ">Reviews:")
        source = searchForPlus(source, "\"content02\">")
        i = string.find(source, "</td>")
        comments = stripText(source[0:i])
        comments = string.replace(comments, "\n", " ")
        comments = string.replace(comments, "<p>", "\n\n")
        comments = string.replace(comments, "<P>", "\n\n")
        comments = string.replace(comments, "<i>", "")
        comments = string.replace(comments, "</i>", "")
        comments = string.replace(comments, "<I>", "")
        comments = string.replace(comments, "</I>", "")
        comments = string.replace(comments, "<BR>", "\n")

        while (searchFor(comments, "<A ") != None):
            i = string.find(comments, "<A ")
            j = string.find(comments[i:], "\">")
            comments = comments[0:i] + comments[i+j+2:]

        comments = string.replace(comments, "</A>", "")


try:
    extract()
finally:
    if os.path.exists("scrapers/awuserexit.py"):
        execfile("scrapers/awuserexit.py") in globals()
