# Family Christian Stores video scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import convertArtist
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    sound               = "Stereo"
    format              = "CD"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    artistLF            = ""


    i = string.find(source, "matching records...<")

    if i != -1:
        source = searchFor(source, "<a href=\"/shop/product.asp?prodID=")
        source = searchForPlus(source, "\"")
        i = string.find(source, "\"")
        url = "http://www.familychristian.com" + stripText(source[0:i])
        http = HTTPConnection()
        http.resetReferer();
        http.blockForLoad();
        source = http.getContents(url)


    # Find marketplace pricing


    # Main extraction
    i = string.find(source, "<!--Begin Content Well-->")

    if i == -1:
        title = ""
        return

    source = searchForPlus(source, "<!--Begin Content Well-->")


    # Find Image
    i = string.find(source, "images/shop")

    if i != -1:
        source = source[i-25:]
        source = searchForPlus(source, " SRC=")
        i = string.find(source, " ")
        image = stripText(source[0:i])

        i = string.find(image, "dvd-no-image.gif")

        if i != -1:
            image = ""
        else:
            image = "http://www.familychristian.com/" + image


    # Find Format
    i = string.find(source, "Format:")

    if i != -1: 
        source = searchForPlus(source, "Format:")
        i = string.find(source, "<")
        format = stripText(source[0:i])


    # Find Value
    i = string.find(source, "Retail:")

    if i != -1:
        source = searchForPlus(source, "Retail:")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find Title
    source = searchForPlus(source, "CLASS=\"title\"")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Artist
    i = string.find(source, "&Ntt=")

    if i != -1:
        source = searchForPlus(source, "&Ntt=")
        i = string.find(source, "\"")
        artistLF = stripText(source[0:i])
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        artist = stripText(source[0:i])
        artist = convertArtist(artist)


    # Find Comments
    i = string.find(source, "line.gif")

    if (i != -1):
        comments = ""
        source = searchForPlus(source, "line.gif")
        source = searchForPlus(source, "<BR>")
        i = string.find(source, "<BR ")
        comments = stripText(source[0:i])

        i = string.find(comments, "<br ")

        if (i != -1):
            comments = stripText(comments[0:i])

        i = string.find(comments, "<font")

        if (i != -1):
            comments = stripText(comments[0:i])

        i = string.find(comments, "<FONT")

        if (i != -1):
            comments = stripText(comments[0:i])

        i = string.find(comments, "<table")

        if (i != -1):
            comments = stripText(comments[0:i])

        comments = string.replace(comments, "<i>", "")
        comments = string.replace(comments, "<I>", "")
        comments = string.replace(comments, "</i>", "")
        comments = string.replace(comments, "</I>", "")
        comments = string.replace(comments, "<P>", "")
        comments = string.replace(comments, "<p>", "")
        comments = string.replace(comments, "<BR>", "\n")
        comments = string.replace(comments, "<br>", "\n")
        comments = string.replace(comments, "<strong>", "")
        comments = string.replace(comments, "</strong>", "")
        comments = string.replace(comments, "</SPAN>", "")
        comments = string.replace(comments, "<LI>", "")
        comments = string.replace(comments, "</LI>", "")

        while (searchFor(comments, "<SPAN") != None):
            i = string.find(comments, "<SPAN")
            j = string.find(comments[i:], ">")
            comments = comments[0:i] + comments[i+j+1:]


    # Find Tracks
    i = string.find(source, ">Track Listing:<")

    if i != -1:
        source = searchForPlus(source, ">Track Listing:<")
        i = string.find(source, "<BR CLEAR")
        disks = stripText(source[0:i])

        if string.find(disks, ">DISC ONE:<") == -1:
            disks = ">DISC ONE:<" + disks

        trackList = []
        artistList = []
        diskCount = 0

        while (searchFor(disks, ">DISC ") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, ">DISC ")
            i = string.find(disks, "<")
            diskid = "%02d" % diskCount
            disks = searchForPlus(disks, "\n")

            tracks = stripText(disks)

            delimiter = "<br>"
            i = string.find(tracks, delimiter)

            if i == -1:
                delimiter = "<BR>"
                i = string.find(tracks, delimiter)

            if i == -1:
                delimiter = "</LI>"
                i = string.find(tracks, delimiter)
                
            tracks = tracks + " " + delimiter + " "
            tracks = string.replace(tracks, "\t", " ")
            tracks = string.replace(tracks, "<LI>", " ")

            i = string.find(tracks, ">DISC ")

            if i != -1:
                tracks = stripText(tracks[0:i]) + " " + delimiter + " "

            trackIndex = 1

            while (searchFor(tracks, delimiter) != None):
                tracks = searchForPlus(tracks, " ")
                tracks = stripText(tracks)

                if (tracks[0:1] == "<"):
                    i = string.find(tracks, ">")
                    tracks = stripText(tracks[i+1:])

                i = string.find(tracks, delimiter)

                if i != -1:
                    trackid = "%02d" % trackIndex
                    track = stripText(tracks[0:i])

                    i = string.find(track, " by ")
                    trackArtist = ""

                    if (i != -1):
                        trackArtist = stripText(track[i+4:])
                        track = stripText(track[0:i])

                    i = string.find(track, "<")

                    if (i != -1):
                        track = stripText(track[0:i])

                    i = string.find(trackArtist, "<")

                    if (i != -1):
                        trackArtist = stripText(trackArtist[0:i])

                    trackList.append(diskid + "-" + trackid + "-" + track)
                    trackIndex = trackIndex + 1
                    i = string.find(tracks, "<")

                    if trackArtist != "":
                        trackArtist = convertArtist(trackArtist)
                        artistList.append(diskid + "-" + trackid + "-" + trackArtist)
                    else:
                        artistList.append(diskid + "-" + trackid + "-")

                    tracks = searchForPlus(tracks, delimiter)


        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)


    i = string.find(source, ">Track Listing<")

    if i != -1:
        source = searchForPlus(source, ">Track Listing<")
        i = string.find(source, "<BR CLEAR")
        disks = stripText(source[0:i])

        if string.find(disks, ">Disc: ") == -1:
            disks = ">Disc: 1<" + disks

        trackList = []
        artistList = []
        diskCount = 0

        while (searchFor(disks, ">Disc: ") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, ">Disc: ")
            i = string.find(disks, "<")
            diskid = "%02d" % stripText(disks[0:i])
            disks = searchForPlus(disks, "\n")

            tracks = stripText(disks)

            delimiter = "<br />"
            i = string.find(tracks, delimiter)

            if i == -1:
                delimiter = "<BR />"
                i = string.find(tracks, delimiter)
                
            tracks = tracks + " " + delimiter + " "
            trackIndex = 1

            while (searchFor(tracks, ". ") != None):
                tracks = searchForPlus(tracks, ". ")
                tracks = stripText(tracks)

                if (tracks[0:1] == "<"):
                    i = string.find(tracks, ">")
                    tracks = stripText(tracks[i+1:])

                i = string.find(tracks, delimiter)

                if i != -1:
                    trackid = "%02d" % trackIndex
                    track = stripText(tracks[0:i])

                    i = string.find(track, " by ")
                    trackArtist = ""

                    if (i != -1):
                        trackArtist = stripText(track[i+4:])
                        track = stripText(track[0:i])

                    i = string.find(track, "<")

                    if (i != -1):
                        track = stripText(track[0:i])

                    i = string.find(trackArtist, "<")

                    if (i != -1):
                        trackArtist = stripText(trackArtist[0:i])

                    trackList.append(diskid + "-" + trackid + "-" + track)
                    trackIndex = trackIndex + 1
                    i = string.find(tracks, "<")

                    if trackArtist != "":
                        trackArtist = convertArtist(trackArtist)
                        artistList.append(diskid + "-" + trackid + "-" + trackArtist)
                    else:
                        artistList.append(diskid + "-" + trackid + "-")

                    tracks = searchForPlus(tracks, delimiter)


        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)


    # Find Release date
    i = string.find(source, "release date of")

    if i != -1:
        source = searchForPlus(source, "release date of")
        i = string.find(source, "<")
        date = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, "/")

            if i != -1:
                date = stripText(date[i+1:])



try:
    extract()
finally:
    if os.path.exists("scrapers/awuserexit.py"):
        execfile("scrapers/awuserexit.py") in globals()
