# EIL.COM music scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import convertArtist
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    sound               = "Stereo"
    format              = "CD"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    artistLF            = ""


    # Find marketplace pricing
    marketinfo = source


    # Main extraction
    source = searchForPlus(source, "COLSPAN=\"3\">")


    # Find Comments
    source = searchForPlus(source, "<FONT")
    source = searchForPlus(source, ">")
    i = string.find(source, "</FONT>")
    comments = stripText(source[0:i])
    comments = string.replace(comments, "\n", " ")
    comments = string.replace(comments, "  ", " ")


    # Find Image
    i = string.find(source, "<IMG ALT")

    if i != -1:
        source = searchForPlus(source, "<IMG ALT")
        source = searchForPlus(source, " SRC=\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])

        i = string.find(image, "music-no-image")

        if i != -1:
            image = ""


    # Find Tracks
    i = string.find(source, ">Tracklisting ")

    if i != -1:
        source = searchForPlus(source, ">Tracklisting ")
        source = searchForPlus(source, "<TABLE BORDER=\"0\"")
        source = searchForPlus(source, "<TD>")
        source = searchForPlus(source, "\">")
        i = string.find(source, "</TD>")
        disks = stripText(source[0:i])

        if string.find(disks, ">Disc: ") == -1:
            disks = ">Disc: 1<" + disks

        trackList = []
        artistList = []
        diskCount = 0

        while (searchFor(disks, ">Disc: ") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, ">Disc: ")
            i = string.find(disks, "<")
            diskid = "%02d" % stripText(disks[0:i])

            i = string.find(disks, "</FONT>")
            tracks = stripText(disks[0:i+1])
            trackIndex = 1

            while (searchFor(tracks, ". ") != None):
                tracks = searchForPlus(tracks, ". ")
                i = string.find(tracks, "<")

                if i != -1:
                    trackid = "%02d" % trackIndex
                    track = stripText(tracks[0:i])

                    i = string.find(track, " - ")
                    trackArtist = ""

                    if i != -1:
                        trackArtist = stripText(track[i+3:])
                        track = stripText(track[0:i])

                    trackList.append(diskid + "-" + trackid + "-" + track)
                    trackIndex = trackIndex + 1
                    i = string.find(tracks, "<")

                    if trackArtist != "":
                        trackArtist = convertArtist(trackArtist)
                        artistList.append(diskid + "-" + trackid + "-" + trackArtist)
                    else:
                        artistList.append(diskid + "-" + trackid + "-")

        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)


    # Find Artist
    i = string.find(source, ">Artist:<")

    if (i != -1):
        source = searchForPlus(source, ">Artist:<")
        source = searchForPlus(source, "<u>")
        i = string.find(source, "<")
        artist = stripText(source[0:i])
        artist = convertArtist(artist)


    # Find Title
    i = string.find(source, ">Title:<")

    if i != -1:
        source = searchForPlus(source, ">Title:<")
        source = searchForPlus(source, "<u>")
        i = string.find(source, "<")
        title = stripText(source[0:i])


    # Find Price
    i = string.find(source, ">Price:<")

    if i != -1:
        source = searchForPlus(source, ">Price:<")
        source = searchForPlus(source, "<FONT")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        value = stripText(source[0:i])

        i = string.find(value, ",")

        if i != -1:
            value = stripText(value[0:i])


    # Find Format
    i = string.find(source, ">Format:<")

    if i != -1:
        source = searchForPlus(source, ">Format:<")
        source = searchForPlus(source, "<FONT")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        format = stripText(source[0:i])


    # Find Label
    i = string.find(source, ">Record Label:<")

    if i != -1:
        source = searchForPlus(source, ">Record Label:<")
        source = searchForPlus(source, "<FONT")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        label = stripText(source[0:i])


    # Find Date
    i = string.find(source, ">Year of Release:<")

    if i != -1:
        source = searchForPlus(source, ">Year of Release:<")
        source = searchForPlus(source, "<FONT")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        date = stripText(source[0:i])
        copyDate = date


    # Find Category
    i = string.find(source, ">Genres:<")

    if i != -1:
        source = searchForPlus(source, ">Genres:<")
        source = searchForPlus(source, "<U>")
        i = string.find(source, "<")
        category = stripText(source[0:i])





try:
    extract()
finally:
    if os.path.exists("scrapers/awuserexit.py"):
        execfile("scrapers/awuserexit.py") in globals()
