# Discogs music scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import convertArtist
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    sound               = "Stereo"
    format              = "CD"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    artistLF            = ""


    # Find marketplace pricing
    marketinfo = source


    # Find Buyer Waiting
    i = string.find(marketinfo, "&nbsp;members&nbsp;want&nbsp;this")

    if i != -1:
        buyerwaiting = stripText(marketinfo[i-10:])
        buyerwaiting = searchForPlus(buyerwaiting, ">")
        i = string.find(buyerwaiting, "&")
        buyerwaiting = stripText(buyerwaiting[0:i])

        if buyerwaiting == "0":
            buyerwaiting = "N"
        else:
            buyerwaiting = "Y"


    # Main Extraction
    source = searchForPlus(source, "<table border=0 cellpadding=2 cellspacing=2>")


    # Find Artist
    i = string.find(source, "\"/artist/")

    if i != -1 and i < 200:
        source = searchForPlus(source, "\"/artist/")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        artist = stripText(source[0:i])
        artist = convertArtist(artist)


    # Find Title
    source = searchForPlus(source, "- ")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Image
    imageTag = "/image/"
    i = string.find(source, imageTag)

    if i != -1:
        source = source[i-50:]
        source = searchForPlus(source, " src=\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])

        i = string.find(image, "music-no-image")

        if i != -1:
            image = ""


    # Find Label
    i = string.find(source, ">Label:<")

    if i != -1:
        label = searchForPlus(source, ">Label:<")
        label = searchForPlus(label, "\">")
        i = string.find(label, "<")
        label = stripText(label[0:i])


    # Find Format
    i = string.find(source, ">Format:<")

    if i != -1:
        format = searchForPlus(source, ">Format:<")
        format = searchForPlus(format, "<td>")
        i = string.find(format, "<")
        format = stripText(format[0:i])


    # Find Date
    i = string.find(source, ">Released:<")

    if i != -1:
        date = searchForPlus(source, ">Released:<")
        date = searchForPlus(date, "<td>")
        i = string.find(date, "<")
        date = stripText(date[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, " ")

            if i != -1:
                date = stripText(date[i+1:])


    # Find Category
    i = string.find(source, ">Genre:<")

    if i != -1:
        category = searchForPlus(source, ">Genre:<")
        category = searchForPlus(category, "<td>")
        i = string.find(category, "<")
        category = stripText(category[0:i])
        category = string.replace(category, "\n", "")
        category = string.replace(category, "  ", " ")
        category = string.replace(category, "  ", " ")
        category = string.replace(category, "  ", " ")
        category = string.replace(category, "  ", " ")


    # Find Comments
    i = string.find(source, ">Notes:<")

    if i != -1:
        comments = searchForPlus(source, ">Notes:<")
        comments = searchForPlus(comments, "<td>")
        i = string.find(comments, "</td>")
        comments = stripText(comments[0:i])
        comments = string.replace(comments, "\n", "")
        comments = string.replace(comments, "<br>", "\n")


    # Find Tracks
    i = string.find(source, ">Tracklisting:<")

    if i != -1:
        source = searchForPlus(source, ">Tracklisting:<")
        i = string.find(source, "</table>")
        disks = stripText(source[0:i])

        if string.find(disks, ">Disc: ") == -1:
            disks = ">Disc: 1<" + disks

        trackList = []
        artistList = []
        timeList = []
        diskCount = 0

        while (searchFor(disks, ">Disc: ") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, ">Disc: ")
            i = string.find(disks, "<")
            diskid = "%02d" % stripText(disks[0:i])
            disks = searchForPlus(disks, "<table ")

            i = string.find(disks, "</table>")
            tracks = stripText(disks[0:i])
            trackIndex = 1

            while (searchFor(tracks, "<td nowrap") != None):
                tracks = searchForPlus(tracks, "<td nowrap")
                tartist = searchForPlus(tracks, "<td")
                i = string.find(tartist, "</td>")
                tartist = stripText(tartist[0:i])

                i = string.find(tartist, "\">")

                if i != -1:
                    tartist = searchForPlus(tartist, "\">")
                    i = string.find(tartist, "<")
                    tartist = stripText(tartist[0:i])
                else:
                    tartist = ""
                    
                
                tracks = searchForPlus(tracks, "<td")
                tracks = searchForPlus(tracks, "</td>")
                tracks = searchForPlus(tracks, "<td>")
                i = string.find(tracks, "<")
                trackid = "%02d" % trackIndex
                track = stripText(tracks[0:i])
                time = ""

                i = string.rfind(track, "(")
                
                if i != -1:
                    time = stripText(track[i+1:])
                    j = string.find(time, "(")
                    time = stripText(time[0:j])

                    j = string.find(time, ":")

                    if j != -1:
                        track = stripText(track[0:i])
                    else:
                        time = ""
                        

                trackList.append(diskid + "-" + trackid + "-" + track)

                if tartist != "":
                    artistList.append(diskid + "-" + trackid + "-" + tartist)
                else:
                    artistList.append(diskid + "-" + trackid + "-")

                if time != "":
                    timeList.append(diskid + "-" + trackid + "-" + time)
                else:
                    timeList.append(diskid + "-" + trackid + "-")

                trackIndex = trackIndex + 1
                tracks = tracks[i+1:]

        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)
        timeList.sort()
        trackTimes = array(timeList, String)




    # Find user rating
    i = string.find(source, ">Average Customer Review:<")

    if i != -1:
        temp = searchForPlus(source, ">Average Customer Review:<")
        temp = searchForPlus(temp, "<img src=\"")
        i = string.find(temp, "\"")
        temp = stripText(temp[0:i])
        i = string.rfind(temp, "/")

        if i != -1:
            temp = stripText(temp[i+1:])

        i = string.find(temp, ".")

        if i != -1:
            temp = stripText(temp[0:i])

        if temp.startswith("stars-") == 1:
            temp = searchForPlus(temp, "stars-")

        temp = string.replace(temp, "-", ".")

        if temp != "":
            rating = temp + " Stars"






try:
    extract()
finally:
    if os.path.exists("scrapers/awuserexit.py"):
        execfile("scrapers/awuserexit.py") in globals()
