# CDDB scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripHTML
from    scrapers.scrapers import convertArtist
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    sound               = "Stereo"
    format              = "CD"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    artistLF            = ""

    switchArtist        = "N"
    buyerwaiting        = "N"
    available           = "Y"


    # Find Image
    i = string.find(source, "class=\"album-image\">")

    if i != -1:
        source = searchForPlus(source, "class=\"album-image\">")
        source = searchForPlus(source, "<img src=\"")
        i = string.find(source, "\"")
        image = "http://www.gracenote.com" + stripHTML(source[0:i])

        i = string.find(image, "default_cover")

        if i != -1:
            image = ""


    # Find Title
    i = string.find(source, "<strong>Album</strong>")

    if (i != -1):
        source = searchForPlus(source, "<strong>Album</strong>")
        source = searchForPlus(source, " > ")
        i = string.find(source, "<")
        title = stripHTML(source[0:i])

        title = string.replace(title, "&#034;", "\"")
        title = string.replace(title, "&#038;", "&")


    # Find Artist
    i = string.find(source, "<strong>Artist</strong>")

    if (i != -1):
        source = searchForPlus(source, "<strong>Artist</strong>")
        source = searchForPlus(source, " > ")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        artist = stripHTML(source[0:i])

        artist = string.replace(artist, "&#034;", "\"")
        artist = string.replace(artist, "&#038;", "&")
        artist = string.replace(artist, "é", "e")
        artist = convertArtist(artist)


    # Find Copyright date
    i = string.find(source, "<strong>Year of Release</strong>")

    if (i != -1):
        source = searchForPlus(source, "<strong>Year of Release</strong>")
        source = searchForPlus(source, " > ")
        i = string.find(source, "<")
        copyDate = stripHTML(source[0:i])


    # Find Label
    i = string.find(source, "<strong>Label</strong>")

    if (i != -1):
        source = searchForPlus(source, "<strong>Label</strong>")
        source = searchForPlus(source, " > ")
        i = string.find(source, "<")
        label = stripHTML(source[0:i])

        label = string.replace(label, "&#034;", "\"")
        label = string.replace(label, "&#038;", "&")


    # Find Tracks
    # No multi disk sets, CDDB lists CDs separately
    i = string.find(source, "<strong>Tracks</strong>")
    diskCount = 1
    trackCount = 0

    if (i != -1):
        source = searchForPlus(source, "<strong>Tracks</strong>")
        source = searchForPlus(source, "<ol>")
        i = string.find(source, "</ol>")
        tracks = stripHTML(source[0:i])
        trackList = []
        artistList = []

        while (searchFor(tracks, "<li>") != None):
            trackCount = trackCount + 1
            tracks = searchForPlus(tracks, "<li>")
            tracks = searchForPlus(tracks, ".")
            i = string.find(tracks, "<")
            track = stripText(tracks[0:i])
            diskid = "%02d" % diskCount
            trackNum = "%02d" % trackCount

            track = string.replace(track, "&#038;", "&")
            track = string.replace(track, "é", "")
            track = string.replace(track, "ó", "")
            track = string.replace(track, "á", "")
            track = string.replace(track, "í", "")

            i = string.find(track, " -- ")

            if i == -1:
                i = string.find(track, " - ")

            trackArtist = ""

            if i != -1:
                trackArtist = stripText(track[i+3:])
                track = stripText(track[0:i])

                if trackArtist[0:7] == "<a href":
                    trackArtist = searchForPlus(trackArtist, ">")
                    i = string.find(trackArtist, "<")
                    trackArtist = stripText(trackArtist[0:i])

            trackList.append(diskid + "-" + trackNum + "-" + track)

            if trackArtist != "":
                trackArtist = convertArtist(trackArtist)
                artistList.append(diskid + "-" + trackNum + "-" + trackArtist)
            else:
                artistList.append(diskid + "-" + trackNum + "-")

        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)



try:
    extract()
finally:
    if os.path.exists("scrapers/awuserexit.py"):
        execfile("scrapers/awuserexit.py") in globals()
