# CD Baby music scrpaer
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import convertArtist
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    sound               = "Stereo"
    format              = "CD"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    artistLF            = ""


    # Find Image
    i = string.find(source, "\"albumart\"")

    if i != -1:
        image = source[i-150:]
        image = searchForPlus(image, " src=\"")
        i = string.find(image, "\"")
        image = stripText(image[0:i])

        i = string.find(image, "music-no-image")

        if i != -1:
            image = ""


    # Find Artist
    i = string.find(source, "id=\"albuminfo\"")

    if i != -1:
        source = searchForPlus(source, "id=\"albuminfo\"")
        source = searchForPlus(source, "<h1>")
        i = string.find(source, "<")
        artist = stripText(source[0:i])
        artist = convertArtist(artist)

        # Find Title
        source = searchForPlus(source, "<h2>")
        i = string.find(source, "<")
        title = stripText(source[0:i])


    # Find Copyright date/UPC
    
    i = string.find(source, "id=\"infoline\"")

    if i != -1:
        source = stripText(searchForPlus(source, "id=\"infoline\""))
        source = stripText(searchForPlus(source, ">"))
        i = string.find(source, "<")
        info = stripText(source[0:i])
        i = string.find(info, "")

        if i != -1:
            info = stripText(searchForPlus(info, ""))
            i = string.find(info, " ")
            copyDate = stripText(info[0:i])

        i = string.rfind(info, "(")

        if i != -1:
            info = stripText(info[i+1:])
            i = string.find(info, ")")
            upc = stripText(info[0:i])


    # Find List Price
    i = string.find(source, ">CD List price:")

    if i != -1:
        source = searchForPlus(source, ">CD List price:")
        source = searchFor(source, "$")
        i = string.find(source, "<")
        listprice = stripText(source[0:i])


    # Find Value
    i = string.find(source, ">CD price:")

    if i != -1:
        source = searchForPlus(source, ">CD price:")
        source = searchFor(source, "$")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find Tracks
    i = string.find(source, "\"PLAY ALL SONGS")

    if i != -1:
        source = searchForPlus(source, "\"PLAY ALL SONGS")
        source = searchFor(source, "<dd>")
        i = string.find(source, "</div>")
        disks = stripText(source[0:i+6])

        if string.find(disks, ">Disc: ") == -1:
            disks = ">Disc: 1<" + disks

        trackList = []
        artistList = []
        diskCount = 0

        while (searchFor(disks, ">Disc: ") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, ">Disc: ")
            i = string.find(disks, "<")
            diskid = "%02d" % stripText(disks[0:i])

            i = string.find(disks, "</dl>")
            tracks = stripText(disks[0:i])
            trackIndex = 1

            while (searchFor(tracks, "<dd>") != None):
                tracks = searchForPlus(tracks, "<dd>")
                tracks = searchForPlus(tracks, " ")
                i = string.find(tracks, "</dd>")
                track = stripText(tracks[0:i])

                if track.startswith("<a href="):
                    track = searchForPlus(track, "\">")
                    i = string.find(track, "</a>")
                    track = stripText(track[0:i])

                trackid = "%02d" % trackIndex
                i = string.find(track, " - ")
                trackArtist = ""

                if (i != -1):
                    trackArtist = stripText(track[i+3:])
                    track = stripText(track[0:i])

                trackList.append(diskid + "-" + trackid + "-" + track)
                trackIndex = trackIndex + 1

                if trackArtist != "":
                    trackArtist = convertArtist(trackArtist)
                    artistList.append(diskid + "-" + trackid + "-" + trackArtist)
                else:
                    artistList.append(diskid + "-" + trackid + "-")


        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)


    # Find Artist website
    i = string.find(source, ">Check out the<")

    if i != -1:
        source = searchForPlus(source, ">Check out the<")
        source = searchForPlus(source, "href=\"")
        i = string.find(source, "\"")
        artistURL = stripText(source[0:i])


    # Find Comments
    i = string.find(source, "id=\"notes\"")

    if (i != -1):
        source = searchForPlus(source, "id=\"notes\"")
        source = searchForPlus(source, ">")
        i = string.find(source, "</div>")
        comments = source[0:i]

        comments = string.replace(comments, "\n ", "")
        comments = string.replace(comments, "\n", "")
        comments = string.replace(comments, "<br />", "\n")
        comments = string.replace(comments, "<h3>", "")
        comments = string.replace(comments, "</h3>", "\n\n")
        comments = string.replace(comments, "<p>", "")
        comments = string.replace(comments, "</p>", "")



try:
    extract()
finally:
    if os.path.exists("scrapers/awuserexit.py"):
        execfile("scrapers/awuserexit.py") in globals()
