# Christianbooks.com audio scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import convertArtist
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    sound               = "Stereo"
    format              = "CD"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    artistLF            = ""


    # Find Title
    source = searchForPlus(source, "class=\"mlarge\"")
    source = searchForPlus(source, "<b>")
    i = string.find(source, "<")
    title = stripText(source[0:i])
    i = string.rfind(title, ", ")

    if i != -1:
        format = stripText(title[i+1:])
        title = stripText(title[0:i])


    # Find Artist
    i = string.find(source, ">By:")

    if i != -1:
        source = searchForPlus(source, ">By:")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        artist = stripText(source[0:i])
        artist = convertArtist(artist)


    # Find Image
    i = string.find(source, "/product/")

    if i != -1 and i<600:
        source = stripText(source[i-50:])
        source = searchForPlus(source, " src=\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])

        i = string.find(image, "dvd-no-image.gif")

        if i != -1:
            image = ""


    # Find List Price
    listprice = ""
    i = string.find(source, ">Retail Price:")

    if (i != -1):
        source = searchForPlus(source, ">Retail Price:")
        source = searchFor(source, "$")
        i = string.find(source, "<")
        listprice = stripText(source[0:i])


    # Find Value
    i = string.find(source, ">CBD Price")

    if (i != -1):
        source = searchForPlus(source, ">CBD Price")
        source = searchFor(source, "$")
        i = string.find(source, "<")
        value = stripText(source[0:i])
    else:
        value = listprice


    # Find Tracks
    i = string.find(source, ">Song<")

    if i != -1:
        source = searchForPlus(source, ">Song<")
        i = string.find(source, "</TABLE></TD></TR></TABLE></CENTER>")
        disks = stripText(source[0:i])

        if string.find(disks, ">Disc: ") == -1:
            disks = ">Disc: 1<" + disks

        trackList = []
        artistList = []
        diskCount = 0

        while (searchFor(disks, ">Disc: ") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, ">Disc: ")
            i = string.find(disks, "<")
            diskid = "%02d" % stripText(disks[0:i])
            disks = searchForPlus(disks, "<")

            tracks = stripText(disks)
            trackIndex = 1

            while (searchFor(tracks, ".</B>") != None):
                trackid = "%02d" % trackIndex
                tracks = searchForPlus(tracks, ".</B>")
                i = string.find(tracks, "</TD>")
                track = stripText(tracks[0:i])

                i = string.find(track, "</A>")

                if i != -1:
                    track = stripText(track[0:i])

                trackArtist = searchForPlus(tracks, "<TD ")
                trackArtist = searchForPlus(trackArtist, ">")
                i = string.find(trackArtist, "</TD>")
                trackArtist = stripText(trackArtist[0:i])
                trackList.append(diskid + "-" + trackid + "-" + track)
                trackArtist = convertArtist(trackArtist)
                artistList.append(diskid + "-" + trackid + "-" + trackArtist)

                trackIndex = trackIndex + 1


        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)


    # Find Comments
    i = string.find(source, ">Description: <")

    if (i != -1):
        comments = ""
        source = searchForPlus(source, ">Description: <")
        source = stripText(searchForPlus(source, ">"))

        if source.startswith("<!--"):
            source = searchForPlus(source, "-->")
            
        i = string.find(source, "<br />")
        comments = stripText(source[0:i])
        comments = string.replace(comments, "<i>", "")
        comments = string.replace(comments, "</i>", "")
        comments = string.replace(comments, "<I>", "")
        comments = string.replace(comments, "</I>", "")
        comments = string.replace(comments, "<BR>  ", "\n")
        comments = string.replace(comments, "<BR> ", "\n")
        comments = string.replace(comments, "<BR>", "\n")



try:
    extract()
finally:
    if os.path.exists("scrapers/awuserexit.py"):
        execfile("scrapers/awuserexit.py") in globals()
