# BMG scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    sound               = "Stereo"
    format              = "CD"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    artistLF            = ""


    # Find Image
    i = string.find(source, "/images/minis/")

    if (i != -1):
        tempdata = source[i-50:]
        tempdata = searchForPlus(tempdata, "src=\"")
        i = string.find(tempdata, "\"")
        image = stripText(tempdata[0:i])


    # Find Artist
    source = searchForPlus(source, "/artist.jhtml")
    i = string.find(source, ">Various Artists<")

    if (i != -1):
        artist ="Various Artists"
    else:
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")

        if (i != -1):
            artist = stripText(source[0:i])


    # Find Title
    source = searchForPlus(source, "class=s40>")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Comments
    i = string.find(source, "valign=\"top\" class=s9>")

    if (i != -1):
        source = searchForPlus(source, "valign=\"top\" class=s9>")
        i = string.find(source, "<br>")
        comments = stripText(source[0:i])
        comments = string.replace(comments, "<i>", "")
        comments = string.replace(comments, "</i>", "")


    # Find UPC
    i = string.find(source, ">Selection #:")

    if i != -1:
        source = searchForPlus(source, ">Selection #:")
        i = string.find(source, "<")
        upc = stripText(source[0:i])


    # Find Date
    i = string.find(source, ">Release Date:")

    if (i != -1):
        source = searchForPlus(source, ">Release Date:")
        i = string.find(source, "<")
        date = stripText(source[0:i])


    # Find Label
    i = string.find(source, ">Label:")

    if i != -1:
        source = searchForPlus(source, ">Label:")
        i = string.find(source, "<")
        label = stripText(source[0:i])


    # Find Price
    i = string.find(source, "class=s35>")

    if i != -1:
        source = searchForPlus(source, "class=s35>")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find Tracks
    i = string.find(source, "soundstudio.gif")

    if i != -1:
        source = searchForPlus(source, "soundstudio.gif")
        source = searchForPlus(source, "<table")
        i = string.find(source, "/dl_player2.gif")
        disks = stripText(source[0:i])

        if string.find(disks, "> Disc ") == -1:
            disks = "> Disc 1: " + disks

        trackList = []
        diskCount = 0

        while (searchFor(disks, "> Disc ") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, "> Disc ")
            i = string.find(disks, ":")
            diskid = "%02d" % stripText(disks[0:i])
            tracks = disks
            trackIndex = 1

            while (searchFor(tracks, "width=\"193\"") != None):
                tracks = searchForPlus(tracks, "width=\"193\"")
                tracks = searchForPlus(tracks, "width=190")
                tracks = searchForPlus(tracks, ">")
                i = string.find(tracks, "<")
                track = stripText(tracks[0:i])

                trackid = "%02d" % trackIndex

                trackList.append(diskid + "-" + trackid + "-" + track)
                trackIndex = trackIndex + 1

        trackList.sort()
        trackTitles = array(trackList, String)



try:
    extract()
finally:
    if os.path.exists("scrapers/awuserexit.py"):
        execfile("scrapers/awuserexit.py") in globals()
