# Barpoint scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import convertArtist
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    sound               = "Stereo"
    format              = "CD"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    artistLF            = ""


    i = string.find(source, "trackListing.jsp")

    if i != -1:
        tracksource = source[i-100:]
        tracksource = searchForPlus(tracksource, "<A href=\"")
        i = string.find(tracksource, "\">")
        url = stripText(tracksource[0:i])
        http = HTTPConnection()
        http.resetReferer();
        http.blockForLoad();
        tracksource = http.getContents(url)


    # Find optional fields, pricing info etc.
    marketinfo = source

    # Find List price
    i = string.find(marketinfo, "List Price:")

    if (i != -1):
        listprice = searchForPlus(marketinfo, "List Price:")
        listprice = searchFor(listprice, "$")
        i = string.find(listprice, "<")
        listprice = stripText(listprice[0:i])


    # Main extraction
    # Find Image
    i = string.find(source, "***THE PRODUCT IMAGE IS DISPLAYED HERE ***")

    if i != -1:
        source = searchForPlus(source, "***THE PRODUCT IMAGE IS DISPLAYED HERE ***")
        source = searchForPlus(source, "<img ")
        source = searchForPlus(source, "src='")
        i = string.find(source, "'")
        image = stripText(source[0:i])

        if string.find(source, "Music_default") != -1:
            image = ""

        if string.find(source, "Movies_default") != -1:
            image = ""


    # Find Price
    i = string.find(source, ">Price:")

    if i != -1:
        source = searchForPlus(source, ">Price:")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        value = stripText(source[0:i])
    else:
        i = string.find(source, ">Price Range:<")

        if i != -1:
            source = searchForPlus(source, ">Price Range:<")
            source = searchForPlus(source, "\">")
            i = string.find(source, " - ")
            value = stripText(source[0:i])
        else:
            i = string.find(source, ">List:<")

            if i != -1:
                source = searchForPlus(source, ">List:<")
                source = searchForPlus(source, "\">")
                i = string.find(source, "<")
                value = stripText(source[0:i])

            i = string.find(source, ">List Price:<")

            if i != -1:
                source = searchForPlus(source, ">List Price:<")
                source = searchForPlus(source, "\">")
                i = string.find(source, "<")
                value = stripText(source[0:i])




    # Find Title
    i = string.find(source, "***THE PRODUCT DESCRIPTION IS DISPLAYED HERE ***")

    if i != -1:
        source = searchForPlus(source, "***THE PRODUCT DESCRIPTION IS DISPLAYED HERE ***")
        source = searchForPlus(source, "<SPAN")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")

        if i != -1:
            title = stripText(source[0:i])


    # Find Artist
    i = string.find(source, ">By</b>")

    if i != -1:
        source = searchForPlus(source, ">By</b>")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")

        if i != -1:
            artist = stripText(source[0:i])
            artist = convertArtist(artist)


    # Find Format
    i = string.find(source, ">Format<")

    if i != -1:
        source = searchForPlus(source, ">Format<")
        source = searchForPlus(source, ">")
        source = searchForPlus(source, ":")
        i = string.find(source, "<")

        if i != -1:
            format = stripText(source[0:i])


    # Find Label
    source = searchForPlus(source, "<BR>")
    i = string.find(source, "|")

    if i != -1:
        label = stripText(source[0:i])


    # Find Copyright date
    source = searchForPlus(source, "|")
    i = string.find(source, "<")
    copyDate = stripText(source[0:i])


    # Find Comments
    i = string.find(source, "<span class='body'>")

    if i != -1:
        source = searchForPlus(source, "<span class='body'>")
        source = searchForPlus(source, "<br><br>")
        i = string.find(source, "\n")
        comments = stripText(source[0:i])

        comments = string.replace(comments, "<br>", "\n")
        comments = string.replace(comments, "<br/>", "\n")


    # Find Tracks
    if tracksource == None:
        return

    i = string.find(tracksource, "<B>Tracks</B>")

    if i != -1:
        tracksource = searchForPlus(tracksource, "<B>Tracks</B>")
        tracksource = searchForPlus(tracksource, "<OL>")
        i = string.find(tracksource, "</OL>")
        disks = stripText(tracksource[0:i])

        if string.find(disks, "<LI>DISC ") == -1:
            disks = "<LI>DISC 1:<" + disks

        trackList = []
        artistList = []
        diskCount = 0

        while (searchFor(disks, "<LI>DISC ") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, "<LI>DISC ")
            i = string.find(disks, ":<")
            diskid = "%02d" % stripText(disks[0:i])

            i = string.find(disks, "<LI>DISC ")
            tracks = stripText(disks[0:i])
            trackIndex = 1

            while (searchFor(tracks, "<LI>") != None):
                tracks = searchForPlus(tracks, "<LI>")

                if (tracks[0:1] == "<"):
                    i = string.find(tracks, "<A HREF=")

                    if (i == 0):
                      i = string.find(tracks, ">")
                      tracks = stripText(tracks[i+1:])

                i = string.find(tracks, "<")

                if (i != -1):
                    trackid = "%02d" % trackIndex
                    track = stripText(tracks[0:i])

                    i = string.find(track, " - ")
                    trackArtist = ""

                    if (i != -1):
                        if track[i+3:i+4] != "(":
                            trackArtist = stripText(track[i+3:])
                            track = stripText(track[0:i])

                    trackList.append(diskid + "-" + trackid + "-" + track)
                    trackIndex = trackIndex + 1
                    i = string.find(tracks, "<")

                    if trackArtist != "":
                        trackArtist = convertArtist(trackArtist)
                        artistList.append(diskid + "-" + trackid + "-" + trackArtist)
                    else:
                        artistList.append(diskid + "-" + trackid + "-")

                tracks = tracks[i+1:]

        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)


try:
    extract()
finally:
    if os.path.exists("scrapers/awuserexit.py"):
        execfile("scrapers/awuserexit.py") in globals()
