# Amazon UK music scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import convertArtist
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    sound               = "Stereo"
    format              = "Audio CD"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    artistLF            = ""


    i = string.find(source, "The item you indicated is ineligible for Amazon Marketplace selling.")

    if i != -1:
        return


    i = string.find(source, "sai-identify")

    if i != -1:
        source = searchForPlus(source, "sai-identify")
        i = string.find(source, "/ASIN/")
        source = source[i-50:]
        source = searchForPlus(source, "<a href=")
        i = string.find(source, ">")
        url = stripText(source[0:i])
        http = HTTPConnection()
        http.resetReferer();
        http.blockForLoad();
        source = http.getContents(url)


    # Alternate format?
    i = string.find(source, "class=\"sans\">")

    if i != -1:
        am2()
        return


    # Find marketplace pricing
    marketinfo = source
    i = string.find(marketinfo, ">From Our Marketplace Sellers:<")

    if (i != -1):
        marketinfo = searchForPlus(marketinfo, ">From Our Marketplace Sellers:<")


    # Find New
    i = string.find(marketinfo, "sdp_new")

    if (i != -1):
        usedinfo = searchForPlus(marketinfo, "sdp_new")
        usedinfo = searchForPlus(usedinfo, ">")
        i = string.find(usedinfo, "<br>")
        usedinfo = stripText(usedinfo[0:i])

        i = string.find(usedinfo, "new<")

        if (i != -1):
            i = string.find(usedinfo, "new<")
            newcount = stripText(usedinfo[0:i])

            usedinfo = searchForPlus(usedinfo, "new<")
            usedinfo = searchFor(usedinfo, ">")
            usedinfo = searchForPlus(usedinfo, ">")
            i = string.find(usedinfo, "<")
            newprice = stripText(usedinfo[0:i])


    # Find Collectible
    i = string.find(marketinfo, "sdp_coll")

    if (i != -1):
        usedinfo = searchForPlus(marketinfo, "sdp_coll")
        usedinfo = searchForPlus(usedinfo, ">")
        i = string.find(usedinfo, "<br>")
        usedinfo = stripText(usedinfo[0:i])

        i = string.find(usedinfo, "collectable<")

        if (i != -1):
            i = string.find(usedinfo, "collectable<")
            collectiblecount = stripText(usedinfo[0:i])

            usedinfo = searchForPlus(usedinfo, "collectable<")
            usedinfo = searchFor(usedinfo, ">")
            usedinfo = searchForPlus(usedinfo, ">")
            i = string.find(usedinfo, "<")
            collectibleprice = stripText(usedinfo[0:i])


    # Find Used
    i = string.find(marketinfo, "sdp_used")

    if (i != -1):
        usedinfo = searchForPlus(marketinfo, "sdp_used")
        usedinfo = searchForPlus(usedinfo, ">")
        i = string.find(usedinfo, "<br>")
        usedinfo = stripText(usedinfo[0:i])

        i = string.find(usedinfo, "used<")

        if (i != -1):
            i = string.find(usedinfo, "used<")
            usedcount = stripText(usedinfo[0:i])

            try:
                usedinfo = searchForPlus(usedinfo, "used<")
                usedinfo = searchFor(usedinfo, ">")
                usedinfo = searchForPlus(usedinfo, ">")
                i = string.find(usedinfo, "<")
                usedprice = stripText(usedinfo[0:i])
            except:
                usedprice = ""


    # Find Ranking
    salesrank = ""
    i = string.find(marketinfo, ">Amazon.co.uk Sales Rank:")

    if (i != -1):
        usedinfo = searchForPlus(marketinfo, ">Amazon.co.uk Sales Rank:")
        usedinfo = searchForPlus(usedinfo, ">")
        i = string.find(usedinfo, "<")
        salesrank = stripText(usedinfo[0:i])


    # Find Buyer Waiting
    i = string.find(marketinfo, "buyer waiting!")

    if (i != -1):
        buyerwaiting = "Y"



    # Find Title
    source = searchForPlus(source, "size=+1><b>")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Artist
    i = string.find(source, "artist=")

    if (i != -1):
        source = searchForPlus(source, "artist=")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        artist = stripText(source[0:i])
        artist = convertArtist(artist)


    # Find Image
    i = string.find(source, "images-eu.amazon.com")

    if (i != -1):
        image = source[i-50:]
        image = searchForPlus(image, " href=\"")
        j = string.find(image, "\"")
        image = stripText(image[0:j])
        image = string.replace(image, ".LZZZ", ".MZZZ")

        j = string.find(image, "ZZZ")

        if j == -1:
            image = source[i-50:]
            image = searchForPlus(image, " src=\"")
            j = string.find(image, "\"")
            image = stripText(image[0:j])
            image = string.replace(image, ".LZZZ", ".MZZZ")

            j = string.find(image, "ZZZ")

            if j == -1:
                image = ""


    # Find Price
    i = string.find(source, ">Our Price:")

    if (i != -1):
        source = searchForPlus(source, ">Our Price:")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        value = stripText(source[0:i])
    else:
        i = string.find(source, ">List Price:")

        if (i != -1):
            source = searchForPlus(source, ">List Price:")
            source = searchForPlus(source, ">")
            i = string.find(source, "<")
            value = stripText(source[0:i])

            i = string.find(value, ">")

            if (i != -1):
                value = stripText(source[i+1:])


    # Find Format
    source = searchForPlus(source, "<br clear=all>")
    source = searchForPlus(source, "size=\"-1\"")
    i = string.find(source, "<B>")

    if i != -1:
        source = searchForPlus(source, "<B>")
        i = string.find(source, "<")
        format = stripText(source[0:i])


        # Find Date
        i = string.find(source, "(")
        
        if i <= 100:
            source = searchForPlus(source, "(")
            i = string.find(source, ")")
            date = stripText(source[0:i])

            if fullDateFormat == "false":
                i = string.rfind(date, " ")

                if i != -1:
                    date = stripText(date[i+1:])


    # Find Label
    i = string.find(source, ">Label:<")

    if i != -1:
        source = searchForPlus(source, ">Label:<")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        label = stripText(source[0:i])


    # Find Date (2nd attempt)
    i = string.find(source, ">Released:")

    if i != -1:
        source = searchForPlus(source, ">Released:")
        i = string.find(source, "<")
        date = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, " ")

            if i != -1:
                date = stripText(date[i+1:])


    # Find Tracks
    i = string.find(source, ">Track Listings<")

    if i != -1:
        source = searchForPlus(source, ">Track Listings<")
        i = string.find(source, "<hr no")
        disks = stripText(source[0:i])

        if string.find(disks, ">Disc: ") == -1:
            disks = ">Disc: 1<" + disks

        trackList = []
        artistList = []
        diskCount = 0

        while (searchFor(disks, ">Disc: ") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, ">Disc: ")
            i = string.find(disks, "<")
            diskid = "%02d" % stripText(disks[0:i])

            i = string.find(disks, "<table ")

            if i != -1:
                disks = searchForPlus(disks, "<table ")
                i = string.find(disks, "</table>")
                tracks = stripText(disks[0:i])
            else:
                tracks = disks

            trackIndex = 1

            while (searchFor(tracks, ". ") != None):
                tracks = searchForPlus(tracks, ". ")

                if (tracks[0:1] == "<"):
                    i = string.find(tracks, "<A HREF=")

                    if (i == 0):
                      i = string.find(tracks, ">")
                      tracks = stripText(tracks[i+1:])

                i = string.find(tracks, "<")

                if (i != -1):
                    trackid = "%02d" % trackIndex
                    track = stripText(tracks[0:i])
                    i = string.find(track, ">")

                    if (i != -1):
                        track = stripText(track[i+1:])

                    i = string.find(track, " - ")
                    trackArtist = ""

                    if (i != -1):
                        trackArtist = stripText(track[i+3:])
                        track = stripText(track[0:i])

                    trackList.append(diskid + "-" + trackid + "-" + track)
                    trackIndex = trackIndex + 1
                    i = string.find(tracks, "<")

                    if trackArtist != "":
                        trackArtist = convertArtist(trackArtist)
                        artistList.append(diskid + "-" + trackid + "-" + trackArtist)
                    else:
                        artistList.append(diskid + "-" + trackid + "-")

                tracks = tracks[i+1:]

        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)


    i = string.find(source, ">Listen to Samples<")

    if i != -1:
        source = searchForPlus(source, ">Listen to Samples<")
        source = searchForPlus(source, "<p")
        i = string.find(source, "<hr no")
        disks = stripText(source[0:i])

        if string.find(disks, ">Disc: ") == -1:
            disks = ">Disc: 1<" + disks

        trackList = []
        artistList = []
        diskCount = 0

        while (searchFor(disks, ">Disc: ") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, ">Disc: ")
            i = string.find(disks, "<")
            diskid = "%02d" % stripText(disks[0:i])
            disks = searchForPlus(disks, "<table ")

            i = string.find(disks, "</table>")
            tracks = stripText(disks[0:i])
            trackIndex = 1

            while (searchFor(tracks, ". ") != None):
                tracks = searchForPlus(tracks, ". ")

                if (tracks[0:1] == "<"):
                    i = string.find(tracks, "<A HREF=")

                    if (i == 0):
                      i = string.find(tracks, ">")
                      tracks = stripText(tracks[i+1:])

                i = string.find(tracks, "<")

                if (i != -1):
                    trackid = "%02d" % trackIndex
                    track = stripText(tracks[0:i])
                    i = string.find(track, ">")

                    if (i != -1):
                        track = stripText(track[i+1:])

                    i = string.find(track, " - ")
                    trackArtist = ""

                    if (i != -1):
                        trackArtist = stripText(track[i+3:])
                        track = stripText(track[0:i])

                    trackList.append(diskid + "-" + trackid + "-" + track)
                    trackIndex = trackIndex + 1
                    i = string.find(tracks, "<")

                    if trackArtist != "":
                        trackArtist = convertArtist(trackArtist)
                        artistList.append(diskid + "-" + trackid + "-" + trackArtist)
                    else:
                        artistList.append(diskid + "-" + trackid + "-")

                tracks = tracks[i+1:]

        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)


    # Find Comments
    i = string.find(source, ">Reviews<")

    if (i != -1):
        comments = ""
        source = searchForPlus(source, ">Reviews<")
        source = searchForPlus(source, "<br> ")
        i = string.find(source, "<p align=right>")
        tempcomments = source[0:i]

        i = string.find(tempcomments, "</form>")

        if (i != -1):
            tempcomments = tempcomments[0:i]

        i = string.find(tempcomments, "<hr noshade")

        if (i != -1):
            tempcomments = tempcomments[0:i]

        i = string.find(tempcomments, "<font")

        if (i != -1):
            tempcomments = searchForPlus(tempcomments, "<font")

        i = string.find(tempcomments, "<span")

        if (i != -1):
            tempcomments = searchForPlus(tempcomments, "<span")

        tempcomments = searchForPlus(tempcomments, ">")
        i = string.find(tempcomments, "\n")
        tempcomment = stripText(tempcomments[0:i])
        i = string.find(tempcomment, "<span")

        if (i != -1):
            j = string.find(tempcomment[i:], ">")
            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        i = string.find(tempcomment, "... <")

        if (i != -1):
            tempcomment = stripText(tempcomment[0:i+3])

        while (searchFor(tempcomment, "<p> ") != None):
            i = string.find(tempcomment, "<p> ")
            tempcomment = tempcomment[0:i+3] + tempcomment[i+4:]

        while (searchFor(tempcomment, "<P> ") != None):
            i = string.find(tempcomment, "<P> ")
            tempcomment = tempcomment[0:i+3] + tempcomment[i+4:]

        while (searchFor(tempcomment, "<br> ") != None):
            i = string.find(tempcomment, "<br> ")
            tempcomment = tempcomment[0:i+4] + tempcomment[i+5:]

        while (searchFor(tempcomment, "<BR> ") != None):
            i = string.find(tempcomment, "<BR> ")
            tempcomment = tempcomment[0:i+4] + tempcomment[i+5:]

        tempcomment = string.replace(tempcomment, "</a>", "")
        tempcomment = string.replace(tempcomment, "</A>", "")
        tempcomment = string.replace(tempcomment, "<p>", "\n\n")
        tempcomment = string.replace(tempcomment, "<P>", "\n\n")
        tempcomment = string.replace(tempcomment, "<BR>", "\n")
        tempcomment = string.replace(tempcomment, "<br>", "\n")
        tempcomment = string.replace(tempcomment, "<i>", "")
        tempcomment = string.replace(tempcomment, "</i>", "")
        tempcomment = string.replace(tempcomment, "<I>", "")
        tempcomment = string.replace(tempcomment, "</I>", "")
        tempcomment = string.replace(tempcomment, "<b>", "")
        tempcomment = string.replace(tempcomment, "</b>", "")
        tempcomment = string.replace(tempcomment, "</font>", "")
        tempcomment = string.replace(tempcomment, "</span>", "")
        tempcomment = string.replace(tempcomment, "&copy;", "")
        tempcomment = string.replace(tempcomment, "&#145;", "'")
        tempcomment = string.replace(tempcomment, "&#169;", "")
        tempcomment = string.replace(tempcomment, "&#8217;", "'")
        tempcomment = string.replace(tempcomment, "&quot;", "\"")
        tempcomment = string.replace(tempcomment, "&#8211;", "-")
        tempcomment = string.replace(tempcomment, "&#146;", "\'")
        tempcomment = string.replace(tempcomment, "<blockquote>", "")
        tempcomment = string.replace(tempcomment, "</blockquote>", "")

        while (searchFor(tempcomment, "<a ") != None):
            i = string.find(tempcomment, "<a ")
            j = string.find(tempcomment[i:], ">")

            if j == -1:
                j = 2

            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        while (searchFor(tempcomment, "<A ") != None):
            i = string.find(tempcomment, "<A ")
            j = string.find(tempcomment[i:], ">")
            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        while (searchFor(tempcomment, "<img src") != None):
            i = string.find(tempcomment, "<img src")
            j = string.find(tempcomment[i:], ">")
            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        while (searchFor(tempcomment, "<span") != None):
            i = string.find(tempcomment, "<span")
            j = string.find(tempcomment[i:], ">")
            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        comments = tempcomment





def extractCategory():
    global title,author,format,bookclub,first,signed,read,date,publisher,place,isbn
    global value,category,copies,condition,rating,comments,source,image
    global fullDateFormat

    # Find category
    i = string.find(source, "<b>Browse for")

    if (i != -1):
        source = searchForPlus(source, "<b>Browse for")
    else:
        i = string.find(source, "<b> Browse for")

        if (i != -1):
            source = searchForPlus(source, "<b> Browse for")

    if (i != -1):
        source = searchForPlus(source, "<br>")
        i = string.find(source, "<br>")
        tempCatg = source[0:i]

    if (i != -1):
        category = ""

        while (searchFor(tempCatg, "href=") != None):
            tempCatg = searchForPlus(tempCatg, "href=")
            tempCatg = searchForPlus(tempCatg, ">")
            i = string.find(tempCatg, "<")

            if (category != ""):
                category = category + " : "

            category = category + stripText(tempCatg[0:i])
            tempCatg = tempCatg[i:]




def am2():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source


    print "Alternate Amazon format"

    # Find marketplace pricing
    marketinfo = source
    i = string.find(marketinfo, ">From Our Marketplace Sellers:<")

    if (i != -1):
        marketinfo = searchForPlus(marketinfo, ">From Our Marketplace Sellers:<")


    # Find List price
    i = string.find(marketinfo, "List Price:")

    if (i != -1):
        listprice = searchForPlus(marketinfo, "List Price:")
        listprice = searchForPlus(listprice, "class=\"listprice\"")
        listprice = searchForPlus(listprice, ">")
        i = string.find(listprice, "<")
        listprice = stripText(listprice[0:i])
    else:
        i = string.find(marketinfo, "RRP:")

        if i != -1:
            listprice = searchForPlus(marketinfo, "RRP:")
            listprice = searchForPlus(listprice, "class=\"listprice\"")
            listprice = searchForPlus(listprice, ">")
            i = string.find(listprice, "<")
            listprice = stripText(listprice[0:i])


    # Find New/Used together
    i = string.find(marketinfo, "/offer-listing/")

    if i != -1:
        usedinfo = stripText(marketinfo[i:])
        usedinfo = searchForPlus(usedinfo, ">")
        i = string.find(usedinfo, "</div>")
        usedinfo = stripText(usedinfo[0:i])

        i = string.find(usedinfo, "used &amp; new")

        if i != -1:
            i = string.find(usedinfo, " ")
            usedcount = stripText(usedinfo[0:i])
            newcount = stripText(usedinfo[0:i])
            usedprice = searchForPlus(usedinfo, "used &amp; new")
            usedprice = searchFor(usedprice, ">")
            usedprice = searchForPlus(usedprice, ">")
            i = string.find(usedprice, "<")
            usedprice = stripText(usedprice[0:i])
            newprice = stripText(usedprice[0:i])

        i = string.find(usedinfo, "used & new")

        if i != -1:
            i = string.find(usedinfo, " ")
            usedcount = stripText(usedinfo[0:i])
            newcount = stripText(usedinfo[0:i])
            usedprice = searchForPlus(usedinfo, "used & new")
            usedprice = searchForPlus(usedprice, "class=\"price\"")
            usedprice = searchForPlus(usedprice, ">")
            i = string.find(usedprice, "<")
            usedprice = stripText(usedprice[0:i])
            newprice = stripText(usedprice[0:i])

        i = string.find(usedinfo, ">See all used<")

        if (i != -1):
            usedprice = searchForPlus(usedinfo, ">See all used<")
            usedprice = searchFor(usedprice, ">")
            usedprice = searchForPlus(usedprice, ">")
            i = string.find(usedprice, "<")
            usedprice = stripText(usedprice[0:i])

        i = string.find(usedinfo, ">See all new<")

        if (i != -1):
            newprice = searchForPlus(usedinfo, ">See all new<")
            newprice = searchFor(newprice, ">")
            newprice = searchForPlus(newprice, ">")
            i = string.find(newprice, "<")
            newprice = stripText(newprice[0:i])

        i = string.find(usedinfo, ">See all collectible<")

        if (i != -1):
            collectibleprice = searchForPlus(usedinfo, ">See all collectible<")
            collectibleprice = searchFor(collectibleprice, ">")
            collectibleprice = searchForPlus(collectibleprice, ">")
            i = string.find(collectibleprice, "<")
            collectibleprice = stripText(collectibleprice[0:i])


    # Find Ranking
    salesrank = ""
    i = string.find(marketinfo, ">Amazon.co.uk Sales Rank:")

    if (i != -1):
        usedinfo = searchForPlus(marketinfo, ">Amazon.co.uk Sales Rank:")
        usedinfo = searchForPlus(usedinfo, ">")
        i = string.find(usedinfo, "<")
        salesrank = stripText(usedinfo[0:i])


    # Find Buyer Waiting
    i = string.find(marketinfo, "buyer waiting!")

    if (i != -1):
        buyerwaiting = "Y"


    # Find Image (first try)
    i = string.find(source, "registerImage(\"original_image\"")

    if i != -1:
        source = searchForPlus(source, "registerImage(\"original_image\"")
        source = searchForPlus(source, "\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])

        i = string.find(image, "no-image-")

        if i != -1:
            image = ""

        image = string.replace(image, "_SCLZZ", "_SCMZZ")
        image = string.replace(image, "_AA400_", "_AA_")
        #image = string.replace(image, "_AA240_", "_AA_")
        image = string.replace(image, "_AA140_", "_AA_")
        image = string.replace(image, "_AA280_", "_AA_")

        i = string.find(image, ",")

        if i != -1:
            j = string.find(image[i:], "_AA")
            image = stripText(image[0:i] + image[i+j:])


    # Find Title
    source = searchForPlus(source, "<b class=\"sans\">")
    source = searchForPlus(source, "\"btAsinTitle\"")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Artist
    tag = "&field-artist"
    i = string.find(source, tag)

    if i == -1:
        tag = "&field-keywords="
        i = string.find(source, tag)

    if i != -1:
        source = searchForPlus(source, tag)
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        artist = stripText(source[0:i])
        artist = convertArtist(artist)


    # Find Image
    if image == "":
        tag = "images.amazon.com"
        i = string.find(source, tag)

        if i == -1 or i > 3000:
            tag = "images-amazon.com/"
            i = string.find(source, tag)

        if i != -1 and i < 3000:
            image = source[i-50:]
            image = searchForPlus(image, " src=\"")
            i = string.find(image, "\"")
            image = stripText(image[0:i])
            image = string.replace(image, ".LZZZ", ".MZZZ")
            image = string.replace(image, ".TZZZ", ".MZZZ")

            i = string.find(image, "_PE")

            if i != -1:
                j = string.find(image[i+1:], "_")
                image = stripText(image[0:i] + image[i+j+1:])

            i = string.find(image, "ZZZ")

            if i == -1:
                image = ""


    # Find Price
    tag = ">Our Price:<"
    i = string.find(source, tag)

    if i == -1:
        tag = ">Price:<"
        i = string.find(source, tag)

    if i == -1:
        tag = "List Price:<"
        i = string.find(source, tag)

    if i == -1:
        tag = ">RRP:<"
        i = string.find(source, tag)

    if i != -1:
        temp = searchForPlus(source, tag)
        temp = searchForPlus(temp, "class=\"price\"")
        temp = searchForPlus(temp, ">")
        i = string.find(temp, "<")
        value = stripText(temp[0:i])
    else:
        value = usedprice


    # Find Categories
    category = ""
    i = string.find(source, ">Browse similar items in:<")

    if i != -1:
        str = searchForPlus(source, ">Browse similar items in:<")
        str = searchForPlus(str, "<li>")
        i = string.find(str, "</ul>")
        categories = stripText(str[0:i])
        foundstyle = 0

        while (searchFor(categories, "href=") != None):
            categories = searchForPlus(categories, "href=")
            categories = searchForPlus(categories, ">")
            i = string.find(categories, "<")
            temp = stripText(categories[0:i])

            if foundstyle == 1:
                category = temp
                break

            if temp == "Styles":
                foundstyle = 1
                continue;

            if temp == "By Genre":
                foundstyle = 1
                continue;


    # Find user rating
    i = string.find(source, ">Avg. Customer Review:<")

    if i == -1:
        i = string.find(source, ">Average Customer Review:<")

    if i != -1:
        temp = stripText(source[i:])
        i = string.find(temp, "<p>")
        temp = stripText(temp[0:i])

        i = string.find(temp, "<img src=\"")

        if i != -1:
            temp = searchForPlus(temp, "<img src=\"")
            i = string.find(temp, "\"")
            temp = stripText(temp[0:i])
            i = string.rfind(temp, "/")

            if i != -1:
                temp = stripText(temp[i+1:])

            i = string.find(temp, ".")

            if i != -1:
                temp = stripText(temp[0:i])

            if temp.startswith("stars-") == 1:
                temp = searchForPlus(temp, "stars-")

            temp = string.replace(temp, "-", ".")

            if temp != "":
                rating = temp + " Stars"


    # Find Format
    source = searchForPlus(source, ">Product details<")
    i = string.find(source, "</ul>")
    details = stripText(source[0:i])

    while (searchFor(details, "<li>") != None):
        details = searchForPlus(details, "<li>")
        i = string.find(details, "</li>")
        temp = stripText(details[0:i])

        if temp.endswith(")") == 1:
            i = string.find(temp, "http:")

            if i != -1:
                continue

            i = string.find(temp, "<b>")

            if i != -1:
                temp = searchForPlus(temp, "<b>")
                i = string.find(temp, "<")
                format = stripText(temp[0:i])


                # Find Date
                i = string.find(temp, "(")
        
                if i <= 100:
                    temp = searchForPlus(temp, "(")
                    i = string.find(temp, ")")
                    date = stripText(temp[0:i])

                    if fullDateFormat == "false":
                        i = string.rfind(date, " ")

                        if i != -1:
                            date = stripText(date[i+1:])

            break


    # Find Composer
    i = string.find(source, ">Composer:<")

    if i != -1:
        composer = searchForPlus(source, ">Composer:<")
        composer = searchForPlus(composer, "\">")
        i = string.find(composer, "<")
        composer = stripText(composer[0:i])

        i = string.rfind(composer, " ")

        if i != -1:
            composer = stripText(composer[i+1:]) + ", " + stripText(composer[0:i])


    # Find Label
    i = string.find(source, ">Label:<")

    if i != -1:
        label = searchForPlus(source, ">Label:<")
        label = searchForPlus(label, ">")
        i = string.find(label, "<")
        label = stripText(label[0:i])


    # Find Date (2nd attempt)
    i = string.find(source, ">Released:")

    if i != -1:
        source = searchForPlus(source, ">Released:")
        i = string.find(source, "<")
        date = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, " ")

            if i != -1:
                date = stripText(date[i+1:])


    # Find Tracks
    i = string.find(source, ">Track Listings<")

    if i != -1:
        source = searchForPlus(source, ">Track Listings<")
        i = string.find(source, "</div>")
        disks = stripText(source[0:i])
        i = string.find(disks, " tracks on this disc</a>")

        if i != -1:
            disks = stripText(disks[i-200:])
            disks = searchForPlus(disks, "<a href=\"")
            i = string.find(disks, "\">")
            url = "" + stripText(disks[0:i])
            http = HTTPConnection()
            http.resetReferer();
            http.blockForLoad();
            disks = http.getContents(url)
            disks = searchForPlus(disks, ">Track Listings<")
            i = string.find(disks, "<hr no")
            disks = stripText(disks[0:i])
            t2 = open("trace2.html", "w")
            t2.write(disks)
            t2.close()

        if string.find(disks, ">Disc: ") == -1:
            disks = ">Disc: 1<" + disks

        trackList = []
        artistList = []
        diskCount = 0

        while (searchFor(disks, ">Disc: ") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, ">Disc: ")
            i = string.find(disks, "<")
            diskid = "%02d" % stripText(disks[0:i])

            i = string.find(disks, "</table>")

            if i != -1:
                i = string.find(disks, "</table>")
                tracks = stripText(disks[0:i])
            else:
                tracks = disks

            trackIndex = 1

            while (searchFor(tracks, ". ") != None):
                tracks = searchForPlus(tracks, ". ")

                if (tracks[0:1] == "<"):
                    i = string.find(tracks, "<A HREF=")

                    if i == 0:
                      i = string.find(tracks, ">")
                      tracks = stripText(tracks[i+1:])

                i = string.find(tracks, "<")

                if i != -1:
                    trackid = "%02d" % trackIndex
                    track = stripText(tracks[0:i])
                    i = string.find(track, ">")

                    if (i != -1):
                        track = stripText(track[i+1:])

                    i = string.find(track, " - ")
                    trackArtist = ""

                    if (i != -1):
                        trackArtist = stripText(track[i+3:])
                        track = stripText(track[0:i])

                    trackList.append(diskid + "-" + trackid + "-" + track)
                    trackIndex = trackIndex + 1
                    i = string.find(tracks, "<")

                    if trackArtist != "":
                        trackArtist = convertArtist(trackArtist)
                        artistList.append(diskid + "-" + trackid + "-" + trackArtist)
                    else:
                        artistList.append(diskid + "-" + trackid + "-")

                tracks = tracks[i+1:]

        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)


    i = string.find(source, ">Listen to Samples<")

    if i != -1:
        source = searchForPlus(source, ">Listen to Samples<")
        i = string.find(source, "</div>")
        disks = stripText(source[0:i])
        i = string.find(disks, " tracks on this disc</a>")

        if i != -1:
            disks = stripText(disks[i-200:])
            disks = searchForPlus(disks, "<a href=\"")
            i = string.find(disks, "\">")
            url = "" + stripText(disks[0:i])
            http = HTTPConnection()
            http.resetReferer();
            http.blockForLoad();
            disks = http.getContents(url)
            disks = searchForPlus(disks, ">Listen to Samples<")
            i = string.find(disks, "<hr no")
            disks = stripText(disks[0:i])
            t2 = open("trace2.html", "w")
            t2.write(disks)
            t2.close()

        if string.find(disks, ">Disc: ") == -1:
            disks = ">Disc: 1<" + disks

        trackList = []
        artistList = []
        diskCount = 0

        while (searchFor(disks, ">Disc: ") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, ">Disc: ")
            i = string.find(disks, "<")
            diskid = "%02d" % stripText(disks[0:i])

            i = string.find(disks, "</table>")
            tracks = stripText(disks[0:i])
            trackIndex = 1

            while (searchFor(tracks, ". ") != None):
                tracks = searchForPlus(tracks, ". ")

                if (tracks[0:1] == "<"):
                    i = string.find(tracks, "<A HREF=")

                    if (i == 0):
                      i = string.find(tracks, ">")
                      tracks = stripText(tracks[i+1:])

                i = string.find(tracks, "<")

                if (i != -1):
                    trackid = "%02d" % trackIndex
                    track = stripText(tracks[0:i])
                    i = string.find(track, ">")

                    if (i != -1):
                        track = stripText(track[i+1:])

                    i = string.find(track, " - ")
                    trackArtist = ""

                    if (i != -1):
                        trackArtist = stripText(track[i+3:])
                        track = stripText(track[0:i])

                    trackList.append(diskid + "-" + trackid + "-" + track)
                    trackIndex = trackIndex + 1
                    i = string.find(tracks, "<")

                    if trackArtist != "":
                        trackArtist = convertArtist(trackArtist)
                        artistList.append(diskid + "-" + trackid + "-" + trackArtist)
                    else:
                        artistList.append(diskid + "-" + trackid + "-")

                tracks = tracks[i+1:]

        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)


    # Find Comments
    tag = ">Product Description<"
    i = string.find(source, tag)

    if i == -1:
        tag = ">Reviews<"
        i = string.find(source, tag)

    if i != -1:
        comments = ""
        source = searchForPlus(source, tag)
        source = searchForPlus(source, "<div")
        source = searchForPlus(source, ">")
        i = string.find(source, "</div>")
        tempcomments = source[0:i]

        i = string.find(tempcomments, "</form>")

        if i != -1:
            tempcomments = tempcomments[0:i]

        i = string.find(tempcomments, "<hr noshade")

        if i != -1:
            tempcomments = tempcomments[0:i]

        i = string.find(tempcomments, "<span class=\"h1\">")

        if i != -1:
            tempcomments = tempcomments[0:i]

        i = string.find(tempcomments, "<span")

        if i != -1:
            j = string.find(tempcomments[i:], ">")
            tempcomments = tempcomments[0:i] + tempcomments[i+j+1:]

        i = string.find(tempcomments, "... <")

        if (i != -1):
            tempcomments = stripText(tempcomments[0:i+3])

        tempcomments = string.replace(tempcomments, "\n", "")

        while (searchFor(tempcomments, "  ") != None):
            i = string.find(tempcomments, "  ")
            tempcomments = tempcomments[0:i+1] + tempcomments[i+2:]

        while (searchFor(tempcomments, "<p> ") != None):
            i = string.find(tempcomments, "<p> ")
            tempcomments = tempcomments[0:i+3] + tempcomments[i+4:]

        while (searchFor(tempcomments, "<P> ") != None):
            i = string.find(tempcomments, "<P> ")
            tempcomments = tempcomments[0:i+3] + tempcomments[i+4:]

        while (searchFor(tempcomments, "<br> ") != None):
            i = string.find(tempcomments, "<br> ")
            tempcomments = tempcomments[0:i+4] + tempcomments[i+5:]

        while (searchFor(tempcomments, "<BR> ") != None):
            i = string.find(tempcomments, "<BR> ")
            tempcomments = tempcomments[0:i+4] + tempcomments[i+5:]

        tempcomments = string.replace(tempcomments, "</a>", "")
        tempcomments = string.replace(tempcomments, "</A>", "")
        tempcomments = string.replace(tempcomments, "<p>", "\n\n")
        tempcomments = string.replace(tempcomments, "<P>", "\n\n")
        tempcomments = string.replace(tempcomments, "</p>", "")
        tempcomments = string.replace(tempcomments, "<BR>", "\n")
        tempcomments = string.replace(tempcomments, "<br>", "\n")
        tempcomments = string.replace(tempcomments, "<br />", "\n")
        tempcomments = string.replace(tempcomments, "<i>", "")
        tempcomments = string.replace(tempcomments, "</i>", "")
        tempcomments = string.replace(tempcomments, "<I>", "")
        tempcomments = string.replace(tempcomments, "</I>", "")
        tempcomments = string.replace(tempcomments, "<b>", "")
        tempcomments = string.replace(tempcomments, "</b>", "")
        tempcomments = string.replace(tempcomments, "</font>", "")
        tempcomments = string.replace(tempcomments, "</span>", "")
        tempcomments = string.replace(tempcomments, "&copy;", "")
        tempcomments = string.replace(tempcomments, "&#145;", "'")
        tempcomments = string.replace(tempcomments, "&#169;", "")
        tempcomments = string.replace(tempcomments, "&#8217;", "'")
        tempcomments = string.replace(tempcomments, "&quot;", "\"")
        tempcomments = string.replace(tempcomments, "&#8211;", "-")
        tempcomments = string.replace(tempcomments, "&#146;", "\'")
        tempcomments = string.replace(tempcomments, "<blockquote>", "")
        tempcomments = string.replace(tempcomments, "</blockquote>", "")

        while (searchFor(tempcomments, "\n ") != None):
            i = string.find(tempcomments, "\n ")
            tempcomments = tempcomments[0:i+1] + tempcomments[i+2:]

        while (searchFor(tempcomments, "<a ") != None):
            i = string.find(tempcomments, "<a ")
            j = string.find(tempcomments[i:], ">")

            if j == -1:
                j = 2

            tempcomments = tempcomments[0:i] + tempcomments[i+j+1:]

        while (searchFor(tempcomments, "<A ") != None):
            i = string.find(tempcomments, "<A ")
            j = string.find(tempcomments[i:], ">")
            tempcomments = tempcomments[0:i] + tempcomments[i+j+1:]

        while (searchFor(tempcomments, "<img src") != None):
            i = string.find(tempcomments, "<img src")
            j = string.find(tempcomments[i:], ">")
            tempcomments = tempcomments[0:i] + tempcomments[i+j+1:]

        while (searchFor(tempcomments, "<span") != None):
            i = string.find(tempcomments, "<span")
            j = string.find(tempcomments[i:], ">")
            tempcomments = tempcomments[0:i] + tempcomments[i+j+1:]

        comments = tempcomments


    extractCategory()




try:
    extract()
finally:
    if os.path.exists("scrapers/awuserexit.py"):
        execfile("scrapers/awuserexit.py") in globals()
