# Amazon music scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import convertArtist
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    sound               = "Stereo"
    format              = "CD"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    artistLF            = ""


    i = string.find(source, "sai-identify")

    if i != -1:
        source = searchForPlus(source, "sai-identify")
        i = string.find(source, "/ASIN/")
        source = source[i-50:]
        source = searchForPlus(source, "<a href=")
        i = string.find(source, ">")
        url = stripText(source[0:i])
        http = HTTPConnection()
        http.resetReferer();
        http.blockForLoad();
        source = http.getContents(url)
        t2 = open("trace2.html", "w")
        t2.write(source)
        t2.close()



    # Find marketplace pricing
    marketinfo = source
    i = string.find(marketinfo, ">From Our Marketplace Sellers:<")

    if (i != -1):
        marketinfo = searchForPlus(marketinfo, ">From Our Marketplace Sellers:<")


    # Find List price
    i = string.find(marketinfo, "List Price:")

    if (i != -1):
        listprice = searchForPlus(marketinfo, "List Price:")
        listprice = searchFor(listprice, "$")
        i = string.find(listprice, "<")
        listprice = stripText(listprice[0:i])


    # Find New/Used together
    i = string.find(marketinfo, "/offer-listing/")

    if i != -1:
        usedinfo = stripText(marketinfo[i:])
        usedinfo = searchForPlus(usedinfo, ">")
        i = string.find(usedinfo, "</div>")
        usedinfo = stripText(usedinfo[0:i])

        i = string.find(usedinfo, "used &amp; new")

        if i != -1:
            i = string.find(usedinfo, " ")
            usedcount = stripText(usedinfo[0:i])
            newcount = stripText(usedinfo[0:i])
            usedprice = searchForPlus(usedinfo, "used &amp; new")
            usedprice = searchFor(usedprice, ">$")
            usedprice = searchForPlus(usedprice, ">")
            i = string.find(usedprice, "<")
            usedprice = stripText(usedprice[0:i])
            newprice = stripText(usedprice[0:i])

        i = string.find(usedinfo, "used & new")

        if i != -1:
            i = string.find(usedinfo, " ")
            usedcount = stripText(usedinfo[0:i])
            newcount = stripText(usedinfo[0:i])
            usedprice = searchForPlus(usedinfo, "used & new")
            usedprice = searchFor(usedprice, ">$")
            usedprice = searchForPlus(usedprice, ">")
            i = string.find(usedprice, "<")
            usedprice = stripText(usedprice[0:i])
            newprice = stripText(usedprice[0:i])

        i = string.find(usedinfo, "available offers<")

        if i != -1:
            i = string.find(usedinfo, " ")
            usedcount = stripText(usedinfo[0:i])
            newcount = stripText(usedinfo[0:i])
            usedprice = searchFor(usedinfo, ">$")
            usedprice = searchForPlus(usedprice, ">")
            i = string.find(usedprice, "<")
            usedprice = stripText(usedprice[0:i])
            newprice = stripText(usedprice[0:i])

        i = string.find(usedinfo, ">See all used<")

        if (i != -1):
            usedprice = searchForPlus(usedinfo, ">See all used<")
            usedprice = searchFor(usedprice, ">$")
            usedprice = searchForPlus(usedprice, ">")
            i = string.find(usedprice, "<")
            usedprice = stripText(usedprice[0:i])

        i = string.find(usedinfo, ">See all new<")

        if (i != -1):
            newprice = searchForPlus(usedinfo, ">See all new<")
            newprice = searchFor(newprice, ">$")
            newprice = searchForPlus(newprice, ">")
            i = string.find(newprice, "<")
            newprice = stripText(newprice[0:i])

        i = string.find(usedinfo, ">See all collectible<")

        if (i != -1):
            collectibleprice = searchForPlus(usedinfo, ">See all collectible<")
            collectibleprice = searchFor(collectibleprice, ">$")
            collectibleprice = searchForPlus(collectibleprice, ">")
            i = string.find(collectibleprice, "<")
            collectibleprice = stripText(collectibleprice[0:i])


    # Find New
    i = string.find(marketinfo, "offers/new")

    if (i != -1):
        usedinfo = searchForPlus(marketinfo, "offers/new")
        usedinfo = searchForPlus(usedinfo, ">")
        i = string.find(usedinfo, "<br>")
        usedinfo = stripText(usedinfo[0:i])

        i = string.find(usedinfo, "new<")

        if (i != -1):
            i = string.find(usedinfo, "new<")
            newcount = stripText(usedinfo[0:i])

            usedinfo = searchForPlus(usedinfo, "new<")
            usedinfo = searchFor(usedinfo, ">$")
            usedinfo = searchForPlus(usedinfo, ">")
            i = string.find(usedinfo, "<")
            newprice = stripText(usedinfo[0:i])


    # Find Collectible
    i = string.find(marketinfo, "offers/collectible")

    if (i != -1):
        usedinfo = searchForPlus(marketinfo, "offers/collectible")
        usedinfo = searchForPlus(usedinfo, ">")
        i = string.find(usedinfo, "<br>")
        usedinfo = stripText(usedinfo[0:i])

        i = string.find(usedinfo, "collectible<")

        if (i != -1):
            i = string.find(usedinfo, "collectible<")
            collectiblecount = stripText(usedinfo[0:i])

            usedinfo = searchForPlus(usedinfo, "collectible<")
            usedinfo = searchFor(usedinfo, ">$")
            usedinfo = searchForPlus(usedinfo, ">")
            i = string.find(usedinfo, "<")
            collectibleprice = stripText(usedinfo[0:i])


    # Find Used
    i = string.find(marketinfo, "offers/used")

    if (i != -1):
        usedinfo = searchForPlus(marketinfo, "offers/used")
        usedinfo = searchForPlus(usedinfo, ">")
        i = string.find(usedinfo, "<br>")
        usedinfo = stripText(usedinfo[0:i])

        i = string.find(usedinfo, "used<")

        if (i != -1):
            i = string.find(usedinfo, "used<")
            usedcount = stripText(usedinfo[0:i])

            usedinfo = searchForPlus(usedinfo, "used<")
            usedinfo = searchFor(usedinfo, ">$")
            usedinfo = searchForPlus(usedinfo, ">")
            i = string.find(usedinfo, "<")
            usedprice = stripText(usedinfo[0:i])


    # Find Ranking
    i = string.find(marketinfo, ">Amazon.com Sales Rank")

    if i != -1:
        usedinfo = searchForPlus(marketinfo, ">Amazon.com Sales Rank")
        usedinfo = searchForPlus(usedinfo, "</b>")
        usedinfo = searchForPlus(usedinfo, "#")
        i = string.find(usedinfo, "<")
        salesrank = stripText(usedinfo[0:i])
        i = string.find(salesrank, " ")

        if i != -1:
            salesrank = stripText(salesrank[0:i])


    # Find Buyer Waiting
    i = string.find(marketinfo, "buyer waiting!")

    if (i != -1):
        buyerwaiting = "Y"



    # Find Image
    i = string.find(source, "registerImage(\"original_image\"")

    if i != -1:
        source = searchForPlus(source, "registerImage(\"original_image\"")
        source = searchForPlus(source, "\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])

        i = string.find(image, "no-image-avail")

        if i != -1:
            image = ""


    # Find Title
    source = searchForPlus(source, "\"btAsinTitle\"")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Artist
    i = string.find(source, "artist/glance")

    if i != -1 and i < 500:
        source = searchForPlus(source, "artist/glance")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        artist = stripText(source[0:i])
        artist = convertArtist(artist)
    else:
        i = string.find(source, "&field-artist=")

        if i != -1 and i < 500:
            while (string.find(source, "&field-artist=") != -1):
                i = string.find(source, "&field-artist=")

                if i != -1 and i < 500:
                    source = searchForPlus(source, "&field-artist=")
                    source = searchForPlus(source, ">")
                    i = string.find(source, "<")
                    artist = stripText(source[0:i])
                    artist = convertArtist(artist)

                    i = string.find(source, "(Composer)")

                    if i != -1 and i < 25:
                        composer = artist
                        artist = ""
                        continue

                    i = string.find(source, "(Conductor)")

                    if i != -1 and i < 25:
                        conductor = artist
                        artist = ""
                        continue

                break;
        else:
            i = string.find(source, ">Performer:<")
                
            if i != -1:
                artist = searchForPlus(source, ">Performer:<")
                artist = searchForPlus(artist, "\">")
                i = string.find(artist, "<")
                artist = stripText(artist[0:i])
                artist = convertArtist(artist)
            else:
                i = string.find(source, "/music/artist/")
                
                if i != -1 and i < 500:
                    artist = searchForPlus(source, "/music/artist/")
                    artist = searchForPlus(artist, "\">")
                    i = string.find(artist, "<")
                    artist = stripText(artist[0:i])
                    artist = convertArtist(artist)
                else:
                    i = string.find(source, "/artist/")
                
                    if i != -1 and i < 500:
                        artist = searchForPlus(source, "/artist/")
                        artist = searchForPlus(artist, "\">")
                        i = string.find(artist, "<")
                        artist = stripText(artist[0:i])
                        artist = convertArtist(artist)


    # Find user rating
    tag = "/>See all "
    i = string.find(source, tag)

    if i != -1:
        temp = searchForPlus(source, tag)
        i = string.find(source, "/customer-reviews/ratings/stars")

        if i != -1:
            temp = searchFor(temp, "/customer-reviews/ratings/stars")
            i = string.find(temp, ".")
            temp = stripText(temp[0:i])
            temp = searchForPlus(temp, "stars-")
            temp = string.replace(temp, "-", ".")

            if temp != "":
                rating = temp + " Stars"


    # Find Price
    i = string.find(source, ">Price:<")

    if (i == -1):
        i = string.find(source, "class=price")

    if (i == -1):
        i = string.find(source, ">List Price:")

    if i != -1 and i < 5000:
        source = source[i:]

        source = searchFor(source, "$")
        i = string.find(source, "<")
        value = stripText(source[0:i])

        # Price can contain special charges, ignore
        i = string.find(value, "+")

        if (i != -1):
            value = stripText(value[0:i])
    else:
        value = usedprice


    # Find Label
    i = string.find(source, ">Label:")

    if i != -1:
        tempdata = searchForPlus(source, ">Label:")
        tempdata = searchForPlus(tempdata, ">")
        i = string.find(tempdata, "<")
        label = stripText(tempdata[0:i])


    # Find Composer
    i = string.find(source, ">Composer:")

    if i != -1:
        composer = searchForPlus(source, ">Composer:")
        composer = searchForPlus(composer, "\">")
        i = string.find(composer, "<")
        composer = stripText(composer[0:i])

        i = string.rfind(composer, " ")

        if i != -1:
            composer = stripText(composer[i+1:]) + ", " + stripText(composer[0:i])


    # Find Format
    i = string.find(source, ">Product Details")

    if i != -1:
        source = searchForPlus(source, ">Product Details<")

        i = string.find(source, "<b>Audio CD<")

        if i != -1 and i < 500:
            source = searchFor(source, "<b>Audio CD<")
            source = searchForPlus(source, "<b>")
            i = string.find(source, "<")
            format = stripText(source[0:i])

        i = string.find(source, "<b>Audio Cassette<")

        if i != -1 and i < 500:
            source = searchFor(source, "<b>Audio Cassette<")
            source = searchForPlus(source, "<b>")
            i = string.find(source, "<")
            format = stripText(source[0:i])


    # Find Date
    i = string.find(source, "(")

    if i != -1 and i < 25:
        source = searchForPlus(source, "(")
        i = string.find(source, ")")
        date = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, " ")

            if i != -1:
                date = stripText(date[i+1:])


    # Find Copyright date
    i = string.find(source, ">Original Release Date<")

    if i != -1:
        source = searchForPlus(source, ">Original Release Date<")
        source = searchForPlus(source, ":")
        i = string.find(source, "<")
        copyDate = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(copyDate, " ")

            if i != -1:
                copyDate = stripText(copyDate[i+1:])


    # Find Tracks
    gotTracks = 0

    i = string.find(source, ">Track Listings<")

    if gotTracks == 0 and i != -1:
        gotTracks = 1
        source = searchForPlus(source, ">Track Listings<")
        i = string.find(source, "<hr no")
        disks = stripText(source[0:i])
        i = string.find(disks, " tracks on this disc</a>")

        if i != -1:
            disks = stripText(disks[i-175:])
            disks = searchForPlus(disks, "<a href=\"")
            i = string.find(disks, "\">")
            url = "" + stripText(disks[0:i])
            http = HTTPConnection()
            http.resetReferer();
            http.blockForLoad();
            disks = http.getContents(url)
            disks = searchForPlus(disks, ">Track Listings<")
            i = string.find(disks, "<hr no")
            disks = stripText(disks[0:i])
            

        if string.find(disks, ">Disc: ") == -1:
            disks = ">Disc: 1<" + disks

        trackList = []
        artistList = []
        diskCount = 0

        while (searchFor(disks, ">Disc: ") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, ">Disc: ")
            i = string.find(disks, "<")
            diskid = "%02d" % stripText(disks[0:i])

            i = string.find(disks, "</table>")
            tracks = stripText(disks[0:i])
            trackIndex = 1

            while (searchFor(tracks, ". ") != None):
                tracks = searchForPlus(tracks, ". ")

                if (tracks[0:1] == "<"):
                    i = string.find(tracks, "<A HREF=")

                    if (i == 0):
                      i = string.find(tracks, ">")
                      tracks = stripText(tracks[i+1:])

                i = string.find(tracks, "<")

                if (i != -1):
                    trackid = "%02d" % trackIndex
                    track = stripText(tracks[0:i])
                    i = string.find(track, ">")

                    if (i != -1):
                        track = stripText(track[i+1:])

                    i = string.find(track, " - ")
                    trackArtist = ""

                    if (i != -1):
                        trackArtist = stripText(track[i+3:])
                        track = stripText(track[0:i])

                    trackList.append(diskid + "-" + trackid + "-" + track)
                    trackIndex = trackIndex + 1
                    i = string.find(tracks, "<")

                    if trackArtist != "":
                        trackArtist = convertArtist(trackArtist)
                        artistList.append(diskid + "-" + trackid + "-" + trackArtist)
                    else:
                        artistList.append(diskid + "-" + trackid + "-")

                tracks = tracks[i+1:]

        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)


    i = string.find(source, ">Listen to Samples<")

    if gotTracks == 0 and i != -1:
        gotTracks = 1
        source = searchForPlus(source, ">Listen to Samples<")
        i = string.find(source, "<hr no")
        disks = stripText(source[0:i])
        i = string.find(disks, " tracks on this disc</a>")

        if i != -1:
            disks = stripText(disks[i-175:])
            disks = searchForPlus(disks, "<a href=\"")
            i = string.find(disks, "\">")
            url = "" + stripText(disks[0:i])
            http = HTTPConnection()
            http.resetReferer();
            http.blockForLoad();
            disks = http.getContents(url)
            t2 = open("trace-d.html", "w")
            t2.write(disks)
            t2.close()
            disks = searchForPlus(disks, ">Listen to Samples<")
            i = string.find(disks, "<hr no")
            disks = stripText(disks[0:i])

        if string.find(disks, ">Disc: ") == -1:
            disks = ">Disc: 1<" + disks

        trackList = []
        artistList = []
        diskCount = 0

        while (searchFor(disks, ">Disc: ") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, ">Disc: ")
            i = string.find(disks, "<")
            diskid = "%02d" % stripText(disks[0:i])
            disks = searchForPlus(disks, "<tr ")

            i = string.find(disks, "</table>")
            tracks = stripText(disks[0:i])

            i = string.find(disks, "</tbody>")

            if i != -1:
                tracks = stripText(disks[0:i])

            trackIndex = 1

            while (searchFor(tracks, ". ") != None):
                tracks = searchForPlus(tracks, ". ")

                if (tracks[0:1] == "<"):
                    i = string.find(tracks, "<A HREF=")

                    if (i == 0):
                      i = string.find(tracks, ">")
                      tracks = stripText(tracks[i+1:])

                i = string.find(tracks, "<")

                if (i != -1):
                    trackid = "%02d" % trackIndex
                    track = stripText(tracks[0:i])
                    i = string.find(track, ">")

                    if (i != -1):
                        track = stripText(track[i+1:])

                    track = string.replace(track, "&quot;", "\"")

                    i = string.find(track, " - ")
                    trackArtist = ""

                    if (i != -1):
                        trackArtist = stripText(track[i+3:])
                        track = stripText(track[0:i])

                    trackList.append(diskid + "-" + trackid + "-" + track)
                    trackIndex = trackIndex + 1
                    i = string.find(tracks, "<")

                    if trackArtist != "":
                        trackArtist = convertArtist(trackArtist)
                        artistList.append(diskid + "-" + trackid + "-" + trackArtist)
                    else:
                        artistList.append(diskid + "-" + trackid + "-")

                tracks = tracks[i+1:]

        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)




    i = string.find(source, ">Listen to Samples and Buy MP3s<")

    if gotTracks == 0 and i != -1:
        gotTracks = 1
        source = searchForPlus(source, ">Listen to Samples and Buy MP3s<")
        source = searchForPlus(source, "id='albumTrackList'")
        i = string.find(source, "</DIV>")
        disks = stripText(source[0:i])

        if string.find(disks, ">Disc ") == -1:
            disks = ">Disc 1<" + disks

        trackList = []
        artistList = []
        runningList = []
        diskCount = 0

        while (searchFor(disks, ">Disc ") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, ">Disc ")
            i = string.find(disks, "<")
            diskid = "%02d" % stripText(disks[0:i])
            disks = searchForPlus(disks, "class=\"columnHeader\"")

            i = string.find(disks, "</table>")
            tracks = stripText(disks[0:i])

            trackIndex = 1

            while (searchFor(tracks, "class=\"titleCol\"") != None):
                trackid = "%02d" % trackIndex
                tracks = searchForPlus(tracks, "class=\"titleCol\"")
                tracks = searchForPlus(tracks, " href=\"")
                tracks = searchForPlus(tracks, ">")
                i = string.find(tracks, "<")
                track = stripText(tracks[0:i])

                trackArtist = ""
                i = string.find(tracks, "class=\"titleCol\"")

                if i != -1 and i < 100:
                    tracks = searchForPlus(tracks, "class=\"titleCol\"")
                    tracks = searchForPlus(tracks, " href=\"")
                    tracks = searchForPlus(tracks, ">")
                    i = string.find(tracks, "<")
                    trackArtist = stripText(tracks[0:i])

                tracks = searchForPlus(tracks, "class=\"runtimeCol\"")
                tracks = searchForPlus(tracks, ">")
                i = string.find(tracks, "<")
                trackTime = stripText(tracks[0:i])


                trackList.append(diskid + "-" + trackid + "-" + track)

                if trackArtist != "":
                    trackArtist = convertArtist(trackArtist)
                    artistList.append(diskid + "-" + trackid + "-" + trackArtist)
                else:
                    artistList.append(diskid + "-" + trackid + "-")

                runningList.append(diskid + "-" + trackid + "-" + trackTime)

                trackIndex = trackIndex + 1

        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)
        runningList.sort()
        trackTimes = array(runningList, String)


    # Find Tracks
    i = string.find(source, "On this CD:")

    if gotTracks == 0 and i != -1:
        gotTracks = 1
        source = searchForPlus(source, "On this CD:")
        i = string.find(source, "</div>")
        disks = stripText(source[0:i])

        if string.find(disks, ">Disc: ") == -1:
            disks = ">Disc: 1<" + disks

        trackList = []
        artistList = []
        writerList = []
        diskCount = 0

        while (searchFor(disks, ">Disc: ") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, ">Disc: ")
            i = string.find(disks, "<")
            diskid = "%02d" % stripText(disks[0:i])

            i = string.find(disks, "</table>")

            if i != -1:
                tracks = stripText(disks[0:i])
            else:
                tracks = disks

            trackIndex = 1

            while (searchFor(tracks, "<li>") != None):
                tracks = searchForPlus(tracks, "<li>")
                tracks = searchForPlus(tracks, "<b>")

                if (tracks[0:1] == "<"):
                    i = string.find(tracks, "<A HREF=")

                    if (i == 0):
                      i = string.find(tracks, ">")
                      tracks = stripText(tracks[i+1:])

                i = string.find(tracks, "<")

                if (i != -1):
                    trackid = "%02d" % trackIndex
                    track = stripText(tracks[0:i])
                    i = string.find(track, ">")

                    if (i != -1):
                        track = stripText(track[i+1:])

                    track = string.replace(track, "&quot;", "\"")
                    trackList.append(diskid + "-" + trackid + "-" + track)
                    trackIndex = trackIndex + 1
                    i = string.find(tracks, "<")

                tracks = tracks[i+1:]

                i = string.find(tracks, ". ")

                if (i != -1):
                    temptrack = stripText(tracks[0:i])
                else:
                    temptrack = tracks

                i = string.find(temptrack, "Composed by")

                if (i != -1):
                    temptrack = searchForPlus(temptrack, "Composed by")
                    temptrack = searchForPlus(temptrack,  "\">")
                    i = string.find(temptrack, "<")
                    writerList.append(diskid + "-" + trackid + "-" + stripText(temptrack[0:i]))
                else:
                    writerList.append(diskid + "-" + trackid + "-")

                i = string.find(temptrack, "\nwith ")

                if (i != -1):
                    temptrack = searchForPlus(temptrack, "\nwith ")
                    temptrack = searchForPlus(temptrack,  "\">")
                    i = string.find(temptrack, "<")
                    artistList.append(diskid + "-" + trackid + "-" + stripText(temptrack[0:i]))
                else:
                    artistList.append(diskid + "-" + trackid + "-")


        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)
        writerList.sort()
        trackWriters = array(writerList, String)


    # Find Comments
    comments = ""
    i = string.find(source, ">Editorial Reviews<")

    if i != -1:
        source = searchForPlus(source, ">Editorial Reviews<")
        i = string.find(source, "\n</div>")
        tempcomments = source[0:i]

        i = string.find(tempcomments, "<hr")

        if i != -1:
            tempcomments = source[0:i]

        i = string.find(tempcomments, "<b class=\"h1\">Customer Reviews")

        if i != -1:
            tempcomments = source[0:i]

        while (searchFor(tempcomments, "<div class=\"content\">") != None):
            tempcomments = searchForPlus(tempcomments, "<div class=\"content\">")
            i = string.find(tempcomments, "<font")

            if i > 0 and i < 75:
                tempcomments = searchForPlus(tempcomments, "<font")

            i = string.find(tempcomments, "<span")

            if i > 0 and i < 75:
                tempcomments = searchForPlus(tempcomments, "<span")

            tempcomments = searchForPlus(tempcomments, ">")
            i = string.find(tempcomments, "</div>")
            tempcomment = stripText(tempcomments[0:i])

            i = string.find(tempcomment, "... <")

            if (i != -1):
                tempcomment = stripText(tempcomment[0:i+3])

            while (searchFor(tempcomment, "<p> ") != None):
                i = string.find(tempcomment, "<p> ")
                tempcomment = tempcomment[0:i+3] + tempcomment[i+4:]

            while (searchFor(tempcomment, "<P> ") != None):
                i = string.find(tempcomment, "<P> ")
                tempcomment = tempcomment[0:i+3] + tempcomment[i+4:]

            while (searchFor(tempcomment, "<br> ") != None):
                i = string.find(tempcomment, "<br> ")
                tempcomment = tempcomment[0:i+4] + tempcomment[i+5:]

            while (searchFor(tempcomment, "<BR> ") != None):
                i = string.find(tempcomment, "<BR> ")
                tempcomment = tempcomment[0:i+4] + tempcomment[i+5:]

            tempcomment = string.replace(tempcomment, "</a>", "")
            tempcomment = string.replace(tempcomment, "</A>", "")
            tempcomment = string.replace(tempcomment, "<p>", "\n\n")
            tempcomment = string.replace(tempcomment, "<P>", "\n\n")
            tempcomment = string.replace(tempcomment, "</p>", "")
            tempcomment = string.replace(tempcomment, "<BR>", "\n")
            tempcomment = string.replace(tempcomment, "<br>", "\n")
            tempcomment = string.replace(tempcomment, "<br />", "\n")
            tempcomment = string.replace(tempcomment, "<i>", "")
            tempcomment = string.replace(tempcomment, "</i>", "")
            tempcomment = string.replace(tempcomment, "<I>", "")
            tempcomment = string.replace(tempcomment, "</I>", "")
            tempcomment = string.replace(tempcomment, "<b>", "")
            tempcomment = string.replace(tempcomment, "</b>", "")
            tempcomment = string.replace(tempcomment, "<strong>", "")
            tempcomment = string.replace(tempcomment, "</strong>", "")
            tempcomment = string.replace(tempcomment, "</font>", "")
            tempcomment = string.replace(tempcomment, "</span>", "")
            tempcomment = string.replace(tempcomment, "<em>", "")
            tempcomment = string.replace(tempcomment, "</em>", "")
            tempcomment = string.replace(tempcomment, "&copy;", "")
            tempcomment = string.replace(tempcomment, "&#169;", "")
            tempcomment = string.replace(tempcomment, "&#8217;", "'")
            tempcomment = string.replace(tempcomment, "&quot;", "\"")
            tempcomment = string.replace(tempcomment, "&#8211;", "-")
            tempcomment = string.replace(tempcomment, "&#145;", "'")
            tempcomment = string.replace(tempcomment, "&#146;", "'")
            tempcomment = string.replace(tempcomment, "&#147;", "\"")
            tempcomment = string.replace(tempcomment, "&#151;", "--")
            tempcomment = string.replace(tempcomment, "  ", " ")
            tempcomment = string.replace(tempcomment, "  ", " ")
            tempcomment = string.replace(tempcomment, "  ", " ")
            tempcomment = string.replace(tempcomment, "\n ", "\n")
            tempcomment = string.replace(tempcomment, "\n ", "\n")
            tempcomment = string.replace(tempcomment, "\n ", "\n")
            tempcomment = string.replace(tempcomment, "\n\n\n", "\n\n")
            tempcomment = string.replace(tempcomment, "\n\n\n", "\n\n")
            tempcomment = string.replace(tempcomment, "\n\n\n", "\n\n")

            while (searchFor(tempcomment, "<a ") != None):
                i = string.find(tempcomment, "<a ")
                j = string.find(tempcomment[i:], ">")
                tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

            while (searchFor(tempcomment, "<A ") != None):
                i = string.find(tempcomment, "<A ")
                j = string.find(tempcomment[i:], ">")
                tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

            while (searchFor(tempcomment, "<img src") != None):
                i = string.find(tempcomment, "<img src")
                j = string.find(tempcomment[i:], ">")
                tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

            while (searchFor(tempcomment, "<span") != None):
                i = string.find(tempcomment, "<span")
                j = string.find(tempcomment[i:], ">")
                tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

            while (searchFor(tempcomment, "<table") != None):
                i = string.find(tempcomment, "<table")
                j = string.find(tempcomment[i:], "</table>")
                tempcomment = tempcomment[0:i] + tempcomment[i+j+8:]

            i = string.find(tempcomment, "See all Editorial Reviews")

            if i != -1:
                tempcomment = stripText(tempcomment[0:i])

            if comments != "":
                comments = comments + tempcomment
            else:
                comments = tempcomment

    # Not being used, Prod Desc now in Editorial section
    i = string.find(source, ">xxxProduct Description<")

    if i != -1:
        source = searchForPlus(source, ">Product Description<")
        source = searchForPlus(source, "class=\"content\">")
        i = string.find(source, "</div>")
        tempcomment = source[0:i]

        tempcomment = string.replace(tempcomment, "</a>", "")
        tempcomment = string.replace(tempcomment, "</A>", "")
        tempcomment = string.replace(tempcomment, "<p>", "\n\n")
        tempcomment = string.replace(tempcomment, "<P>", "\n\n")
        tempcomment = string.replace(tempcomment, "</p>", "")
        tempcomment = string.replace(tempcomment, "<BR>", "\n")
        tempcomment = string.replace(tempcomment, "<br>", "\n")
        tempcomment = string.replace(tempcomment, "<br />", "\n")
        tempcomment = string.replace(tempcomment, "<i>", "")
        tempcomment = string.replace(tempcomment, "</i>", "")
        tempcomment = string.replace(tempcomment, "<I>", "")
        tempcomment = string.replace(tempcomment, "</I>", "")
        tempcomment = string.replace(tempcomment, "<b>", "")
        tempcomment = string.replace(tempcomment, "</b>", "")
        tempcomment = string.replace(tempcomment, "<strong>", "")
        tempcomment = string.replace(tempcomment, "</strong>", "")
        tempcomment = string.replace(tempcomment, "</font>", "")
        tempcomment = string.replace(tempcomment, "</span>", "")
        tempcomment = string.replace(tempcomment, "&copy;", "")
        tempcomment = string.replace(tempcomment, "&#169;", "")
        tempcomment = string.replace(tempcomment, "&#8217;", "'")
        tempcomment = string.replace(tempcomment, "&quot;", "\"")
        tempcomment = string.replace(tempcomment, "&#8211;", "-")
        tempcomment = string.replace(tempcomment, "&#145;", "'")
        tempcomment = string.replace(tempcomment, "&#146;", "'")
        tempcomment = string.replace(tempcomment, "&#147;", "\"")
        tempcomment = string.replace(tempcomment, "&#151;", "--")
        tempcomment = string.replace(tempcomment, "\n ", "\n")
        tempcomment = string.replace(tempcomment, "\n ", "\n")
        tempcomment = string.replace(tempcomment, "\n ", "\n")
        tempcomment = string.replace(tempcomment, "  ", " ")
        tempcomment = string.replace(tempcomment, "  ", " ")
        tempcomment = string.replace(tempcomment, "  ", " ")

        while (searchFor(tempcomment, "<a ") != None):
            i = string.find(tempcomment, "<a ")
            j = string.find(tempcomment[i:], ">")
            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        while (searchFor(tempcomment, "<A ") != None):
            i = string.find(tempcomment, "<A ")
            j = string.find(tempcomment[i:], ">")
            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        while (searchFor(tempcomment, "<img src") != None):
            i = string.find(tempcomment, "<img src")
            j = string.find(tempcomment[i:], ">")
            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        while (searchFor(tempcomment, "<span") != None):
            i = string.find(tempcomment, "<span")
            j = string.find(tempcomment[i:], ">")
            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        while (searchFor(tempcomment, "<table") != None):
            i = string.find(tempcomment, "<table")
            j = string.find(tempcomment[i:], "</table>")
            tempcomment = tempcomment[0:i] + tempcomment[i+j+8:]

        if comments != "":
            comments = comments + "\n\n" + tempcomment
        else:
            comments = tempcomment


    extractCategory()


def extractCategory():
    global title,author,format,bookclub,first,signed,read,date,publisher,place,isbn
    global value,category,copies,condition,rating,comments,source,image
    global fullDateFormat

    # Find category
    i = string.find(source, ">Browse for")

    if (i != -1):
        source = searchForPlus(source, ">Browse for")
        source = searchForPlus(source, "<li>")
        i = string.find(source, "</ul>")
        tempCatg = source[0:i]
        x = string.find(tempCatg, "<li>")

        if (x != -1):
            tempCatg = stripText(tempCatg[0:x])

    if (i != -1):
        category = ""

        while (searchFor(tempCatg, "href=") != None):
            tempCatg = searchForPlus(tempCatg, "href=")
            tempCatg = searchForPlus(tempCatg, ">")
            i = string.find(tempCatg, "<")
            temp = stripText(tempCatg[0:i])

            if temp != "Styles":
                if (category != ""):
                    category = category + " : "

                category = category + temp

            tempCatg = tempCatg[i:]



try:
    extract()
finally:
    if os.path.exists("scrapers/awuserexit.py"):
        execfile("scrapers/awuserexit.py") in globals()
