# AlphaCraze music scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import convertArtist
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    sound               = "Stereo"
    format              = "CD"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    artistLF            = ""


    # Find marketplace pricing
    marketinfo = source

    # Find List Price
    listprice = ""
    i = string.find(marketinfo, ">List Price:")

    if (i != -1):
        listprice = searchForPlus(marketinfo, ">List Price:")
        listprice = searchForPlus(listprice, ">")
        i = string.find(listprice, "<")
        listprice = stripText(listprice[0:i])


    # Main extraction
    source = searchForPlus(source, "<!-- Begin Page Data -->")

    # Find Title
    source = searchForPlus(source, "<b>")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Image
    i = string.find(source, "thumb")

    if (i != -1):
        source = searchForPlus(source, "thumb")
        source = searchForPlus(source, " src=\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])


    # Find Artist
    i = string.find(source, ">Artist:")

    if (i != -1):
        source = searchForPlus(source, ">Artist:")
        source = searchForPlus(source, "\">")
        source = searchForPlus(source, "<em>")
        i = string.find(source, "<")
        artist = stripText(source[0:i])
        artist = convertArtist(artist)


    # Find Price
    i = string.find(source, ">Crazy Price:")

    if (i == -1):
        i = string.find(source, ">List Price:")

    if (i != -1):
        source = source[i:]

        source = searchFor(source, "$")
        i = string.find(source, "<")
        value = stripText(source[0:i])


    # Find Format
    i = string.find(source, ">Format:")

    if i != -1:
        source = searchForPlus(source, ">Format:")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        format = stripText(source[0:i])


    # Find Label
    i = string.find(source, ">Label:")

    if i != -1:
        source = searchForPlus(source, ">Label:")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        label = stripText(source[0:i])


    # Find Category
    i = string.find(source, ">Category:")

    if i != -1:
        source = searchForPlus(source, ">Category:")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        category = stripText(source[0:i])


    # Find UPC
    i = string.find(source, ">UPC:")

    if i != -1:
        source = searchForPlus(source, ">UPC:")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        upc = stripText(source[0:i])



    # Find Tracks
    i = string.find(source, ">Track List:")

    if i != -1:
        source = searchForPlus(source, ">Track List:")
        source = searchForPlus(source, "<table")
        i = string.find(source, "</table>")
        disks = stripText(source[0:i])

        if string.find(disks, ">DISC 1:") == -1:
            disks = ">DISC 1:<" + disks

        trackList = []
        artistList = []
        diskCount = 0

        while (searchFor(disks, ">DISC ") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, ">DISC ")
            i = string.find(disks, ":")
            diskid = "%02d" % stripText(disks[0:i])

            i = string.find(disks, ">DISC ")

            if i != -1:
                tracks = stripText(disks[0:i])
            else:
                tracks = disks

            trackIndex = 1

            while (searchFor(tracks, ".<") != None):
                tracks = searchForPlus(tracks, ".<")
                tracks = searchForPlus(tracks, "<td")
                tracks = searchForPlus(tracks, ">")

                if tracks == None:
                    break

                i = string.find(tracks, "<")

                if (i != -1):
                    trackid = "%02d" % trackIndex
                    track = stripText(tracks[0:i])
                    i = string.find(track, ">")

                    if (i != -1):
                        track = stripText(track[i+1:])

                    i = string.find(track, " - ")
                    trackArtist = ""

                    if (i != -1):
                        if track[i+3:i+4] != "(":
                            trackArtist = stripText(track[i+3:])
                            track = stripText(track[0:i])

                    trackList.append(diskid + "-" + trackid + "-" + track)
                    trackIndex = trackIndex + 1
                    i = string.find(tracks, "<")

                    if trackArtist != "":
                        trackArtist = convertArtist(trackArtist)
                        artistList.append(diskid + "-" + trackid + "-" + trackArtist)
                    else:
                        artistList.append(diskid + "-" + trackid + "-")

                tracks = tracks[i+1:]

        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)



try:
    extract()
finally:
    if os.path.exists("scrapers/awuserexit.py"):
        execfile("scrapers/awuserexit.py") in globals()
