# All Music Guide music scrpaer
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import convertArtist
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    sound               = "Stereo"
    format              = "CD"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    artistLF            = ""


    i = string.find(source, "<!--Start Content Area -->")

    if i == -1:
        return


    # Find marketplace pricing
    marketinfo = source



    # Main Extraction
    source = searchForPlus(source, "<!--Start Content Area -->")

    # Find Title
    source = searchForPlus(source, "<span class=\"title\">")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Artist
    i = string.find(source, "class=\"subtitle\">")

    if (i != -1):
        source = searchForPlus(source, "class=\"subtitle\">")
        i = string.find(source, "<")
        artist = stripText(source[0:i])
        artist = convertArtist(artist)


    # Find Image
    i = string.find(source, "image.allmusic.com")

    if (i != -1):
        source = source[i-25:]
        source = searchForPlus(source, " src=\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])


    i = string.find(source, "id=\"left-sidebar-title\"")

    if i != -1:
        # Find Artist
        i = string.find(source, ">Artist<")

        if (i != -1):
            source = searchForPlus(source, ">Artist<")
            source = searchForPlus(source, "class=\"sub-text\"")
            source = searchForPlus(source, "\">")
            i = string.find(source, "</td>")
            artist = stripText(source[0:i])

            i = string.find(artist, "\">")

            if i != -1:
                artist = searchForPlus(artist, "\">")
                i = string.find(artist, "<")
                artist = stripText(artist[0:i])

            artist = convertArtist(artist)


        # Find Title
        i = string.find(source, ">Album<")

        if (i != -1):
            source = searchForPlus(source, ">Album<")
            source = searchForPlus(source, "class=\"sub-text\"")
            source = searchForPlus(source, "\">")
            i = string.find(source, "<")
            title = stripText(source[0:i])


        # Find Rating
        i = string.find(source, ">Rating<")

        if (i != -1):
            source = searchForPlus(source, ">Rating<")
            source = searchForPlus(source, "class=\"rating-stars\"")
            source = searchForPlus(source, "<img src=\"/i")
            i = string.find(source, ".")
            rating = stripText(source[0:i])
            i = string.rfind(rating, "/")
            rating = stripText(rating[i+1:])

            if rating == "st_r3":
                rating = "1.5 Stars"
            elif rating == "st_r4":
                rating = "2 Stars"
            elif rating == "st_r5":
                rating = "2.5 Stars"
            elif rating == "st_r6":
                rating = "3 Stars"
            elif rating == "st_r7":
                rating = "4 Stars"
            elif rating == "st_r8":
                rating = "4.5 Stars"
            elif rating == "st_r9":
                rating = "5 Stars"


        # Find Date
        i = string.find(source, ">Release Date<")

        if (i != -1):
            source = searchForPlus(source, ">Release Date<")
            source = searchForPlus(source, "class=\"sub-text\"")
            source = searchForPlus(source, "\">")
            i = string.find(source, "<")
            date = stripText(source[0:i])

            if fullDateFormat == "false":
                i = string.rfind(date, " ")

                if i != -1:
                    date = stripText(date[i+1:])

            copyDate = date


        # Find Label
        i = string.find(source, ">Label<")

        if (i != -1):
            source = searchForPlus(source, ">Label<")
            source = searchForPlus(source, "class=\"sub-text\"")
            source = searchForPlus(source, "\">")
            i = string.find(source, "<")
            label = stripText(source[0:i])


        # Find Running Time
        i = string.find(source, ">Time<")

        if (i != -1):
            source = searchForPlus(source, ">Time<")
            source = searchForPlus(source, "class=\"sub-text\"")
            source = searchForPlus(source, "\">")
            i = string.find(source, "<")
            running = stripText(source[0:i])


        # Find Category
        i = string.find(source, ">Genre<")

        if (i != -1):
            source = searchForPlus(source, ">Genre<")
            source = searchForPlus(source, "class=\"list-cell\"")
            source = searchForPlus(source, "<li>")
            source = searchForPlus(source, "\">")
            i = string.find(source, "<")
            category = stripText(source[0:i])


        # Find Keywords (Styes)
        i = string.find(source, "<!--Styles Listing-->")
        print "I=",i

        if i != -1:
            keywords = ""
            temp = searchForPlus(source, "<!--Styles Listing-->")
            i = string.find(temp, "<!--End Genre/Styles-->")
            temp = stripText(temp[0:i])

            while (searchFor(temp, "<a href=\"") != None):
                temp = searchForPlus(temp, "<a href=\"")
                temp = searchForPlus(temp, "\">")
                i = string.find(temp, "<")

                if keywords == "":
                    keywords = stripText(temp[0:i])
                else:
                    keywords = keywords + ", " + stripText(temp[0:i])


    # Find Comments
    i = string.find(source, "class=\"title\">Review<")

    if (i != -1):
        comments = "Review"
        source = searchForPlus(source, "class=\"title\">Review<")
        i = string.find(source, "</td></tr></table>")
        tempcomment = source[0:i]

        i = string.find(tempcomment, "class=\"author\"")

        if i != -1:
            tempcomment = searchForPlus(tempcomment, "class=\"author\"")   
            tempcomment = searchForPlus(tempcomment, ">")   
            i = string.find(tempcomment, "<")
            comments = comments + " " + stripText(tempcomment[0:i])
            comments = string.replace(comments, "  ", " ")

        i = string.find(tempcomment, ">Read More...<")

        if i != -1:
            tempcomment = searchForPlus(tempcomment, "... <a href=\"")   
            i = string.find(tempcomment, "\">")
            tempcomment = "http://www.allmusic.com" + tempcomment[0:i]
            http = HTTPConnection()
            http.resetReferer();
            http.blockForLoad();
            tempcomment = http.getContents(tempcomment)
            tempcomment = searchForPlus(tempcomment, "class=\"title\">Review<")
            i = string.find(tempcomment, "</td></tr></table>")
            tempcomment = tempcomment[0:i]

            i = string.find(tempcomment, "class=\"author\"")

            if i != -1:
                tempcomment = searchForPlus(tempcomment, "class=\"author\"")   
                tempcomment = searchForPlus(tempcomment, ">")   
            

        tempcomment = searchForPlus(tempcomment, "<td ")   
        tempcomment = searchForPlus(tempcomment, "\">")   

        tempcomment = string.replace(tempcomment, "</a>", "")
        tempcomment = string.replace(tempcomment, "</A>", "")
        tempcomment = string.replace(tempcomment, "<p>", "\n\n")
        tempcomment = string.replace(tempcomment, "<P>", "\n\n")
        tempcomment = string.replace(tempcomment, "</p>", "")
        tempcomment = string.replace(tempcomment, "<BR>", "\n")
        tempcomment = string.replace(tempcomment, "<br>", "\n")
        tempcomment = string.replace(tempcomment, "<br />", "\n")
        tempcomment = string.replace(tempcomment, "<i>", "")
        tempcomment = string.replace(tempcomment, "</i>", "")
        tempcomment = string.replace(tempcomment, "<I>", "")
        tempcomment = string.replace(tempcomment, "</I>", "")
        tempcomment = string.replace(tempcomment, "<b>", "")
        tempcomment = string.replace(tempcomment, "</b>", "")
        tempcomment = string.replace(tempcomment, "</font>", "")
        tempcomment = string.replace(tempcomment, "</span>", "")
        tempcomment = string.replace(tempcomment, "&copy;", "")
        tempcomment = string.replace(tempcomment, "&#169;", "")
        tempcomment = string.replace(tempcomment, "&#8217;", "'")
        tempcomment = string.replace(tempcomment, "&quot;", "\"")
        tempcomment = string.replace(tempcomment, "&#8211;", "-")

        while (searchFor(tempcomment, "<a ") != None):
            i = string.find(tempcomment, "<a ")
            j = string.find(tempcomment[i:], ">")
            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        while (searchFor(tempcomment, "<A ") != None):
            i = string.find(tempcomment, "<A ")
            j = string.find(tempcomment[i:], ">")
            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        while (searchFor(tempcomment, "<img src") != None):
            i = string.find(tempcomment, "<img src")
            j = string.find(tempcomment[i:], ">")
            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        while (searchFor(tempcomment, "<span") != None):
            i = string.find(tempcomment, "<span")
            j = string.find(tempcomment[i:], ">")
            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        while (searchFor(tempcomment, "<font color=") != None):
            i = string.find(tempcomment, "<font color=")
            j = string.find(tempcomment[i:], ">")
            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        comments = comments + "\n\n" + stripText(tempcomment)



    # Find Tracks
    i = string.find(source, ">Tracks<")

    if i != -1:
        trackList = []
        artistList = []
        writerList = []
        timeList = []
        pcol = 0
        wcol = 0

        source = searchForPlus(source, ">Tracks<")

        i = string.find(source, "class=\"passive\">Performer")

        if i != -1:
            pcol = 1

        i = string.find(source, "class=\"passive\">Composer")

        if i != -1:
            wcol = 1

        source = searchForPlus(source, "class=\"cell-img\"")
        i = string.find(source, "<!--Begin Icon Key-->")

        if i == -1:
            i = string.find(source, ">Releases<")

        tracks = stripText(source[0:i])

        while (searchFor(tracks, "class=\"cell\"") != None):
            tracks = searchForPlus(tracks, "class=\"cell\"")
            tracks = searchForPlus(tracks, ">")
            i = string.find(tracks, "<")
            trackIndex = stripText(tracks[0:i])
            trackid = "%02d" % trackIndex

            tracks = searchForPlus(tracks, "class=\"cell\"")
            tracks = searchForPlus(tracks, "\">")
            i = string.find(tracks, "</TD>")
            track = stripText(tracks[0:i])

            while (searchFor(track, "<a ") != None):
                i = string.find(track, "<a ")
                j = string.find(track[i:], ">")
                track = track[0:i] + track[i+j+1:]

            track = string.replace(track, "</a>", "")

            while (searchFor(track, "<span ") != None):
                i = string.find(track, "<span ")
                j = string.find(track[i:], ">")
                track = track[0:i] + track[i+j+1:]

            track = string.replace(track, "</span>", "")

            track = string.replace(track, "[*]", "")

            trackList.append("01-" + trackid + "-" + stripText(track))

            if pcol == 1:
                tracks = searchForPlus(tracks, "class=\"cell\"")
                tracks = searchForPlus(tracks, ">")
                i = string.find(tracks, "</TD>")
                trackArtist = stripText(tracks[0:i])

                i = string.find(trackArtist, ")\">")

                if i != -1:
                    trackArtist = searchForPlus(trackArtist, ")\">")
                    i = string.find(trackArtist, "<")
                    trackArtist = stripText(trackArtist[0:i])

                i = string.find(trackArtist, "\">")

                if i != -1:
                    trackArtist = searchForPlus(trackArtist, "\">")
                    i = string.find(trackArtist, "<")
                    trackArtist = stripText(trackArtist[0:i])

                artistList.append("01-" + trackid + "-" + trackArtist)
            else:
                artistList.append("01-" + trackid + "-")


            if wcol == 1:
                tracks = searchForPlus(tracks, "class=\"cell\"")
                tracks = searchForPlus(tracks, ">")
                i = string.find(tracks, "</TD>")
                writer = stripText(tracks[0:i])
                writerList.append("01-" + trackid + "-" + writer)
            else:
                writerList.append("01-" + trackid + "-")

            tracks = searchForPlus(tracks, "class=\"cell\"")
            tracks = searchForPlus(tracks, ">")
            i = string.find(tracks, "</TD>")
            tracktime = stripText(tracks[0:i])
            timeList.append("01-" + trackid + "-" + tracktime)


        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)
        writerList.sort()
        trackWriters = array(writerList, String)
        timeList.sort()
        trackTimes = array(timeList, String)



    # Find Copyright Date
    i = string.find(source, "Name=\"RLS\"")

    if (i != -1):
        source = searchForPlus(source, "Name=\"RLS\"")
        source = searchForPlus(source, "WIDTH=71>")
        i = string.find(source, "<")
        copyDate = stripText(source[0:i])



try:
    extract()
finally:
    if os.path.exists("scrapers/awuserexit.py"):
        execfile("scrapers/awuserexit.py") in globals()
