# All Music Guide Classical music scrpaer
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    sound               = "Stereo"
    format              = "CD"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    artistLF            = ""


    i = string.find(source, "Name=\"PERFS\"")

    if i == -1:
        return


    # Find marketplace pricing
    marketinfo = source



    # Main Extraction
    # Find Title
    source = searchForPlus(source, "tbr.gif")
    source = searchForPlus(source, "<B>")
    i = string.find(source, "<")
    title = stripText(source[0:i])


    # Find Artist
    i = string.find(source, ">Artist")

    if (i != -1):
        source = searchForPlus(source, ">Artist")
        source = searchForPlus(source, "HREF")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        artist = stripText(source[0:i])


    # Find Label
    i = string.find(source, ">Catalog")

    if (i != -1):
        source = searchForPlus(source, ">Catalog")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        label = stripText(source[0:i])

        i = string.find(label, ":")

        if (i != -1):
            label = stripText(label[0:i])


    # Find Time
    i = string.find(source, ">Time")

    if (i != -1):
        source = searchForPlus(source, ">Time")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        running = stripText(source[0:i])


    # Find Date
    i = string.find(source, ">Date")

    if (i != -1):
        source = searchForPlus(source, ">Date")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        date = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, " ")

            if i != -1:
                date = stripText(date[i+1:])


    # Find Image
    i = string.find(source, "image.allmusic.com")

    if (i != -1):
        source = source[i-25:]
        source = searchForPlus(source, " src=\"")
        i = string.find(source, "\"")
        image = stripText(source[0:i])

        i = string.find(image, ">")

        if (i != -1):
            image = stripText(image[0:i])


    # Find Rating
    i = string.find(source, ">AMG Rating")

    if (i != -1):
        source = searchForPlus(source, ">AMG Rating")
        source = searchForPlus(source, "<img src=/img/")
        i = string.find(source, ".")
        rating = stripText(source[0:i])

        if rating == "st_r3":
            rating = "1.5 Stars"
        elif rating == "st_r4":
            rating = "2 Stars"
        elif rating == "st_r5":
            rating = "2.5 Stars"
        elif rating == "st_r6":
            rating = "3 Stars"
        elif rating == "st_r7":
            rating = "4 Stars"
        elif rating == "st_r8":
            rating = "4.5 Stars"
        elif rating == "st_r9":
            rating = "5 Stars"


    # Find Category
    i = string.find(source, ">Genre")

    if (i != -1):
        source = searchForPlus(source, ">Genre")
        source = searchForPlus(source, "HREF")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        category = stripText(source[0:i])


    # Find Comments
    i = string.find(source, "hspace=10>")

    if (i != -1):
        comments = ""
        source = searchForPlus(source, "hspace=10>")
        i = string.find(source, "</td></tr></table>")
        tempcomment = source[0:i]
        tempcomment = string.replace(tempcomment, "</a>", "")
        tempcomment = string.replace(tempcomment, "</A>", "")
        tempcomment = string.replace(tempcomment, "<p>", "\n\n")
        tempcomment = string.replace(tempcomment, "<P>", "\n\n")
        tempcomment = string.replace(tempcomment, "<BR>", "\n")
        tempcomment = string.replace(tempcomment, "<br>", "\n")
        tempcomment = string.replace(tempcomment, "<i>", "")
        tempcomment = string.replace(tempcomment, "</i>", "")
        tempcomment = string.replace(tempcomment, "<I>", "")
        tempcomment = string.replace(tempcomment, "</I>", "")
        tempcomment = string.replace(tempcomment, "<b>", "")
        tempcomment = string.replace(tempcomment, "</b>", "")
        tempcomment = string.replace(tempcomment, "</font>", "")
        tempcomment = string.replace(tempcomment, "</span>", "")
        tempcomment = string.replace(tempcomment, "&copy;", "")
        tempcomment = string.replace(tempcomment, "&#169;", "")
        tempcomment = string.replace(tempcomment, "&#8217;", "'")
        tempcomment = string.replace(tempcomment, "&quot;", "\"")
        tempcomment = string.replace(tempcomment, "&#8211;", "-")

        while (searchFor(tempcomment, "<a ") != None):
            i = string.find(tempcomment, "<a ")
            j = string.find(tempcomment[i:], ">")
            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        while (searchFor(tempcomment, "<A ") != None):
            i = string.find(tempcomment, "<A ")
            j = string.find(tempcomment[i:], ">")
            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        while (searchFor(tempcomment, "<img src") != None):
            i = string.find(tempcomment, "<img src")
            j = string.find(tempcomment[i:], ">")
            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        while (searchFor(tempcomment, "<span") != None):
            i = string.find(tempcomment, "<span")
            j = string.find(tempcomment[i:], ">")
            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        while (searchFor(tempcomment, "<font color=") != None):
            i = string.find(tempcomment, "<font color=")
            j = string.find(tempcomment[i:], ">")
            tempcomment = tempcomment[0:i] + tempcomment[i+j+1:]

        comments = tempcomment



    # Find Tracks
    i = string.find(source, "Name=\"PERFS\"")

    if i != -1:
        trackList = []
        artistList = []
        writerList = []
        timeList = []

        source = searchForPlus(source, "Name=\"PERFS\"")
        i = string.find(source, "</tr></Table>")
        tracks = stripText(source[0:i+6])
        trackIndex = 1

        while (searchFor(tracks, "<td width=125") != None):
            trackid = "%02d" % trackIndex

            tracks = searchForPlus(tracks, "<td width=125")
            i = string.find(tracks, "</font></td></tr>")
            trackdata = stripText(tracks[0:i+1])

            trackdata = searchForPlus(trackdata, "\">")

            if trackdata == None:
                break

            i = string.find(trackdata, "</font>")
            trackWriter = stripText(trackdata[0:i])

            if trackWriter[0:1] == "<":
                trackWriter = searchForPlus(trackWriter, ">")
                i = string.find(trackWriter, "<")
                trackWriter = stripText(trackWriter[0:i])

            trackdata = searchForPlus(trackdata, "</font>")
            trackdata = searchForPlus(trackdata, "HREF")
            trackdata = searchForPlus(trackdata, ">")
            i = string.find(trackdata, "<")
            track = stripText(trackdata[0:i])

            trackdata = searchForPlus(trackdata, "width=35")
            trackdata = searchForPlus(trackdata, "\">")
            i = string.find(trackdata, "<")
            trackTime = stripText(trackdata[0:i])

            writerList.append("01-" + trackid + "-" + trackWriter)
            timeList.append("01-" + trackid + "-" + trackTime)
            trackList.append("01-" + trackid + "-" + track)
            artistList.append("01-" + trackid + "-")

            trackIndex = trackIndex + 1

        trackList.sort()
        trackTitles = array(trackList, String)
        artistList.sort()
        trackArtists = array(artistList, String)
        writerList.sort()
        trackWriters = array(writerList, String)
        timeList.sort()
        trackTimes = array(timeList, String)



try:
    extract()
finally:
    if os.path.exists("scrapers/awuserexit.py"):
        execfile("scrapers/awuserexit.py") in globals()
