# Abby Road scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripHTML
from    jarray import zeros, array
from    java.lang import String


def extract():
    global title,artist,label,composer,date,copyDate,running,artistLF
    global value,valueDate,copies,upc,isbn,lccn,dewey,userNumber
    global format,series,sound,rating,condition,category
    global location,keywords,played,pflag,eflag,comments
    global dateEntered,dataSource,cart,ordered
    global diskCount,artistURL,conductor
    global trackTitles,trackArtists,trackWriters,trackTimes
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,salesrank,available
    global buyerwaiting,editionNumber,image,fullDateFormat,source


    # Defaults
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    sound               = "Stereo"
    format              = "CD"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    salesrank           = ""
    artistLF            = ""

    available           = "Y"
    buyerwaiting        = "N"
    switchArtist        = "N"


    # Find optional fields, pricing info etc.
    marketinfo = source

    # Find List price
    i = string.find(marketinfo, ">Price<")

    if (i != -1):
        listprice = searchForPlus(marketinfo, ">Price<")

        i = string.find(marketinfo, "<STRIKE>")

        if (i != -1):
            listprice = searchForPlus(marketinfo, "<STRIKE>")
            listprice = searchFor(listprice, "$")
            i = string.find(listprice, "<")
            listprice = stripText(listprice[0:i])


    # Main extraction
    # Find Artist
    source = searchForPlus(source, "<!-- artist_music_item -->")
    source = searchForPlus(source, "SIZE=\"+2\"")
    source = searchForPlus(source, "<I>")
    i = string.find(source, ":")
    artist = stripHTML(source[0:i])

    if switchArtist == "Y":
        i = string.rfind(artist, ",")

        if (i != -1):
            artist = stripText(artist[0:i] + ", " + stripText(artist[i+1:]))


    # Find Title
    source = searchForPlus(source, ":")
    i = string.find(source, "<")
    title = stripHTML(source[0:i])


    # Find Format
    i = string.find(source, "SIZE=\"-2\">")

    if i != -1:
        source = searchForPlus(source, "SIZE=\"-2\">")
        source = searchForPlus(source, "(")
        i = string.find(source, ")")
        format = stripText(source[0:i])


    # Find Image
    i = string.find(source, "img.cgi")

    if i != -1:
        source = searchForPlus(source, "img.cgi")
        source = searchForPlus(source, " SRC=\"")
        i = string.find(source, "\"")
        image = stripHTML(source[0:i])


    # Find Category
    i = string.find(source, ">Genre<")

    if i != -1:
        source = searchForPlus(source, ">Genre<")
        source = searchForPlus(source, "a=browse")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        category = stripText(source[0:i])


    # Find Release date
    i = string.find(source, ">Release<")

    if i != -1:
        source = searchForPlus(source, ">Release<")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        date = stripText(source[0:i])


    # Find Label
    i = string.find(source, ">Vendor<")

    if i != -1:
        source = searchForPlus(source, ">Vendor<")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        label = stripText(source[0:i])


    # Find Price
    i = string.find(source, ">Price<")

    if i != -1:
        source = searchForPlus(source, ">Price<")
        source = searchForPlus(source, "#FF0000")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        value = stripText(source[0:i])




    # Find Tracks
    i = string.find(source, ">Track Listing<")

    if (i != -1):
        source = searchForPlus(source, ">Track Listing<")
        source = searchForPlus(source, "<TABLE")
        source = searchForPlus(source, ">Song Title<")
        i = string.find(source, "</TABLE>")
        disks = source[0:i]

        if string.find(disks, ">Disk 1:<") == -1:
            disks = ">Disk 1:<" + disks

        trackList = []
        artistList = []
        diskCount = 0

        while (searchFor(disks, ">Disk ") != None):
            diskCount = diskCount + 1
            disks = searchForPlus(disks, ">Disk ")
            i = string.find(disks, ":")
            diskid = "%02d" % stripText(disks[0:i])

            i = string.find(disks, ">Disk ")

            if i != -1:
                tracks = stripText(disks[0:i])
            else:
                tracks = disks

            trackIndex = 0

            while (searchFor(tracks, "<TD><FONT") != None):
                tracks = searchForPlus(tracks, "<TD><FONT")
                tracks = searchForPlus(tracks, "2\">")
                i = string.find(tracks, "<")
                trackIndex = trackIndex + 1
                trackNum = "%02d" % trackIndex
                i = string.find(tracks, "<")
                track = stripText(tracks[0:i])
                trackList.append(diskid + "-" + trackNum + "-" + track)

                tracks = searchForPlus(tracks, "<I>")
                i = string.find(tracks, "<")
                track = stripText(tracks[0:i])
                artistList.append(diskid + "-" + trackNum + "-" + track)

        trackTitles = array(trackList, String)
        trackArtists = array(artistList, String)


    # Find Running time
    i = string.find(source, "RUNNING TIME:")

    if i != -1:
        source = searchForPlus(source, "RUNNING TIME:")
        i = string.find(source, "<")
        running = stripText(source[0:i])


try:
    extract()
finally:
    if os.path.exists("scrapers/awuserexit.py"):
        execfile("scrapers/awuserexit.py") in globals()
