# Alibris scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    com.readerware.http import HTTPConnection

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText
from    scrapers.scrapers import stripHTML


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""

    # No place extraction default to US
    # place = "United States"


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Get detail page if necessary
    i = string.find(source, "<!--ITEM START-->")

    if i != -1:
        source = searchForPlus(source, "<!--ITEM START-->")
        source = searchForPlus(source, "<a href=\"")
        i = string.find(source, "\"")
        url = "http://www.alibris.com" + stripText(source[0:i])
        http = HTTPConnection()
        http.resetReferer();
        http.blockForLoad();
        source = http.getContents(url)

    i = string.find(source, "<!--ITEM START-->")

    if i != -1:
        source = searchForPlus(source, "<!--ITEM START-->")
        source = searchForPlus(source, "<a href=\"")
        i = string.find(source, "\"")
        url = "http://www.alibris.com" + stripText(source[0:i])
        http = HTTPConnection()
        http.resetReferer();
        http.blockForLoad();
        source = http.getContents(url)

    i = string.find(source, "&bid=")

    if i != -1:
        source = source[i-150:]
        source = searchForPlus(source, "<a href=\"")
        i = string.find(source, "\"")
        url = "http://www.alibris.com" + stripText(source[0:i])
        http = HTTPConnection()
        http.resetReferer();
        http.blockForLoad();
        source = http.getContents(url)



    # Main extraction
    # Find Image
    i = string.find(source, "images.alibris.com")

    if i != -1:
        image = source[i-50:]
        image = searchForPlus(image, "<img src=\"")
        i = string.find(image, "\"")
        image = stripText(image[0:i])


    # Find price
    i = string.find(source, ">price:<")

    if i != -1:
        value = searchForPlus(source, ">price:<")
        value = searchFor(value, "$")
        i = string.find(value, "<")
        value = stripText(value[0:i])

    source = searchForPlus(source, "\"author-title\"")


    # Find Title
    source = searchForPlus(source, "<h2>")
    i = string.find(source, "<")
    title = stripText(source[0:i])

    if title[len(title)-1:] == ".":
        title = stripText(title[0:len(title)-1])


    # Find Author
    holdsource = source
    try:
        source = searchForPlus(source, "<p>")
        source = searchForPlus(source, "by")
        i = string.find(source, "</p>")
        author = stripText(source[0:i])
        i = string.find(author, "href=\"")

        if i != -1:
            author = searchForPlus(author, "href=\"")
            author = searchForPlus(author, "\">")
            i = string.find(author, "<")
            author = stripText(author[0:i])

        author = string.replace(author, "\"", "")

        if author[len(author)-1:] == ",":
            author = stripText(author[0:len(author)-1])

        if author[len(author)-1:] == ".":
            author = stripText(author[0:len(author)-1])
    except:
        if title != "":
            author = "No Author"
            source = holdsource


    # Find Format
    i = string.find(source, ">Binding:<")

    if i != -1:
        format = searchForPlus(source, ">Binding:<")
        format = searchForPlus(format, ">")
        i = string.find(format, "<")
        format = stripText(format[0:i])


    # Find Publisher
    i = string.find(source, ">Publisher:<")

    if i != -1:
        publisher = searchForPlus(source, ">Publisher:<")
        publisher = searchForPlus(publisher, ">")
        i = string.find(publisher, "<")
        publisher = stripText(publisher[0:i])


    # Find Published date
    i = string.find(source, ">Date Published:<")

    if i != -1:
        date = searchForPlus(source, ">Date Published:<")
        date = searchForPlus(date, ">")
        i = string.find(date, "<")
        date = stripText(date[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, " ")

            if i != -1:
                date = stripText(date[i+1:])

            i = string.rfind(date, "/")

            if i != -1:
                date = stripText(date[i+1:])


    # Find ISBN
    i = string.find(source, ">ISBN:<")

    if i != -1:
        isbn = searchForPlus(source, ">ISBN:<")
        isbn = searchForPlus(isbn, "\">")
        i = string.find(isbn, "<")
        isbn = stripText(isbn[0:i])


    # Find Reviews (to comments)
    comments = ""

    source = searchForPlus(source, "<div>")
    source = searchForPlus(source, "<p>")
    i = string.find(source, "</p>\r")
    comments = stripText(source[0:i])

    if comments == "":
        i = string.find(source, ">Description:<")

        if i != -1:
            source = searchForPlus(source, ">Description:<")
            source = searchForPlus(source, ">")
            i = string.find(source, "</p>\r")
            comments = stripText(source[0:i])

    comments = string.replace(comments, "<strong>", "")
    comments = string.replace(comments, "</strong>", "")
    comments = string.replace(comments, "<div>", "")
    comments = string.replace(comments, "</div>", "")
    comments = string.replace(comments, "<i>", "")
    comments = string.replace(comments, "</i>", "")
    comments = string.replace(comments, "<I>", "")
    comments = string.replace(comments, "</I>", "")
    comments = string.replace(comments, "<b>", "")
    comments = string.replace(comments, "</b>", "")
    comments = string.replace(comments, "<B>", "")
    comments = string.replace(comments, "</B>", "")
    comments = string.replace(comments, "<BR>", "\n")
    comments = string.replace(comments, "<br />", "\n")
    comments = string.replace(comments, "<P>", "\n\n")
    comments = string.replace(comments, "<p>", "\n\n")

    while (searchFor(comments, "<a ") != None):
        i = string.find(comments, "<a ")
        j = string.find(comments[i:], "\">")
        comments = comments[0:i] + comments[i+j+2:]

    while (searchFor(comments, "\n ") != None):
        comments = string.replace(comments, "\n ", "\n")


    # Find Category
    i = string.find(source, ">Related subjects<")

    if i != -1:
        source = searchForPlus(source, ">Related subjects<")
        source = searchForPlus(source, "href=\"")
        source = searchForPlus(source, "\">")
        i = string.find(source, "<")
        category = stripText(source[0:i])



try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
