# alapage.com[fr] scraper
#
# Copyright  1999-2007 Readerware Corporation.  All Rights Reserved.

import  os
import  string

from    scrapers.scrapers import searchFor
from    scrapers.scrapers import searchForPlus
from    scrapers.scrapers import stripText


def extract():
    global title,author,isbn,publisher,format,first,signed,date,place
    global copies,rating,condition,category,read,pflag,eflag,value
    global comments,dateEntered,dataSource,cart,ordered
    global lccn,dewey,userNumber,copyDate,valueDate,location
    global series,pages,keywords,dimensions
    global user1,user2,user3,user4,user5,user6,user7,user8,user9,user10
    global author2,author3,author4,author5,author6
    global usedprice,usedcount,collectibleprice,collectiblecount
    global newprice,newcount,listprice,readinglevel,salesrank,available
    global buyerwaiting,editionNumber,weight,image
    global fullDateFormat,source


    # Defaults
    first               = "N"
    signed              = "N"
    read                = "N"
    pflag               = "Y"
    eflag               = "Y"
    ordered             = "N"
    usedprice           = ""
    usedcount           = ""
    collectibleprice    = ""
    collectiblecount    = ""
    newprice            = ""
    newcount            = ""
    listprice           = ""
    readinglevel        = ""
    salesrank           = ""
    available           = "Y"
    buyerwaiting        = "N"
    weight              = ""

    # No place extraction default to France
    # place = "France"


    # Find optional fields, pricing info etc.
    marketinfo = source


    # Main extraction
    # Find Image
    source = searchForPlus(source, "<!-- FICHE PRODUIT -->")
    i = string.find(source, "http://imgdata.echo.fr")

    if (i != -1):
        source = searchForPlus(source, "http://imgdata.echo.fr")
        i = string.find(source, "\">")
        image = stripText(source[0:i])


    # Find Title
    source = searchForPlus(source, "<td width=100% align=\"center\">")
    source = searchForPlus(source, "face=")
    source = searchForPlus(source, "<b>")
    i = string.find(source, "<")
    title = stripText(source[0:i])
    i = string.find(title, ":")

    if (i != -1):
        title = stripText(title[0:i])


    # Find Author
    source = searchForPlus(source, "auteur=")
    i = string.find(source, "&")
    tempValue = stripText(source[0:i])
    i = string.find(tempValue, "+")

    authorlast = stripText(tempValue[0:i])
    authorfirst = stripText(tempValue[i+1:])

    if (authorfirst == ""):
        author = authorlast
    else:
        author = stripText(authorlast) + ", " + stripText(authorfirst)

    i = string.find(author, "+")

    while (i != -1):
        author = author[0:i] + " " + author[i+1:]
        i = string.find(author, "+")



    # Find Publisher
    source = searchForPlus(source, ">Editeur<")
    source = searchForPlus(source, "size=")
    source = searchForPlus(source, ">")
    i = string.find(source, "<")
    publisher = stripText(source[0:i])

    if (publisher[0:1] == ":"):
        publisher = stripText(publisher[1:])


    # Find category
    i = string.find(source, ">Collection<")

    if (i != -1):
        source = searchForPlus(source, ">Collection<")
        source = searchForPlus(source, "size=")
        source = searchForPlus(source, ">")
        i = string.find(source, "<")
        category = stripText(source[0:i])
    else:
        i = string.find(source, "<b>Genre</b>")

        if (i != -1):
            source = searchForPlus(source, "<b>Genre</b>")
            source = searchForPlus(source, "size=")
            source = searchForPlus(source, ">")
            i = string.find(source, "<")
            category = stripText(source[0:i])

    if (category[0:1] == ":"):
        category = stripText(category[1:])


    # Find value
    source = searchForPlus(source, "Prix alapage.com")
    source = searchForPlus(source, "size=")
    source = searchForPlus(source, "<b>")
    i = string.find(source, "<")
    value = stripText(source[0:i])

    i = string.find(value, "/")

    if (i != -1):
        value = stripText(value[i+1:])


    # Find ISBN
    source = searchForPlus(source, ">ISBN<")
    source = searchForPlus(source, " : ")
    i = string.find(source, "<")
    isbn = stripText(source[0:i])


    # Find Publication date
    i = string.find(source, ">Paru en<")

    if (i != -1):
        source = searchForPlus(source, ">Paru en<")
        source = searchForPlus(source, " : ")
        i = string.find(source, "<")
        date = stripText(source[0:i])

        if fullDateFormat == "false":
            i = string.rfind(date, " ")

            if i != -1:
                date = stripText(date[i+1:])



try:
    extract()
finally:
    if os.path.exists("scrapers/userexit.py"):
        execfile("scrapers/userexit.py") in globals()
