/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.python.core.Py;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;

public class PyLong
extends PyObject {
    private static final BigInteger minLong = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger maxLong = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger minDouble = new BigDecimal(Double.MIN_VALUE).toBigInteger();
    private static final BigInteger maxDouble = new BigDecimal(Double.MAX_VALUE).toBigInteger();
    private BigInteger value;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Object;

    public PyLong(BigInteger bigInteger) {
        this.value = bigInteger;
    }

    public PyLong(double d) {
        this(new BigDecimal(d).toBigInteger());
    }

    public PyLong(long l) {
        this(BigInteger.valueOf(l));
    }

    public PyLong(String string) {
        this(new BigInteger(string));
    }

    public String toString() {
        return this.value.toString() + "L";
    }

    public int hashCode() {
        return this.value.intValue();
    }

    public boolean __nonzero__() {
        return !this.value.equals(BigInteger.valueOf(0L));
    }

    public double doubleValue() {
        double d = this.value.doubleValue();
        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
            throw Py.OverflowError("long int too long to convert");
        }
        return d;
    }

    private long getLong(long l, long l2) {
        long l3;
        if (this.value.compareTo(maxLong) <= 0 && this.value.compareTo(minLong) >= 0 && (l3 = this.value.longValue()) >= l && l3 <= l2) {
            return l3;
        }
        throw Py.OverflowError("long int too long to convert");
    }

    public Object __tojava__(Class clazz) {
        try {
            if (clazz == Byte.TYPE || clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = PyLong.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                return new Byte((byte)this.getLong(-128L, 127L));
            }
            if (clazz == Short.TYPE || clazz == (class$java$lang$Short == null ? (class$java$lang$Short = PyLong.class$("java.lang.Short")) : class$java$lang$Short)) {
                return new Short((short)this.getLong(-32768L, 32767L));
            }
            if (clazz == Integer.TYPE || clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = PyLong.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return new Integer((int)this.getLong(Integer.MIN_VALUE, Integer.MAX_VALUE));
            }
            if (clazz == Long.TYPE || clazz == (class$java$lang$Long == null ? (class$java$lang$Long = PyLong.class$("java.lang.Long")) : class$java$lang$Long)) {
                return new Long(this.getLong(Long.MIN_VALUE, Long.MAX_VALUE));
            }
            if (clazz == Float.TYPE || clazz == Double.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = PyLong.class$("java.lang.Float")) : class$java$lang$Float) || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = PyLong.class$("java.lang.Double")) : class$java$lang$Double)) {
                return this.__float__().__tojava__(clazz);
            }
            if (clazz == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = PyLong.class$("java.math.BigInteger")) : class$java$math$BigInteger) || clazz == (class$java$lang$Number == null ? (class$java$lang$Number = PyLong.class$("java.lang.Number")) : class$java$lang$Number) || clazz == (class$java$lang$Object == null ? (class$java$lang$Object = PyLong.class$("java.lang.Object")) : class$java$lang$Object)) {
                return this.value;
            }
        }
        catch (PyException pyException) {
            return Py.NoConversion;
        }
        return super.__tojava__(clazz);
    }

    public int __cmp__(PyObject pyObject) {
        return this.value.compareTo(((PyLong)pyObject).value);
    }

    public Object __coerce_ex__(PyObject pyObject) {
        if (pyObject instanceof PyLong) {
            return pyObject;
        }
        if (pyObject instanceof PyInteger) {
            return new PyLong(((PyInteger)pyObject).getValue());
        }
        return Py.None;
    }

    public PyObject __add__(PyObject pyObject) {
        return new PyLong(this.value.add(((PyLong)pyObject).value));
    }

    public PyObject __sub__(PyObject pyObject) {
        return new PyLong(this.value.subtract(((PyLong)pyObject).value));
    }

    public PyObject __mul__(PyObject pyObject) {
        return new PyLong(this.value.multiply(((PyLong)pyObject).value));
    }

    private BigInteger divide(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = BigInteger.valueOf(0L);
        if (bigInteger2.equals(bigInteger3)) {
            throw Py.ZeroDivisionError("long division or modulo");
        }
        if (bigInteger2.compareTo(bigInteger3) < 0) {
            if (bigInteger.compareTo(bigInteger3) > 0) {
                return bigInteger.subtract(bigInteger2).subtract(BigInteger.valueOf(1L)).divide(bigInteger2);
            }
        } else if (bigInteger.compareTo(bigInteger3) < 0) {
            return bigInteger.subtract(bigInteger2).add(BigInteger.valueOf(1L)).divide(bigInteger2);
        }
        return bigInteger.divide(bigInteger2);
    }

    public PyObject __div__(PyObject pyObject) {
        return new PyLong(this.divide(this.value, ((PyLong)pyObject).value));
    }

    private BigInteger modulo(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        return bigInteger.subtract(bigInteger3.multiply(bigInteger2));
    }

    public PyObject __mod__(PyObject pyObject) {
        BigInteger bigInteger = ((PyLong)pyObject).value;
        return new PyLong(this.modulo(this.value, bigInteger, this.divide(this.value, bigInteger)));
    }

    public PyObject __divmod__(PyObject pyObject) {
        BigInteger bigInteger = ((PyLong)pyObject).value;
        BigInteger bigInteger2 = this.divide(this.value, bigInteger);
        return new PyTuple(new PyObject[]{new PyLong(bigInteger2), new PyLong(this.modulo(this.value, bigInteger, bigInteger2))});
    }

    public PyObject __pow__(PyObject pyObject, PyObject pyObject2) {
        BigInteger bigInteger = ((PyLong)pyObject).value;
        if (bigInteger.compareTo(BigInteger.valueOf(0L)) < 0) {
            if (this.value.compareTo(BigInteger.valueOf(0L)) != 0) {
                throw Py.ValueError("long integer to a negative power");
            }
            throw Py.ZeroDivisionError("zero to a negative power");
        }
        if (pyObject2 == null) {
            return new PyLong(this.value.pow(bigInteger.intValue()));
        }
        BigInteger bigInteger2 = ((PyLong)pyObject2).value;
        int n = bigInteger2.intValue();
        if (n == 0) {
            throw Py.ValueError("pow(x, y, z) with z == 0");
        }
        if (n == 1 || n == -1) {
            return new PyLong(0L);
        }
        if (bigInteger2.compareTo(BigInteger.valueOf(0L)) <= 0) {
            if ((bigInteger = this.value.modPow(bigInteger, bigInteger2.negate())).compareTo(BigInteger.valueOf(0L)) > 0) {
                return new PyLong(bigInteger2.add(bigInteger));
            }
            return new PyLong(bigInteger);
        }
        return new PyLong(this.value.modPow(bigInteger, bigInteger2));
    }

    public PyObject __lshift__(PyObject pyObject) {
        return new PyLong(this.value.shiftLeft(((PyLong)pyObject).value.intValue()));
    }

    public PyObject __rshift__(PyObject pyObject) {
        return new PyLong(this.value.shiftRight(((PyLong)pyObject).value.intValue()));
    }

    public PyObject __and__(PyObject pyObject) {
        return new PyLong(this.value.and(((PyLong)pyObject).value));
    }

    public PyObject __xor__(PyObject pyObject) {
        return new PyLong(this.value.xor(((PyLong)pyObject).value));
    }

    public PyObject __or__(PyObject pyObject) {
        return new PyLong(this.value.or(((PyLong)pyObject).value));
    }

    public PyObject __neg__() {
        return new PyLong(this.value.negate());
    }

    public PyObject __pos__() {
        return this;
    }

    public PyObject __abs__() {
        return new PyLong(this.value.abs());
    }

    public PyObject __invert__() {
        return new PyLong(this.value.not());
    }

    public PyInteger __int__() {
        return new PyInteger((int)this.getLong(Integer.MIN_VALUE, Integer.MAX_VALUE));
    }

    public PyLong __long__() {
        return this;
    }

    public PyFloat __float__() {
        return new PyFloat(this.doubleValue());
    }

    public PyComplex __complex__() {
        return new PyComplex(this.doubleValue(), 0.0);
    }

    public PyString __oct__() {
        String string = this.value.toString(8);
        if (string.startsWith("-")) {
            return new PyString("-0" + string.substring(1, string.length()) + "L");
        }
        if (string.startsWith("0")) {
            return new PyString(string + "L");
        }
        return new PyString("0" + string + "L");
    }

    public PyString __hex__() {
        String string = this.value.toString(16).toUpperCase();
        if (string.startsWith("-")) {
            return new PyString("-0x" + string.substring(1, string.length()) + "L");
        }
        return new PyString("0x" + string + "L");
    }

    public PyString __str__() {
        return Py.newString(this.value.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

