/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyComplex;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyTuple;

public class PyFloat
extends PyObject {
    private double value;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Float;

    public PyFloat(double d) {
        this.value = d;
    }

    public PyFloat(float f) {
        this((double)f);
    }

    protected String safeRepr() {
        return "'float' object";
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        String string = Double.toString(this.value);
        if (string.indexOf(69) == -1) {
            int n;
            while ((n = string.length()) > 2 && string.charAt(n - 1) == '0' && string.charAt(n - 2) != '.') {
                string = string.substring(0, n - 1);
            }
        }
        return string;
    }

    public int hashCode() {
        double d = Math.floor(this.value);
        double d2 = this.value - d;
        if (d2 == 0.0) {
            if (d <= 2.147483647E9 && d >= -2.147483648E9) {
                return (int)this.value;
            }
            return this.__long__().hashCode();
        }
        long l = Double.doubleToLongBits(this.value);
        return (int)l ^ (int)(l >> 32);
    }

    public boolean __nonzero__() {
        return this.value != 0.0;
    }

    public Object __tojava__(Class clazz) {
        if (clazz == Double.TYPE || clazz == (class$java$lang$Number == null ? (class$java$lang$Number = PyFloat.class$("java.lang.Number")) : class$java$lang$Number) || clazz == (class$java$lang$Double == null ? (class$java$lang$Double = PyFloat.class$("java.lang.Double")) : class$java$lang$Double) || clazz == (class$java$lang$Object == null ? (class$java$lang$Object = PyFloat.class$("java.lang.Object")) : class$java$lang$Object)) {
            return new Double(this.value);
        }
        if (clazz == Float.TYPE || clazz == (class$java$lang$Float == null ? (class$java$lang$Float = PyFloat.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(this.value);
        }
        return super.__tojava__(clazz);
    }

    public int __cmp__(PyObject pyObject) {
        double d = ((PyFloat)pyObject).value;
        return this.value < d ? -1 : (this.value > d ? 1 : 0);
    }

    public Object __coerce_ex__(PyObject pyObject) {
        if (pyObject instanceof PyFloat) {
            return pyObject;
        }
        if (pyObject instanceof PyInteger) {
            return new PyFloat((double)((PyInteger)pyObject).getValue());
        }
        if (pyObject instanceof PyLong) {
            return new PyFloat(((PyLong)pyObject).doubleValue());
        }
        return Py.None;
    }

    public PyObject __add__(PyObject pyObject) {
        return new PyFloat(this.value + ((PyFloat)pyObject).value);
    }

    public PyObject __sub__(PyObject pyObject) {
        return new PyFloat(this.value - ((PyFloat)pyObject).value);
    }

    public PyObject __mul__(PyObject pyObject) {
        return new PyFloat(this.value * ((PyFloat)pyObject).value);
    }

    public PyObject __div__(PyObject pyObject) {
        double d = ((PyFloat)pyObject).value;
        if (d == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(this.value / d);
    }

    private double modulo(double d, double d2) {
        if (d2 == 0.0) {
            throw Py.ZeroDivisionError("float modulo");
        }
        double d3 = Math.IEEEremainder(d, d2);
        if (d3 * d2 < 0.0) {
            d3 += d2;
        }
        return d3;
    }

    public PyObject __mod__(PyObject pyObject) {
        return new PyFloat(this.modulo(this.value, ((PyFloat)pyObject).value));
    }

    public PyObject __divmod__(PyObject pyObject) {
        double d = ((PyFloat)pyObject).value;
        if (d == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        double d2 = Math.floor(this.value / d);
        return new PyTuple(new PyObject[]{new PyFloat(d2), new PyFloat(this.value - d2 * d)});
    }

    public PyObject __pow__(PyObject pyObject, PyObject pyObject2) {
        double d = ((PyFloat)pyObject).value;
        if (d == 0.0) {
            if (pyObject2 != null) {
                return new PyFloat(this.modulo(1.0, ((PyFloat)pyObject2).value));
            }
            return new PyFloat(1.0);
        }
        if (this.value == 0.0) {
            if (d < 0.0) {
                throw Py.ZeroDivisionError("0.0 cannot be raised to a negative power");
            }
            return new PyFloat(0.0f);
        }
        double d2 = Math.pow(this.value, d);
        if (pyObject2 == null) {
            return new PyFloat(d2);
        }
        return new PyFloat(this.modulo(d2, ((PyFloat)pyObject2).value));
    }

    public PyObject __neg__() {
        return new PyFloat(-this.value);
    }

    public PyObject __pos__() {
        return this;
    }

    public PyObject __abs__() {
        if (this.value >= 0.0) {
            return this;
        }
        return this.__neg__();
    }

    public PyInteger __int__() {
        if (this.value <= 2.147483647E9 && this.value >= -2.147483648E9) {
            return new PyInteger((int)this.value);
        }
        throw Py.OverflowError("float too large to convert");
    }

    public PyLong __long__() {
        return new PyLong(this.value);
    }

    public PyFloat __float__() {
        return this;
    }

    public PyComplex __complex__() {
        return new PyComplex(this.value, 0.0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

