/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.Chunk;
import com.sixlegs.image.png.ChunkHandler;
import com.sixlegs.image.png.Chunk_IDAT;
import com.sixlegs.image.png.Chunk_IEND;
import com.sixlegs.image.png.Chunk_IHDR;
import com.sixlegs.image.png.Chunk_PLTE;
import com.sixlegs.image.png.Chunk_tRNS;
import com.sixlegs.image.png.DummyImageConsumer;
import com.sixlegs.image.png.IDATInputStream;
import com.sixlegs.image.png.Interlacer;
import com.sixlegs.image.png.PixelInputStream;
import com.sixlegs.image.png.PngException;
import com.sixlegs.image.png.PngExceptionSoft;
import com.sixlegs.image.png.TextChunk;
import com.sixlegs.image.png.UnfilterInputStream;
import com.sixlegs.image.png.UserChunk;
import java.awt.Color;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class PngImage
implements ImageProducer {
    static boolean allFatal = false;
    static final int BUFFER_SIZE = 8192;
    private static boolean progressive = true;
    private static Hashtable prototypes = new Hashtable();
    static final String ASCII_ENCODING = "US-ASCII";
    static final String LATIN1_ENCODING = "8859_1";
    static final String UTF8_ENCODING = "UTF8";
    static final long DEFAULT_GAMMA = 45455L;
    private static double DISPLAY_EXPONENT = 2.2;
    private static double USER_EXPONENT = 1.0;
    public static final int COLOR_TYPE_GRAY = 0;
    public static final int COLOR_TYPE_GRAY_ALPHA = 4;
    public static final int COLOR_TYPE_PALETTE = 3;
    public static final int COLOR_TYPE_RGB = 2;
    public static final int COLOR_TYPE_RGB_ALPHA = 6;
    public static final int INTERLACE_TYPE_NONE = 0;
    public static final int INTERLACE_TYPE_ADAM7 = 1;
    public static final int FILTER_TYPE_BASE = 0;
    public static final int FILTER_TYPE_INTRAPIXEL = 64;
    public static final int COMPRESSION_TYPE_BASE = 0;
    public static final int UNIT_UNKNOWN = 0;
    public static final int UNIT_METER = 1;
    public static final int UNIT_PIXEL = 0;
    public static final int UNIT_MICROMETER = 1;
    public static final int UNIT_RADIAN = 2;
    public static final int SRGB_PERCEPTUAL = 0;
    public static final int SRGB_RELATIVE_COLORIMETRIC = 1;
    public static final int SRGB_SATURATION_PRESERVING = 2;
    public static final int SRGB_ABSOLUTE_COLORIMETRIC = 3;
    Data data;
    private Vector errorList;

    public void addConsumer(ImageConsumer imageConsumer) {
        if (this.data == null) {
            return;
        }
        if (this.data.consumers.contains(imageConsumer)) {
            return;
        }
        this.data.consumers.addElement(imageConsumer);
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        if (this.data == null) {
            return false;
        }
        return this.data.consumers.contains(imageConsumer);
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        if (this.data == null) {
            return;
        }
        this.data.consumers.removeElement(imageConsumer);
    }

    public void startProduction(ImageConsumer imageConsumer) {
        if (this.data == null) {
            throw new RuntimeException("Object has been flushed.");
        }
        this.addConsumer(imageConsumer);
        Object[] objectArray = new ImageConsumer[this.data.consumers.size()];
        this.data.consumers.copyInto(objectArray);
        this.produceHelper((ImageConsumer[])objectArray);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        if (this.data == null || this.data.pixels == null) {
            return;
        }
        this.startProduction(imageConsumer);
    }

    public static void setUserExponent(double d) {
        USER_EXPONENT = d;
    }

    public static void setDisplayExponent(double d) {
        DISPLAY_EXPONENT = d;
    }

    public boolean hasErrors() {
        if (this.errorList == null) {
            return false;
        }
        return this.errorList.size() > 0;
    }

    public boolean hasFatalError() {
        return this.hasErrors() && !(this.errorList.elementAt(this.errorList.size() - 1) instanceof PngExceptionSoft);
    }

    public Enumeration getErrors() {
        return this.errorList.elements();
    }

    public static void setAllErrorsFatal(boolean bl) {
        allFatal = bl;
    }

    public static void setProgressiveDisplay(boolean bl) {
        progressive = bl;
    }

    public Color getBackgroundColor() throws IOException {
        return (Color)this.getProperty("background");
    }

    public int getWidth() throws IOException {
        this.readToData();
        return this.data.header.width;
    }

    public int getHeight() throws IOException {
        this.readToData();
        return this.data.header.height;
    }

    public int getBitDepth() throws IOException {
        this.readToData();
        return this.data.header.depth;
    }

    public int getInterlaceType() throws IOException {
        this.readToData();
        return this.data.header.interlace;
    }

    public int getColorType() throws IOException {
        this.readToData();
        return this.data.header.colorType;
    }

    public boolean hasAlphaChannel() throws IOException {
        this.readToData();
        return this.data.header.alphaUsed;
    }

    public boolean isGrayscale() throws IOException {
        this.readToData();
        return !this.data.header.colorUsed;
    }

    public boolean isIndexedColor() throws IOException {
        this.readToData();
        return this.data.header.paletteUsed;
    }

    public Object getProperty(String string) throws IOException {
        this.readToData();
        return this.data.properties.get(string);
    }

    public Enumeration getProperties() throws IOException {
        this.readToData();
        return this.data.properties.keys();
    }

    public void getEverything() {
        this.startProduction(new DummyImageConsumer());
    }

    public boolean hasChunk(String string) {
        return this.data.chunks.get(new Integer(Chunk.stringToType(string))) != null;
    }

    public static void registerChunk(ChunkHandler chunkHandler, String string) throws PngException {
        if (string.length() < 4) {
            throw new PngException("Invalid chunk type length.");
        }
        int n = Chunk.stringToType(string);
        if (prototypes.containsKey(new Integer(n))) {
            throw new PngException("Chunk type already registered.");
        }
        if ((n & 0x20000000) == 0) {
            throw new PngException("Chunk must be ancillary.");
        }
        PngImage.registerChunk(new UserChunk(chunkHandler, n));
    }

    public Enumeration getSuggestedPalettes() throws IOException {
        this.readToData();
        return this.data.palettes.keys();
    }

    public int[][] getSuggestedPalette(String string) throws IOException {
        this.readToData();
        return (int[][])this.data.palettes.get(string);
    }

    public TextChunk getTextChunk(String string) throws IOException {
        this.readToData();
        return (TextChunk)this.data.textChunks.get(string);
    }

    public Enumeration getTextChunks() throws IOException {
        this.readToData();
        return this.data.textChunks.elements();
    }

    public Enumeration getGifExtensions() throws IOException {
        this.readToData();
        return this.data.gifExtensions.elements();
    }

    public void setFlushAfterNextProduction(boolean bl) {
        this.data.useFlush = bl;
    }

    private void flush() {
        if (this.data != null) {
            try {
                this.data.in_idat.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.data = null;
        }
    }

    private void init(InputStream inputStream) {
        this.data.properties.put("gamma", new Long(45455L));
        this.data.in_idat = new IDATInputStream(this, inputStream);
    }

    private synchronized void readToData() throws IOException {
        try {
            if (this.data == null) {
                throw new EOFException("Object has been flushed.");
            }
            this.data.in_idat.readToData();
        }
        catch (PngException pngException) {
            this.addError(pngException);
            throw pngException;
        }
    }

    private static void registerChunk(Chunk chunk) {
        prototypes.put(new Integer(chunk.type), chunk);
    }

    static Chunk getRegisteredChunk(int n) {
        Integer n2 = new Integer(n);
        if (prototypes.containsKey(n2)) {
            return ((Chunk)prototypes.get(n2)).copy();
        }
        try {
            String string = "com.sixlegs.image.png.Chunk_" + Chunk.typeToString(n);
            PngImage.registerChunk((Chunk)Class.forName(string).newInstance());
            return PngImage.getRegisteredChunk(n);
        }
        catch (Exception exception) {
            return new Chunk(n);
        }
    }

    Chunk getChunk(int n) {
        return (Chunk)this.data.chunks.get(new Integer(n));
    }

    void putChunk(int n, Chunk chunk) {
        this.data.chunks.put(new Integer(n), chunk);
    }

    void addError(Exception exception) {
        if (this.errorList == null) {
            this.errorList = new Vector();
        }
        this.errorList.addElement(exception);
    }

    void fillGammaTable() {
        try {
            long l = (Long)this.getProperty("gamma");
            int n = this.data.header.paletteUsed ? 255 : (1 << this.data.header.outputDepth) - 1;
            double d = USER_EXPONENT * 100000.0 / ((double)l * DISPLAY_EXPONENT);
            int n2 = 0;
            while (n2 <= n) {
                int n3 = (int)(Math.pow((double)n2 / (double)n, d) * 255.0);
                this.data.gammaTable[n2] = !this.data.header.colorUsed ? n3 | n3 << 8 | n3 << 16 : n3;
                ++n2;
            }
            if (this.data.palette != null) {
                this.data.palette.calculate();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void produceHelper(ImageConsumer[] var1_1) {
        block10: {
            try {
                this.readToData();
                var2_2 = 0;
                while (var2_2 < var1_1.length) {
                    var1_1[var2_2].setDimensions(this.data.header.width, this.data.header.height);
                    var1_1[var2_2].setProperties(this.data.properties);
                    var1_1[var2_2].setColorModel(this.data.header.model);
                    if (Data.access$5(this.data)) {
                        var1_1[var2_2].imageComplete(1);
                    }
                    ++var2_2;
                }
                if (Data.access$5(this.data)) {
                    return;
                }
                if (Data.access$1(this.data) == null) {
                    this.firstProduction(var1_1);
                } else {
                    this.setHints(var1_1);
                    var2_2 = 0;
                    while (var2_2 < var1_1.length) {
                        var1_1[var2_2].setPixels(0, 0, this.data.header.width, this.data.header.height, this.data.header.model, Data.access$1(this.data), 0, this.data.header.width);
                        var1_1[var2_2].imageComplete(3);
                        ++var2_2;
                    }
                }
                break block10;
            }
            catch (IOException var2_3) {
                Data.access$6(this.data, true);
                this.addError(var2_3);
                var3_4 = 0;
                ** while (var3_4 < var1_1.length)
            }
lbl-1000:
            // 1 sources

            {
                var1_1[var3_4].imageComplete(1);
                ++var3_4;
                continue;
            }
        }
        if (Data.access$3(this.data)) {
            this.flush();
        }
    }

    private void firstProduction(ImageConsumer[] imageConsumerArray) throws IOException {
        UnfilterInputStream unfilterInputStream = new UnfilterInputStream(this, this.data.in_idat);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(unfilterInputStream, 8192);
        PixelInputStream pixelInputStream = new PixelInputStream(this, bufferedInputStream);
        this.setHints(imageConsumerArray);
        if (this.data.header.interlace == 0) {
            this.produceNonInterlaced(imageConsumerArray, pixelInputStream);
        } else {
            this.produceInterlaced(imageConsumerArray, pixelInputStream);
        }
        int n = 0;
        while (n < imageConsumerArray.length) {
            imageConsumerArray[n].imageComplete(3);
            ++n;
        }
    }

    private void setHints(ImageConsumer[] imageConsumerArray) {
        int n = 0;
        while (n < imageConsumerArray.length) {
            if (progressive && this.data.pixels == null && this.data.header.interlace != 0) {
                imageConsumerArray[n].setHints(1);
            } else {
                imageConsumerArray[n].setHints(30);
            }
            ++n;
        }
    }

    private void produceNonInterlaced(ImageConsumer[] imageConsumerArray, PixelInputStream pixelInputStream) throws IOException {
        int n = this.data.header.width;
        int n2 = this.data.header.height;
        if (!this.data.useFlush) {
            this.data.pixels = new int[n * n2];
        }
        int[] nArray = new int[n + 8];
        int n3 = n;
        int n4 = n % pixelInputStream.fillSize;
        if (n4 > 0) {
            n3 += pixelInputStream.fillSize - n4;
        }
        boolean bl = false;
        int n5 = 0;
        while (n5 < n2) {
            pixelInputStream.read(nArray, 0, n3);
            int n6 = 0;
            while (n6 < imageConsumerArray.length) {
                imageConsumerArray[n6].setPixels(0, n5, n, 1, this.data.header.model, nArray, 0, n3);
                ++n6;
            }
            if (!this.data.useFlush) {
                System.arraycopy(nArray, 0, this.data.pixels, n * n5, n);
            }
            ++n5;
        }
    }

    private void produceInterlaced(ImageConsumer[] imageConsumerArray, PixelInputStream pixelInputStream) throws IOException {
        int n = this.data.header.width;
        int n2 = this.data.header.height;
        this.data.pixels = new int[n * n2];
        int[] nArray = new int[n + 8];
        int n3 = this.data.header.interlacer.numPasses();
        Interlacer interlacer = this.data.header.interlacer;
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            int n6 = interlacer.getPassWidth(n4);
            int n7 = n6 % pixelInputStream.fillSize;
            if (n7 > 0) {
                n6 += pixelInputStream.fillSize - n7;
            }
            int n8 = progressive ? interlacer.getBlockWidth(n4) : 1;
            int n9 = progressive ? interlacer.getBlockHeight(n4) : 1;
            int n10 = interlacer.getSpacingY(n4);
            int n11 = interlacer.getSpacingX(n4);
            int n12 = n10 * n;
            int n13 = interlacer.getOffsetX(n4);
            int n14 = interlacer.getOffsetY(n4);
            int n15 = n14 * n;
            while (n14 < n2) {
                pixelInputStream.read(nArray, 0, n6);
                n5 = n13;
                int n16 = 0;
                while (n5 < n) {
                    int n17 = Math.min(n8, n - n5);
                    int n18 = Math.min(n9, n2 - n14);
                    int n19 = n15 + n5;
                    int n20 = nArray[n16++];
                    while (n18-- > 0) {
                        int n21 = n19 + n17;
                        while (n19 < n21) {
                            ((Data)this.data).pixels[n19++] = n20;
                        }
                        n19 += n - n17;
                    }
                    n5 += n11;
                }
                n15 += n12;
                n14 += n10;
            }
            if (progressive) {
                n5 = 0;
                while (n5 < imageConsumerArray.length) {
                    imageConsumerArray[n5].setPixels(0, 0, n, n2, this.data.header.model, this.data.pixels, 0, n);
                    imageConsumerArray[n5].imageComplete(2);
                    ++n5;
                }
            }
            ++n4;
        }
        if (!progressive) {
            n4 = 0;
            while (n4 < imageConsumerArray.length) {
                imageConsumerArray[n4].setPixels(0, 0, n, n2, this.data.header.model, this.data.pixels, 0, n);
                ++n4;
            }
        }
    }

    public PngImage(String string) throws IOException {
        PngImage pngImage = this;
        if (pngImage == null) {
            throw null;
        }
        this.data = pngImage.new Data();
        FileInputStream fileInputStream = new FileInputStream(string);
        this.init(new BufferedInputStream(fileInputStream, 8192));
    }

    public PngImage(URL uRL) throws IOException {
        PngImage pngImage = this;
        if (pngImage == null) {
            throw null;
        }
        this.data = pngImage.new Data();
        InputStream inputStream = uRL.openConnection().getInputStream();
        this.init(new BufferedInputStream(inputStream, 8192));
    }

    public PngImage(InputStream inputStream) {
        PngImage pngImage = this;
        if (pngImage == null) {
            throw null;
        }
        this.data = pngImage.new Data();
        this.init(inputStream);
    }

    static {
        PngImage.registerChunk(new Chunk_IHDR());
        PngImage.registerChunk(new Chunk_PLTE());
        PngImage.registerChunk(new Chunk_IDAT());
        PngImage.registerChunk(new Chunk_IEND());
        PngImage.registerChunk(new Chunk_tRNS());
    }

    final class Data {
        private final Vector consumers = new Vector();
        private final Hashtable chunks = new Hashtable();
        private int[] pixels;
        private boolean produceFailed;
        private boolean useFlush = false;
        IDATInputStream in_idat;
        Chunk_IHDR header;
        Chunk_PLTE palette;
        final int[] gammaTable = new int[256];
        final Hashtable textChunks = new Hashtable();
        final Hashtable properties = new Hashtable();
        final Hashtable palettes = new Hashtable(1);
        final Vector gifExtensions = new Vector();

        static /* synthetic */ boolean access$5(Data data) {
            return data.produceFailed;
        }

        static /* synthetic */ void access$6(Data data, boolean bl) {
            data.produceFailed = bl;
        }

        private Data() {
        }
    }
}

