/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.util;

import java.util.Hashtable;

public class LazyTable
extends Hashtable {
    private static final Object PENDING = new String("Pending");

    public Object get(Object key) {
        Object value = super.get(key);
        if (value != PENDING && !(value instanceof ActiveValue) && !(value instanceof LazyValue)) {
            return value;
        }
        LazyTable lazyTable = this;
        synchronized (lazyTable) {
            value = super.get(key);
            if (value == PENDING) {
                do {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                } while ((value = super.get(key)) == PENDING);
                return value;
            }
            if (value instanceof LazyValue) {
                super.put(key, PENDING);
            } else if (!(value instanceof ActiveValue)) {
                return value;
            }
        }
        if (value instanceof LazyValue) {
            try {
                value = ((LazyValue)value).createValue(this);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                LazyTable lazyTable2 = this;
                synchronized (lazyTable2) {
                    if (value == null) {
                        super.remove(key);
                    } else {
                        super.put(key, value);
                    }
                    this.notify();
                }
                throw throwable;
            }
            Object var7_6 = null;
            LazyTable lazyTable3 = this;
            synchronized (lazyTable3) {
                if (value == null) {
                    super.remove(key);
                } else {
                    super.put(key, value);
                }
                this.notify();
            }
        }
        value = ((ActiveValue)value).createValue(this);
        return value;
    }

    public static interface LazyValue {
        public Object createValue(LazyTable var1);
    }

    public static interface ActiveValue {
        public Object createValue(LazyTable var1);
    }
}

