/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.kde;

import com.l2fprod.gui.plaf.skin.DefaultButton;
import com.l2fprod.gui.plaf.skin.SkinUtils;
import com.l2fprod.gui.plaf.skin.SkinWindowButton;
import com.l2fprod.gui.plaf.skin.impl.AbstractSkinFrame;
import com.l2fprod.gui.plaf.skin.impl.kde.KdeFrameBorder;
import com.l2fprod.util.IniFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;

class KdeFrame
extends AbstractSkinFrame {
    static final String[] TEXT_ALIGNMENTS = new String[]{"left", "middle", "right"};
    static final int LEFT = 0;
    static final int MIDDLE = 1;
    static final int RIGHT = 2;
    DefaultButton topSelected;
    DefaultButton topUnselected;
    int topHeight;
    Vector buttonList;
    int textShiftLeft;
    int textShiftRight;
    int textAlignment;
    boolean pixmapUnderTitle;
    boolean titleFrameShaded;
    Border border;

    public Dimension getTopPreferredSize() {
        return new Dimension(50, this.topHeight);
    }

    public SkinWindowButton[] getWindowButtons(int align) {
        Vector<SkinWindowButton> buttons = new Vector<SkinWindowButton>();
        int i = 0;
        int c = this.buttonList.size();
        while (i < c) {
            FrameButton newB = (FrameButton)this.buttonList.elementAt(i);
            if (newB.getAlign() == align) {
                buttons.addElement(newB.createButton());
            }
            ++i;
        }
        Object[] results = new SkinWindowButton[buttons.size()];
        buttons.copyInto(results);
        return results;
    }

    public boolean status() {
        return true;
    }

    public boolean installSkin(JComponent c) {
        if (this.border != null) {
            c.setBorder(this.border);
            c.setOpaque(false);
            return true;
        }
        return false;
    }

    public boolean paintTop(Graphics g, Component c, boolean isSelected, String title) {
        if (this.topSelected != null && this.topUnselected != null) {
            if (isSelected) {
                this.topSelected.paint(g, 0, 0, c);
            } else {
                this.topUnselected.paint(g, 0, 0, c);
            }
        } else {
            Color oldColor = g.getColor();
            if (isSelected) {
                g.setColor(UIManager.getColor("InternalFrame.activeTitleBackground"));
            } else {
                g.setColor(UIManager.getColor("InternalFrame.inactiveTitleBackground"));
            }
            g.fillRect(0, 0, ((JComponent)c).getWidth(), ((JComponent)c).getHeight());
            g.setColor(oldColor);
        }
        if (title != null) {
            Color oldColor;
            FontMetrics fm = g.getFontMetrics();
            int fmHeight = fm.getHeight() - fm.getLeading();
            int baseline = (this.topHeight - fmHeight) / 2 + fm.getAscent() + fm.getLeading();
            int width = fm.stringWidth(title);
            int x = 0;
            switch (this.textAlignment) {
                case 0: {
                    x = this.textShiftLeft;
                    break;
                }
                case 1: {
                    x = (((JComponent)c).getWidth() - this.textShiftLeft - this.textShiftRight) / 2 + this.textShiftLeft - width / 2;
                    break;
                }
                case 2: {
                    x = ((JComponent)c).getWidth() - width - this.textShiftRight;
                    break;
                }
            }
            if (!this.pixmapUnderTitle) {
                oldColor = g.getColor();
                if (isSelected) {
                    g.setColor(UIManager.getColor("InternalFrame.activeTitleBackground"));
                } else {
                    g.setColor(UIManager.getColor("InternalFrame.inactiveTitleBackground"));
                }
                g.fillRect(x, 0, width, ((JComponent)c).getHeight());
                g.setColor(oldColor);
            }
            if (isSelected && this.titleFrameShaded) {
                oldColor = g.getColor();
                g.setColor(oldColor.darker().darker());
                g.drawString(title, x + 1, baseline + 1);
                g.setColor(oldColor);
            }
            g.drawString(title, x, baseline);
        }
        return true;
    }

    public KdeFrame(IniFile ini, URL skinURL) throws Exception {
        block11: {
            Image image;
            this.topHeight = 17;
            this.textShiftLeft = 16;
            this.textShiftRight = 0;
            this.textAlignment = 0;
            this.pixmapUnderTitle = false;
            this.titleFrameShaded = false;
            String path = ini.getKeyValue("Window Titlebar", "TitlebarPixmapActive");
            if (path != null) {
                image = SkinUtils.loadImage(new URL(skinURL, path));
                this.topSelected = new DefaultButton(image, image.getWidth(null), image.getHeight(null), ini.getKeyIntValue("Window Titlebar", "TitlebarPixmapActiveTop"), ini.getKeyIntValue("Window Titlebar", "TitlebarPixmapActiveRight"), ini.getKeyIntValue("Window Titlebar", "TitlebarPixmapActiveBottom"), ini.getKeyIntValue("Window Titlebar", "TitlebarPixmapActiveLeft"));
                this.topHeight = this.topSelected.getHeight();
            }
            if ((path = ini.getKeyValue("Window Titlebar", "TitlebarPixmapInactive")) != null) {
                image = SkinUtils.loadImage(new URL(skinURL, path));
                this.topUnselected = new DefaultButton(image, image.getWidth(null), image.getHeight(null), ini.getKeyIntValue("Window Titlebar", "TitlebarPixmapActiveTop"), ini.getKeyIntValue("Window Titlebar", "TitlebarPixmapActiveRight"), ini.getKeyIntValue("Window Titlebar", "TitlebarPixmapActiveBottom"), ini.getKeyIntValue("Window Titlebar", "TitlebarPixmapActiveLeft"));
                this.topHeight = Math.max(this.topHeight, this.topUnselected.getHeight());
            }
            this.pixmapUnderTitle = "yes".equals(ini.getKeyValue("Window Titlebar", "PixmapUnderTitleText"));
            this.titleFrameShaded = "yes".equals(ini.getKeyValue("Window Titlebar", "TitleFrameShaded"));
            String textAlignmentValue = ini.getKeyValue("Window Titlebar", "TitleAlignment");
            if (textAlignmentValue != null) {
                textAlignmentValue = textAlignmentValue.toLowerCase();
                int i = 0;
                int c = TEXT_ALIGNMENTS.length;
                while (i < c) {
                    if (TEXT_ALIGNMENTS[i].equals(textAlignmentValue)) {
                        this.textAlignment = i;
                        break;
                    }
                    ++i;
                }
            }
            this.buttonList = new Vector();
            String letters = "ABCDEF";
            if (ini.getSection("Window Button Layout") == null) {
                ini.addSection("Window Button Layout");
                ini.setKeyValue("Window Button Layout", "ButtonA", "Off");
                ini.setKeyValue("Window Button Layout", "ButtonB", "Off");
                ini.setKeyValue("Window Button Layout", "ButtonC", "Off");
                ini.setKeyValue("Window Button Layout", "ButtonD", "Minimize");
                ini.setKeyValue("Window Button Layout", "ButtonE", "Maximize");
                ini.setKeyValue("Window Button Layout", "ButtonF", "Close");
            }
            int i = 0;
            int c = letters.length();
            while (i < c) {
                String button = ini.getKeyValue("Window Button Layout", "Button" + letters.charAt(i));
                if (button != null && !"Off".equalsIgnoreCase(button)) {
                    FrameButton fb = new FrameButton(ini, skinURL, button);
                    fb.setAlign(i < c / 2 ? 0 : 1);
                    if (fb.icon != null) {
                        if (i < c / 2) {
                            this.textShiftLeft += fb.icon.getIconWidth();
                        } else {
                            this.textShiftRight += fb.icon.getIconWidth();
                        }
                        this.topHeight = Math.max(this.topHeight, fb.icon.getIconHeight());
                    }
                    this.buttonList.addElement(fb);
                }
                ++i;
            }
            this.textShiftLeft += 4;
            this.textShiftRight += 4;
            if (ini.getSection("Window Border") == null || ini.getSection("Window Border").size() <= 0) break block11;
            this.border = new KdeFrameBorder(ini, skinURL);
        }
    }

    class FrameButton {
        ImageIcon icon;
        ImageIcon downIcon;
        ImageIcon inactiveIcon;
        int align;
        int action = -1;

        public void setAlign(int align) {
            this.align = align;
        }

        public int getAlign() {
            return this.align;
        }

        public SkinWindowButton createButton() {
            SkinWindowButton button = new SkinWindowButton(-1, (KdeFrame.this.topHeight - this.icon.getIconHeight()) / 2, this.align, this.action);
            if (this.icon != null) {
                button.setSize(this.icon.getIconWidth(), this.icon.getIconHeight());
                button.setNoFocusIcon(this.inactiveIcon);
                button.setNoFocusRolloverIcon(this.inactiveIcon);
                button.setIcon(this.icon);
                button.setRolloverIcon(this.icon);
                button.setPressedIcon(this.downIcon);
            }
            return button;
        }

        FrameButton(IniFile ini, URL skinURL, String command) throws Exception {
            String path;
            if ("Iconify".equals(command)) {
                command = "Minimize";
            }
            if ((path = ini.getKeyValue("Window Titlebar", command + "Button")) != null) {
                this.inactiveIcon = this.icon = new ImageIcon(SkinUtils.loadImage(new URL(skinURL, path)));
                this.downIcon = this.icon;
            }
            if ((path = ini.getKeyValue("Window Titlebar", command + "DownButton")) != null) {
                this.downIcon = new ImageIcon(SkinUtils.loadImage(new URL(skinURL, path)));
            }
            if ((path = ini.getKeyValue("Window Titlebar", command + "InactiveButton")) != null) {
                this.inactiveIcon = new ImageIcon(SkinUtils.loadImage(new URL(skinURL, path)));
            }
            if ("Maximize".equalsIgnoreCase(command)) {
                this.action = 22;
            } else if ("Minimize".equalsIgnoreCase(command)) {
                this.action = 23;
            } else if ("Close".equalsIgnoreCase(command)) {
                this.action = 0;
            }
        }
    }
}

