/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.SkinWindow;
import com.l2fprod.util.OS;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.JInternalFrame;

public interface Window {
    public static final String IS_SHADED_PROPERTY = "shaded";

    public Container getContainer();

    public void addPropertyChangeListener(PropertyChangeListener var1);

    public boolean isSelected();

    public void setSelected(boolean var1) throws PropertyVetoException;

    public boolean isIcon();

    public void setIcon(boolean var1) throws PropertyVetoException;

    public boolean isMaximum();

    public void setMaximum(boolean var1) throws PropertyVetoException;

    public boolean isShaded();

    public void setShaded(boolean var1);

    public boolean isMaximizable();

    public boolean isIconifiable();

    public boolean isClosable();

    public void setClosed(boolean var1) throws PropertyVetoException;

    public boolean isResizable();

    public String getTitle();

    public Icon getFrameIcon();

    public void dispatchEvent(AWTEvent var1);

    public static class InternalFrameWindow
    implements Window {
        JInternalFrame frame;
        boolean shaded = false;

        public void setSelected(boolean b) throws PropertyVetoException {
            this.frame.setSelected(b);
        }

        public void setIcon(boolean b) throws PropertyVetoException {
            this.frame.setIcon(b);
        }

        public void setMaximum(boolean b) throws PropertyVetoException {
            this.frame.setMaximum(b);
        }

        public void setShaded(boolean b) {
            if (b == this.shaded) {
                return;
            }
            if (b) {
                Rectangle bounds = this.frame.getBounds();
                Rectangle p = new Rectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                this.frame.putClientProperty("windowshadeBounds", p);
                this.frame.setBounds(p.x, p.y, p.width, this.frame.getMinimumSize().height - 2);
            } else {
                Point location = this.frame.getLocation();
                Rectangle p = (Rectangle)this.frame.getClientProperty("windowshadeBounds");
                this.frame.getDesktopPane().getDesktopManager().setBoundsForFrame(this.frame, location.x, location.y, p.width, p.height);
                this.frame.putClientProperty("windowshadeBounds", null);
            }
            this.shaded = b;
        }

        public void setClosed(boolean b) throws PropertyVetoException {
            if (OS.isOneDotThreeOrMore()) {
                try {
                    Class.forName("javax.swing.JInternalFrame").getMethod("doDefaultCloseAction", new Class[0]).invoke((Object)this.frame, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                if (!b) {
                    this.frame.setClosed(b);
                    return;
                }
                this.doDefaultCloseAction();
            }
        }

        public Container getContainer() {
            return this.frame;
        }

        public boolean isSelected() {
            return this.frame.isSelected();
        }

        public boolean isIcon() {
            return this.frame.isIcon();
        }

        public boolean isMaximum() {
            return this.frame.isMaximum();
        }

        public boolean isShaded() {
            return this.shaded;
        }

        public boolean isMaximizable() {
            return this.frame.isMaximizable();
        }

        public boolean isIconifiable() {
            return this.frame.isIconifiable();
        }

        public boolean isClosable() {
            return this.frame.isClosable();
        }

        public boolean isResizable() {
            return !this.isShaded() && this.frame.isResizable();
        }

        public String getTitle() {
            return this.frame.getTitle();
        }

        public Icon getFrameIcon() {
            return this.frame.getFrameIcon();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.frame.addPropertyChangeListener(listener);
        }

        public void dispatchEvent(AWTEvent event) {
            this.frame.dispatchEvent(event);
        }

        private final void doDefaultCloseAction() {
            int defaultCloseOperation = this.frame.getDefaultCloseOperation();
            this.frame.setDefaultCloseOperation(0);
            switch (defaultCloseOperation) {
                case 1: {
                    try {
                        this.frame.setClosed(true);
                        this.frame.setVisible(false);
                        if (!this.frame.isSelected()) break;
                        this.frame.setSelected(false);
                    }
                    catch (PropertyVetoException pve) {}
                    break;
                }
                case 2: {
                    try {
                        this.frame.setClosed(true);
                        this.frame.dispose();
                    }
                    catch (PropertyVetoException pve) {}
                    break;
                }
                case 3: {
                    System.exit(0);
                    break;
                }
                case 0: {
                    try {
                        this.frame.setClosed(true);
                        break;
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
            this.frame.setDefaultCloseOperation(defaultCloseOperation);
        }

        public InternalFrameWindow(JInternalFrame frame) {
            this.frame = frame;
        }
    }

    public static class SkinWindowWindow
    implements Window {
        SkinWindow frame;

        public void setSelected(boolean b) throws PropertyVetoException {
            this.frame.setSelected(b);
        }

        public void setIcon(boolean b) throws PropertyVetoException {
            this.frame.setIcon(b);
        }

        public void setMaximum(boolean b) throws PropertyVetoException {
            this.frame.setMaximum(b);
        }

        public void setShaded(boolean b) {
            this.frame.setShaded(b);
        }

        public void setClosed(boolean b) throws PropertyVetoException {
            this.frame.setClosed(b);
        }

        public Container getContainer() {
            return this.frame;
        }

        public boolean isSelected() {
            return this.frame.isSelected();
        }

        public boolean isIcon() {
            return this.frame.isIcon();
        }

        public boolean isMaximum() {
            return this.frame.isMaximum();
        }

        public boolean isMaximizable() {
            return this.frame.isMaximizable();
        }

        public boolean isShaded() {
            return this.frame.isShaded();
        }

        public boolean isIconifiable() {
            return this.frame.isIconifiable();
        }

        public boolean isClosable() {
            return this.frame.isClosable();
        }

        public boolean isResizable() {
            return !this.isShaded() && this.frame.isResizable();
        }

        public String getTitle() {
            return this.frame.getTitle();
        }

        public Icon getFrameIcon() {
            return this.frame.getFrameIcon();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            ((Component)this.frame).addPropertyChangeListener(listener);
        }

        public void dispatchEvent(AWTEvent event) {
            this.frame.dispatchEvent(event);
        }

        public SkinWindowWindow(SkinWindow frame) {
            this.frame = frame;
        }
    }
}

