/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.SkinWindow;
import com.l2fprod.gui.WindowManager;
import com.l2fprod.gui.plaf.skin.SkinTitlePane;
import com.l2fprod.gui.plaf.skin.SkinUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.JWindow;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

public class SkinWindowTitlePane
extends SkinTitlePane {
    protected MouseInputListener borderListener;

    protected void installListeners() {
        super.installListeners();
        this.borderListener = new BorderListener();
        this.frame.getContainer().addMouseListener(this.borderListener);
        this.frame.getContainer().addMouseMotionListener(this.borderListener);
        this.addMouseListener(this.borderListener);
        this.addMouseMotionListener(this.borderListener);
        MouseInputListener glassPaneDispatcher = this.createGlassPaneDispatcher();
        ((JWindow)this.frame.getContainer()).getGlassPane().addMouseListener(glassPaneDispatcher);
        ((JWindow)this.frame.getContainer()).getGlassPane().addMouseMotionListener(glassPaneDispatcher);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected MouseInputListener createGlassPaneDispatcher() {
        return new GlassPaneDispatcher();
    }

    public SkinWindowTitlePane(SkinWindow f) {
        super(f);
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            SkinWindow f = (SkinWindow)evt.getSource();
            String prop = evt.getPropertyName();
            Object newValue = evt.getNewValue();
            Object oldValue = evt.getOldValue();
            if ("closed".equals(prop)) {
                if (newValue == Boolean.TRUE) {
                    WindowManager.getWindowManager().closeWindow(f);
                }
            } else if ("maximum".equals(prop)) {
                if (newValue == Boolean.TRUE) {
                    WindowManager.getWindowManager().maximizeWindow(f);
                } else {
                    WindowManager.getWindowManager().minimizeWindow(f);
                }
            } else if ("icon".equals(prop)) {
                if (newValue == Boolean.TRUE) {
                    WindowManager.getWindowManager().iconifyWindow(f);
                } else {
                    WindowManager.getWindowManager().deiconifyWindow(f);
                }
            } else if ("selected".equals(prop)) {
                Component glassPane = f.getGlassPane();
                if (newValue == Boolean.TRUE && oldValue == Boolean.FALSE) {
                    WindowManager.getWindowManager().activateWindow(f);
                    glassPane.setVisible(false);
                } else if (newValue == Boolean.FALSE && oldValue == Boolean.TRUE) {
                    WindowManager.getWindowManager().deactivateWindow(f);
                    glassPane.setVisible(true);
                }
            } else if ("shaded".equals(prop)) {
                if (newValue == Boolean.TRUE) {
                    WindowManager.getWindowManager().shadeWindow(f);
                } else {
                    WindowManager.getWindowManager().unshadeWindow(f);
                }
            }
            SkinWindowTitlePane.this.enableActions();
        }
    }

    protected class GlassPaneDispatcher
    implements MouseInputListener {
        private Component mouseEventTarget = null;

        public void mousePressed(MouseEvent e) {
            if (SkinWindowTitlePane.this.borderListener != null) {
                SkinWindowTitlePane.this.borderListener.mousePressed(e);
            }
            this.forwardMouseEvent(e);
        }

        public void mouseEntered(MouseEvent e) {
            this.forwardMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
            this.forwardMouseEvent(e);
        }

        public void mouseExited(MouseEvent e) {
            this.forwardMouseEvent(e);
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            this.forwardMouseEvent(e);
        }

        public void mouseDragged(MouseEvent e) {
        }

        void retargetMouseEvent(int id, MouseEvent e) {
            Point p = SwingUtilities.convertPoint(((JWindow)SkinWindowTitlePane.this.frame.getContainer()).getContentPane(), e.getX(), e.getY(), this.mouseEventTarget);
            MouseEvent retargeted = new MouseEvent(this.mouseEventTarget, id, e.getWhen(), e.getModifiers(), p.x, p.y, e.getClickCount(), e.isPopupTrigger());
            this.mouseEventTarget.dispatchEvent(retargeted);
        }

        private final void setMouseTarget(Component target, MouseEvent e) {
            if (this.mouseEventTarget != null) {
                this.retargetMouseEvent(505, e);
            }
            this.mouseEventTarget = target;
            if (this.mouseEventTarget != null) {
                this.retargetMouseEvent(504, e);
            }
        }

        private final void forwardMouseEvent(MouseEvent e) {
            Component target = SkinUtils.findComponentAt(((JWindow)SkinWindowTitlePane.this.frame.getContainer()).getContentPane(), e.getX(), e.getY());
            if (target != null) {
                if (target != this.mouseEventTarget) {
                    this.setMouseTarget(target, e);
                }
                this.retargetMouseEvent(e.getID(), e);
            }
        }

        GlassPaneDispatcher() {
        }
    }

    protected class BorderListener
    extends MouseInputAdapter
    implements SwingConstants {
        protected final int NO_ACTION;
        protected final int RESIZE_NONE;
        int startX;
        int startY;
        Rectangle startingBounds;
        Rectangle newBounds = new Rectangle();
        int resizeDir;
        int resizeCornerSize = 5;

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1 && e.getSource() == SkinWindowTitlePane.this) {
                if (SkinWindowTitlePane.this.frame.isIconifiable() && SkinWindowTitlePane.this.frame.isIcon()) {
                    try {
                        SkinWindowTitlePane.this.frame.setIcon(false);
                    }
                    catch (PropertyVetoException e2) {}
                } else if (SkinWindowTitlePane.this.frame.isMaximizable()) {
                    if (!SkinWindowTitlePane.this.frame.isMaximum()) {
                        try {
                            SkinWindowTitlePane.this.frame.setMaximum(true);
                        }
                        catch (PropertyVetoException e2) {}
                    } else {
                        try {
                            SkinWindowTitlePane.this.frame.setMaximum(false);
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            switch (this.resizeDir) {
                case -1: {
                    break;
                }
                case 0: {
                    WindowManager.getWindowManager().endDraggingWindow((SkinWindow)SkinWindowTitlePane.this.frame.getContainer());
                    break;
                }
                default: {
                    WindowManager.getWindowManager().endResizingWindow((SkinWindow)SkinWindowTitlePane.this.frame.getContainer());
                }
            }
            this.startingBounds = null;
            this.resizeDir = -1;
        }

        public void mousePressed(MouseEvent e) {
            this.startX = e.getX();
            this.startY = e.getY();
            this.startingBounds = SkinWindowTitlePane.this.frame.getContainer().getBounds();
            if (!SkinWindowTitlePane.this.frame.isSelected()) {
                try {
                    SkinWindowTitlePane.this.frame.setSelected(true);
                }
                catch (PropertyVetoException e1) {
                    // empty catch block
                }
            }
            if (!SkinWindowTitlePane.this.frame.isResizable() || SkinWindowTitlePane.this.frame.isShaded() || e.getSource() == SkinWindowTitlePane.this) {
                this.resizeDir = 0;
                WindowManager.getWindowManager().beginDraggingWindow((SkinWindow)SkinWindowTitlePane.this.frame.getContainer());
                return;
            }
            if (e.getSource() == SkinWindowTitlePane.this.frame.getContainer()) {
                Dimension dim = SkinWindowTitlePane.this.frame.getContainer().getSize();
                if (e.getX() <= this.resizeCornerSize) {
                    this.resizeDir = e.getY() < this.resizeCornerSize ? 8 : (e.getY() > dim.height - this.resizeCornerSize ? 6 : 7);
                } else if (e.getX() >= dim.width - this.resizeCornerSize) {
                    this.resizeDir = e.getY() < this.resizeCornerSize ? 2 : (e.getY() > dim.height - this.resizeCornerSize ? 4 : 3);
                } else if (e.getY() <= this.resizeCornerSize) {
                    this.resizeDir = e.getX() < this.resizeCornerSize ? 8 : (e.getX() > dim.width - this.resizeCornerSize ? 2 : 1);
                } else if (e.getY() >= dim.height - this.resizeCornerSize) {
                    this.resizeDir = e.getX() < this.resizeCornerSize ? 6 : (e.getX() > dim.width - this.resizeCornerSize ? 4 : 5);
                }
                if (this.resizeDir != 0 && this.resizeDir != -1) {
                    WindowManager.getWindowManager().beginResizingWindow((SkinWindow)SkinWindowTitlePane.this.frame.getContainer(), this.resizeDir);
                }
                return;
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (this.startingBounds == null) {
                return;
            }
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), null);
            int deltaX = e.getX() - this.startX;
            int deltaY = e.getY() - this.startY;
            p = SkinWindowTitlePane.this.frame.getContainer().getLocation();
            if (e.getSource() == SkinWindowTitlePane.this) {
                if (SkinWindowTitlePane.this.frame.isMaximum()) {
                    return;
                }
                WindowManager.getWindowManager().dragWindow((SkinWindow)SkinWindowTitlePane.this.frame.getContainer(), p.x + deltaX, p.y + deltaY);
                return;
            }
            if (!SkinWindowTitlePane.this.frame.isResizable() || SkinWindowTitlePane.this.frame.isShaded()) {
                return;
            }
            Dimension min = SkinWindowTitlePane.this.frame.getContainer().getMinimumSize();
            Dimension max = SkinWindowTitlePane.this.frame.getContainer().getMaximumSize();
            int newX = p.x;
            int newY = p.y;
            int newW = SkinWindowTitlePane.this.frame.getContainer().getSize().width;
            int newH = SkinWindowTitlePane.this.frame.getContainer().getSize().height;
            switch (this.resizeDir) {
                case 0: {
                    return;
                }
                case 1: {
                    newX = this.startingBounds.x;
                    newY = this.startingBounds.y + deltaY;
                    newW = this.startingBounds.width;
                    newH = this.startingBounds.height - deltaY;
                    break;
                }
                case 2: {
                    newX = this.startingBounds.x;
                    newY = this.startingBounds.y + deltaY;
                    newW = this.startingBounds.width + deltaX;
                    newH = this.startingBounds.height - deltaY;
                    break;
                }
                case 3: {
                    newW = this.startingBounds.width + deltaX;
                    newH = this.startingBounds.height;
                    break;
                }
                case 4: {
                    newW = this.startingBounds.width + deltaX;
                    newH = this.startingBounds.height + deltaY;
                    break;
                }
                case 5: {
                    newW = this.startingBounds.width;
                    newH = this.startingBounds.height + deltaY;
                    break;
                }
                case 6: {
                    newX = this.startingBounds.x + deltaX;
                    newY = this.startingBounds.y;
                    newW = this.startingBounds.width - deltaX;
                    newH = this.startingBounds.height + deltaY;
                    break;
                }
                case 7: {
                    newX = this.startingBounds.x + deltaX;
                    newY = this.startingBounds.y;
                    newW = this.startingBounds.width - deltaX;
                    newH = this.startingBounds.height;
                    break;
                }
                case 8: {
                    newX = this.startingBounds.x + deltaX;
                    newY = this.startingBounds.y + deltaY;
                    newW = this.startingBounds.width - deltaX;
                    newH = this.startingBounds.height - deltaY;
                    break;
                }
                default: {
                    return;
                }
            }
            this.newBounds.x = newX;
            this.newBounds.y = newY;
            this.newBounds.width = newW;
            this.newBounds.height = newH;
            WindowManager.getWindowManager().resizeWindow((SkinWindow)SkinWindowTitlePane.this.frame.getContainer(), newX, newY, newW, newH);
        }

        public void mouseMoved(MouseEvent e) {
            if (!SkinWindowTitlePane.this.frame.isResizable()) {
                return;
            }
            if (e.getSource() == SkinWindowTitlePane.this.frame.getContainer()) {
                Container comp = SkinWindowTitlePane.this.frame.getContainer();
                Dimension dim = comp.getSize();
                if (e.getX() <= this.resizeCornerSize) {
                    if (e.getY() < this.resizeCornerSize) {
                        comp.setCursor(Cursor.getPredefinedCursor(6));
                    } else if (e.getY() > dim.height - this.resizeCornerSize) {
                        comp.setCursor(Cursor.getPredefinedCursor(4));
                    } else {
                        comp.setCursor(Cursor.getPredefinedCursor(10));
                    }
                } else if (e.getX() >= dim.width - this.resizeCornerSize) {
                    if (e.getY() < this.resizeCornerSize) {
                        comp.setCursor(Cursor.getPredefinedCursor(7));
                    } else if (e.getY() > dim.height - this.resizeCornerSize) {
                        comp.setCursor(Cursor.getPredefinedCursor(5));
                    } else {
                        comp.setCursor(Cursor.getPredefinedCursor(11));
                    }
                } else if (e.getY() <= this.resizeCornerSize) {
                    if (e.getX() < this.resizeCornerSize) {
                        comp.setCursor(Cursor.getPredefinedCursor(6));
                    } else if (e.getX() > dim.width - this.resizeCornerSize) {
                        comp.setCursor(Cursor.getPredefinedCursor(7));
                    } else {
                        comp.setCursor(Cursor.getPredefinedCursor(8));
                    }
                } else if (e.getY() >= dim.height - this.resizeCornerSize) {
                    if (e.getX() < this.resizeCornerSize) {
                        comp.setCursor(Cursor.getPredefinedCursor(4));
                    } else if (e.getX() > dim.width - this.resizeCornerSize) {
                        comp.setCursor(Cursor.getPredefinedCursor(5));
                    } else {
                        comp.setCursor(Cursor.getPredefinedCursor(9));
                    }
                } else {
                    comp.setCursor(Cursor.getPredefinedCursor(0));
                }
                return;
            }
            SkinWindowTitlePane.this.frame.getContainer().setCursor(Cursor.getPredefinedCursor(0));
        }

        public void mouseExited(MouseEvent e) {
            SkinWindowTitlePane.this.frame.getContainer().setCursor(Cursor.getPredefinedCursor(0));
        }

        BorderListener() {
            this.NO_ACTION = -1;
            this.RESIZE_NONE = 0;
        }
    }
}

