/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.SkinWindow;
import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import com.l2fprod.gui.plaf.skin.SkinWindowButton;
import com.l2fprod.gui.plaf.skin.Window;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameEvent;

public class SkinTitlePane
extends JComponent {
    public static final int ICON_OFFSET = 16;
    public static final int ALIGN_TOP_LEFT = 0;
    public static final int ALIGN_TOP_RIGHT = 1;
    public static final int CLOSE_ACTION = 0;
    public static final int MAXIMIZE_ACTION = 22;
    public static final int MINIMIZE_ACTION = 23;
    public static final int NO_ACTION = -1;
    protected static final String CLOSE_CMD = "Close";
    protected static final String ICONIFY_CMD = "Minimize";
    protected static final String RESTORE_CMD = "Restore";
    protected static final String MAXIMIZE_CMD = "Maximize";
    protected static final String SHADE_CMD = "Shade";
    protected JMenuBar menuBar;
    protected JMenu windowMenu;
    protected Window frame;
    protected Color selectedTitleColor;
    protected Color selectedTextColor;
    protected Color notSelectedTitleColor;
    protected Color notSelectedTextColor;
    protected PropertyChangeListener propertyChangeListener;
    protected Action closeAction;
    protected Action maximizeAction;
    protected Action iconifyAction;
    protected Action restoreAction;
    protected Action shadeAction;
    boolean systemMenuAdded = false;
    private Skin skin = SkinLookAndFeel.getSkin();
    private static /* synthetic */ Class class$Ljavax$swing$JInternalFrame;

    public Window getWindow() {
        return this.frame;
    }

    public Dimension getPreferredSize() {
        return this.skin.getFrame().getTopPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.skin.getFrame().getTopPreferredSize();
    }

    public void addNotify() {
        super.addNotify();
        this.addSystemMenuItems(this.windowMenu);
        this.enableActions();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.windowMenu != null) {
            this.windowMenu.removeAll();
            this.systemMenuAdded = false;
        }
        this.uninstallDefaults();
    }

    public void paintComponent(Graphics g) {
        boolean isSelected = this.frame.isSelected();
        Font f = g.getFont();
        if (this.frame.getTitle() != null) {
            if (isSelected) {
                g.setColor(this.selectedTextColor);
            } else {
                g.setColor(this.notSelectedTextColor);
            }
            g.setFont(UIManager.getFont("InternalFrame.titleFont"));
        }
        this.skin.getFrame().paintTop(g, this, isSelected, this.frame.getTitle());
        g.setFont(f);
    }

    protected void setButtonIcons() {
    }

    protected void installTitlePane() {
        this.installDefaults();
        this.installListeners();
        this.createActions();
        this.enableActions();
        this.setLayout(this.createLayout());
        this.assembleSystemMenu();
        this.add(this.menuBar);
        this.createButtons();
        this.setOpaque(true);
    }

    protected void createActions() {
        this.maximizeAction = new MaximizeAction();
        this.maximizeAction.setEnabled(true);
        this.iconifyAction = new IconifyAction();
        this.iconifyAction.setEnabled(true);
        this.closeAction = new CloseAction();
        this.closeAction.setEnabled(true);
        this.restoreAction = new RestoreAction();
        this.restoreAction.setEnabled(true);
        this.shadeAction = new ShadeAction();
        this.shadeAction.setEnabled(true);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.frame.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void installDefaults() {
        this.selectedTitleColor = UIManager.getColor("InternalFrame.activeTitleBackground");
        this.selectedTextColor = UIManager.getColor("InternalFrame.activeTitleForeground");
        this.notSelectedTitleColor = UIManager.getColor("InternalFrame.inactiveTitleBackground");
        this.notSelectedTextColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
    }

    protected void uninstallDefaults() {
    }

    protected void createButtons() {
        int c;
        int i;
        SkinWindowButton[] buttons = this.skin.getFrame().getWindowButtons(0);
        if (buttons != null) {
            i = 0;
            c = buttons.length;
            while (i < c) {
                this.addButton(buttons[i]);
                ++i;
            }
        }
        if ((buttons = this.skin.getFrame().getWindowButtons(1)) != null) {
            i = 0;
            c = buttons.length;
            while (i < c) {
                this.addButton(buttons[i]);
                ++i;
            }
        }
    }

    protected void addButton(SkinWindowButton button) {
        button.setWindow(this.frame);
        switch (button.getWindowAction()) {
            case 0: {
                button.addActionListener(this.closeAction);
                this.registerButtonForAction(button, this.closeAction);
                break;
            }
            case 22: {
                button.addActionListener(this.maximizeAction);
                this.registerButtonForAction(button, this.maximizeAction);
                break;
            }
            case 23: {
                button.addActionListener(this.iconifyAction);
                this.registerButtonForAction(button, this.iconifyAction);
                break;
            }
        }
        this.add(button);
    }

    protected void assembleSystemMenu() {
        this.menuBar = this.createSystemMenuBar();
        this.windowMenu = this.createSystemMenu();
        this.menuBar.add(this.windowMenu);
        this.enableActions();
    }

    protected void addSystemMenuItems(JMenu systemMenu) {
        if (!this.systemMenuAdded) {
            JMenuItem mi = systemMenu.add(this.restoreAction);
            mi.setMnemonic('R');
            mi = systemMenu.add(this.iconifyAction);
            mi.setMnemonic('n');
            mi = systemMenu.add(this.maximizeAction);
            mi.setMnemonic('x');
            systemMenu.add(this.shadeAction);
            systemMenu.add(new JSeparator());
            mi = systemMenu.add(this.closeAction);
            mi.setMnemonic('C');
            this.systemMenuAdded = true;
        }
    }

    protected JMenu createSystemMenu() {
        return new JMenu("    ");
    }

    protected JMenuBar createSystemMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setBorderPainted(false);
        return this.menuBar;
    }

    protected void showSystemMenu() {
        this.windowMenu.doClick();
    }

    protected void postClosingEvent(JInternalFrame frame) {
        InternalFrameEvent e = new InternalFrameEvent(frame, 25550);
        if ((class$Ljavax$swing$JInternalFrame != null ? class$Ljavax$swing$JInternalFrame : (class$Ljavax$swing$JInternalFrame = SkinTitlePane.class$("javax.swing.JInternalFrame"))).getClassLoader() == null) {
            try {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(e);
                return;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        frame.dispatchEvent(e);
    }

    protected void enableActions() {
        this.restoreAction.setEnabled(this.frame.isMaximum() || this.frame.isIcon());
        this.maximizeAction.setEnabled(this.frame.isMaximizable());
        this.iconifyAction.setEnabled(this.frame.isIconifiable() && !this.frame.isIcon());
        this.closeAction.setEnabled(this.frame.isClosable());
        this.shadeAction.setEnabled(!this.frame.isMaximum() && !this.frame.isIcon());
        this.doLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    protected PropertyChangeListener createActionChangeListener(AbstractButton b) {
        return new ActionChangedListener(b);
    }

    private final void registerButtonForAction(AbstractButton b, Action a) {
        PropertyChangeListener actionPropertyChangeListener = this.createActionChangeListener(b);
        a.addPropertyChangeListener(actionPropertyChangeListener);
        b.setEnabled(a.isEnabled());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SkinTitlePane(SkinWindow f) {
        this(new Window.SkinWindowWindow(f));
    }

    public SkinTitlePane(JInternalFrame f) {
        this(new Window.InternalFrameWindow(f));
    }

    public SkinTitlePane(Window f) {
        this.frame = f;
        this.installTitlePane();
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if ("selected".equals(prop)) {
                SkinTitlePane.this.repaint();
                return;
            }
            SkinTitlePane.this.enableActions();
        }
    }

    public class TitlePaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(100, 18);
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            int w = SkinTitlePane.this.getWidth();
            int nmembers = c.getComponentCount();
            int atlX = 2;
            int atrX = 0;
            SkinTitlePane.this.menuBar.setBounds(atlX, (SkinTitlePane.this.getHeight() - 16) / 2, 16, 16);
            atlX += 18;
            int i = 1;
            while (i < nmembers) {
                SkinWindowButton m = (SkinWindowButton)c.getComponent(i);
                m.setVisible(m.isEnabled());
                if (m.isEnabled()) {
                    if (m.getAlign() == 0) {
                        if (m.getXCoord() == -1) {
                            m.setLocation(atlX, Math.max(m.getYCoord(), 1));
                            atlX += m.getWidth();
                        } else {
                            m.setLocation(m.getXCoord(), m.getYCoord());
                        }
                    } else if (m.getAlign() == 1) {
                        if (m.getXCoord() == -1) {
                            m.setLocation(w - atrX - m.getWidth(), Math.max(m.getYCoord(), 1));
                            atrX += m.getWidth();
                        } else {
                            m.setLocation(w - m.getXCoord(), m.getYCoord());
                        }
                    }
                }
                ++i;
            }
        }
    }

    public class CloseAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (SkinTitlePane.this.frame.isClosable()) {
                try {
                    SkinTitlePane.this.frame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public CloseAction() {
            super(SkinTitlePane.CLOSE_CMD);
        }
    }

    public class MaximizeAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (SkinTitlePane.this.frame.isMaximizable()) {
                if (!SkinTitlePane.this.frame.isMaximum()) {
                    try {
                        SkinTitlePane.this.frame.setMaximum(true);
                    }
                    catch (PropertyVetoException e5) {}
                } else {
                    try {
                        SkinTitlePane.this.frame.setMaximum(false);
                        if (SkinTitlePane.this.frame.isIconifiable() && SkinTitlePane.this.frame.isIcon()) {
                            SkinTitlePane.this.frame.setIcon(false);
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }

        public MaximizeAction() {
            super(SkinTitlePane.MAXIMIZE_CMD);
        }
    }

    public class IconifyAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (SkinTitlePane.this.frame.isIconifiable()) {
                if (!SkinTitlePane.this.frame.isIcon()) {
                    try {
                        SkinTitlePane.this.frame.setIcon(true);
                    }
                    catch (PropertyVetoException e1) {}
                } else {
                    try {
                        SkinTitlePane.this.frame.setIcon(false);
                        if (SkinTitlePane.this.frame.isMaximizable() && SkinTitlePane.this.frame.isMaximum()) {
                            SkinTitlePane.this.frame.setMaximum(false);
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }

        public IconifyAction() {
            super(SkinTitlePane.ICONIFY_CMD);
        }
    }

    public class RestoreAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            if (SkinTitlePane.this.frame.isMaximizable() && SkinTitlePane.this.frame.isMaximum()) {
                try {
                    SkinTitlePane.this.frame.setMaximum(false);
                }
                catch (PropertyVetoException e4) {}
            } else if (SkinTitlePane.this.frame.isIconifiable() && SkinTitlePane.this.frame.isIcon()) {
                try {
                    SkinTitlePane.this.frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        public RestoreAction() {
            super(SkinTitlePane.RESTORE_CMD);
        }
    }

    public class ShadeAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent event) {
            SkinTitlePane.this.frame.setShaded(!SkinTitlePane.this.frame.isShaded());
        }

        public ShadeAction() {
            super(SkinTitlePane.SHADE_CMD);
        }
    }

    public class SystemMenuBar
    extends JMenuBar {
        public boolean isFocusTraversable() {
            return false;
        }

        public boolean isOpaque() {
            return true;
        }

        public void requestFocus() {
        }

        public void paint(Graphics g) {
            Icon icon = SkinTitlePane.this.frame.getFrameIcon();
            if (icon == null) {
                icon = UIManager.getIcon("InternalFrame.icon");
            }
            if (icon != null) {
                if (icon instanceof ImageIcon && (icon.getIconWidth() > 16 || icon.getIconHeight() > 16)) {
                    Image img = ((ImageIcon)icon).getImage();
                    ((ImageIcon)icon).setImage(img.getScaledInstance(16, 16, 4));
                }
                icon.paintIcon(this, g, 0, 0);
            }
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        AbstractButton button;

        public void setTarget(AbstractButton b) {
            this.button = b;
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getPropertyName().equals("Name")) {
                String text = (String)e.getNewValue();
                this.button.setText(text);
                this.button.repaint();
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.button.setEnabled(enabledState);
                this.button.repaint();
            } else if (e.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)e.getNewValue();
                this.button.setIcon(icon);
                this.button.invalidate();
                this.button.repaint();
            }
        }

        ActionChangedListener(AbstractButton b) {
            this.setTarget(b);
        }
    }

    private class NoFocusButton
    extends JButton {
        public boolean isFocusTraversable() {
            return false;
        }

        public boolean isOpaque() {
            return true;
        }

        public void requestFocus() {
        }

        public NoFocusButton() {
            this.setFocusPainted(false);
        }
    }
}

